/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    private static final ExecutorService gameThreadPool;
    private static final ScheduledExecutorService scheduledPool;
    private static ExecutorService service;

    private static ExecutorService getGameThreadPool() {
        return gameThreadPool;
    }

    private static ScheduledExecutorService getScheduledPool() {
        return scheduledPool;
    }

    public static final ExecutorService getComputingPool(float loadFactor) {
        return Executors.newFixedThreadPool((int)((float)Runtime.getRuntime().availableProcessors() / (1.0f - loadFactor)));
    }

    public static boolean isMultiCoreSystem() {
        return Runtime.getRuntime().availableProcessors() > 1;
    }

    public static void invokeInGameThread(Runnable toRun) {
        ThreadUtil.getGameThreadPool().execute(toRun);
    }

    public static ScheduledFuture<?> delay(int milliseconds, Runnable inputUpdater) {
        return ThreadUtil.getScheduledPool().schedule(inputUpdater, (long)milliseconds, TimeUnit.MILLISECONDS);
    }

    public static boolean isGameThread() {
        return Thread.currentThread().getName().startsWith("Game");
    }

    public static ExecutorService getServicePool() {
        return service;
    }

    public static void refreshServicePool() {
        service = Executors.newWorkStealingPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T limit(Callable<T> task, long millis) {
        T result;
        Future<T> future = null;
        try {
            future = service.submit(task);
            result = future.get(millis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithTimeout(Callable<T> task, int milliseconds) {
        T result;
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<T> future = executor.submit(task);
        try {
            result = future.get(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        finally {
            future.cancel(true);
        }
        return result;
    }

    static {
        System.out.printf("(ThreadUtil first call): Running on a machine with %d cpu core(s)%n", Runtime.getRuntime().availableProcessors());
        gameThreadPool = Executors.newCachedThreadPool(new WorkerThreadFactory("Game"));
        scheduledPool = Executors.newScheduledThreadPool(2, new WorkerThreadFactory("Delayed"));
        service = Executors.newWorkStealingPool();
    }

    private static class WorkerThreadFactory
    implements ThreadFactory {
        private int countr = 0;
        private String prefix = "";

        public WorkerThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.prefix + "-" + this.countr++);
        }
    }
}

