/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.collect.ImmutableSortedMap;
import forge.item.PaperCard;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class TextUtil {
    static ImmutableSortedMap<Integer, String> romanMap = ((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)ImmutableSortedMap.naturalOrder().put((Object)1000, "M")).put((Object)900, "CM")).put((Object)500, "D")).put((Object)400, "CD")).put((Object)100, "C")).put((Object)90, "XC")).put((Object)50, "L")).put((Object)40, "XL")).put((Object)10, "X")).put((Object)9, "IX")).put((Object)5, "V")).put((Object)4, "IV")).put((Object)1, "I")).build();
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private static final char CHAR_UNDEFINED = '\uffff';
    public static final String[] ARTICLE_WORDS = new String[]{"A", "An", "The"};

    public static String toRoman(int number) {
        if (number <= 0) {
            return "";
        }
        int l = romanMap.floorKey(number);
        return romanMap.get(l) + TextUtil.toRoman(number - l);
    }

    public static String normalizeText(String text) {
        if (text == null) {
            return "";
        }
        return Normalizer.normalize(text, Normalizer.Form.NFD);
    }

    public static String decimalFormat(float value) {
        return df.format(value);
    }

    public static String safeToString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String mapToString(Map<String, ?> map) {
        StringBuilder mapAsString = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, ?> p : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                mapAsString.append("; ");
            }
            mapAsString.append(p.getKey()).append(" => ").append(p.getValue() == null ? "(null)" : p.getValue().toString());
        }
        return mapAsString.toString();
    }

    public static String[] split(CharSequence input, char delimiter) {
        return TextUtil.splitWithParenthesis(input, delimiter, Integer.MAX_VALUE, '\u0000', '\u0000', true);
    }

    public static String[] split(CharSequence input, char delimiter, int limit) {
        return TextUtil.splitWithParenthesis(input, delimiter, limit, '\u0000', '\u0000', true);
    }

    public static String[] splitWithParenthesis(CharSequence input, char delimiter) {
        return TextUtil.splitWithParenthesis(input, delimiter, Integer.MAX_VALUE, '(', ')', true);
    }

    public static String[] splitWithParenthesis(CharSequence input, char delimiter, char openPar, char closePar) {
        return TextUtil.splitWithParenthesis(input, delimiter, Integer.MAX_VALUE, openPar, closePar, true);
    }

    public static String[] splitWithParenthesis(CharSequence input, char delimiter, int limit) {
        return TextUtil.splitWithParenthesis(input, delimiter, limit, '(', ')', true);
    }

    public static String[] splitWithParenthesis(CharSequence input, char delimiter, char openPar, char closePar, int limit) {
        return TextUtil.splitWithParenthesis(input, delimiter, limit, openPar, closePar, true);
    }

    public static String[] splitWithParenthesis(CharSequence input, char delimiter, int maxEntries, char openPar, char closePar, boolean skipEmpty) {
        ArrayList<String> result = new ArrayList<String>();
        boolean trimParenthesis = openPar == closePar && openPar > '\u0000';
        int nPar = 0;
        int len = input.length();
        int start = 0;
        int idx = 1;
        for (int iC = 0; iC < len; ++iC) {
            char c = input.charAt(iC);
            if (closePar > '\u0000' && c == closePar && nPar > 0) {
                --nPar;
            } else if (openPar > '\u0000' && c == openPar) {
                ++nPar;
            }
            if (c != delimiter || nPar != 0 || idx >= maxEntries) continue;
            if (iC > start || !skipEmpty) {
                result.add(input.subSequence(start, iC).toString());
                ++idx;
            }
            start = iC + 1;
        }
        if (len > start || !skipEmpty) {
            result.add(input.subSequence(start, len).toString());
        }
        String[] toReturn = result.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return trimParenthesis ? StringUtils.stripAll(toReturn, String.valueOf(openPar)) : toReturn;
    }

    public static String join(Iterable<String> strs, String delim) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String enumToLabel(Enum<?> val) {
        return val.toString().substring(0, 1).toUpperCase(Locale.ENGLISH) + val.toString().substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String buildFourColumnList(String firstLine, Iterable<PaperCard> cAnteRemoved) {
        StringBuilder sb = new StringBuilder(firstLine);
        int i = 0;
        for (PaperCard cp : cAnteRemoved) {
            if (i != 0) {
                sb.append(", ");
            }
            if (i % 4 == 0) {
                sb.append("\n");
            }
            sb.append(cp);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static String splitCompoundWord(String word, PhraseCase phraseCase) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    builder.append(" ");
                }
                switch (phraseCase) {
                    case Title: {
                        builder.append(ch);
                        break;
                    }
                    case Sentence: {
                        if (i > 0) {
                            builder.append(ch);
                            break;
                        }
                        builder.append(Character.toLowerCase(ch));
                        break;
                    }
                    case Lower: {
                        builder.append(Character.toLowerCase(ch));
                        break;
                    }
                }
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static String capitalize(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    public static String concatWithSpace(String ... s2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length; ++i) {
            sb.append(s2[i]);
            if (i >= s2.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String concatNoSpace(String ... s2) {
        StringBuilder sb = new StringBuilder();
        for (String str : s2) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String enclosedParen(String s2) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(s2);
        sb.append(")");
        return sb.toString();
    }

    public static String enclosedBracket(String s2) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(s2);
        sb.append("]");
        return sb.toString();
    }

    public static String enclosedSingleQuote(String s2) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(s2);
        sb.append("'");
        return sb.toString();
    }

    public static String enclosedDoubleQuote(String s2) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(s2);
        sb.append("\"");
        return sb.toString();
    }

    public static String addSuffix(String s2, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(s2);
        sb.append(suffix);
        return sb.toString();
    }

    public static String addPrefix(String prefix, String s2) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(s2);
        return sb.toString();
    }

    public static String fastReplace(String str, String target, String replacement) {
        if (str == null) {
            return null;
        }
        int targetLength = target.length();
        if (targetLength == 0) {
            return str;
        }
        int idx2 = str.indexOf(target);
        if (idx2 < 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(targetLength > replacement.length() ? str.length() : str.length() * 2);
        int idx1 = 0;
        do {
            sb.append(str, idx1, idx2);
            sb.append(replacement);
        } while ((idx2 = str.indexOf(target, idx1 = idx2 + targetLength)) > 0);
        sb.append(str, idx1, str.length());
        return sb.toString();
    }

    public static String toManaString(String ManaProduced) {
        if (ManaProduced == "mana" || ManaProduced.contains("Combo") || ManaProduced.contains("Any")) {
            return "mana";
        }
        return "{" + TextUtil.fastReplace(ManaProduced, " ", "}{") + "}";
    }

    public static String toSortableName(String printedName) {
        if (printedName.startsWith("\"")) {
            printedName = printedName.substring(1);
        }
        return TextUtil.moveArticleToEnd(printedName).toLowerCase().replaceAll("[^\\s'0-9a-z]", "");
    }

    public static String moveArticleToEnd(String str) {
        for (String articleWord : ARTICLE_WORDS) {
            if (!str.startsWith(articleWord + " ")) continue;
            str = str.substring(articleWord.length() + 1) + " " + articleWord;
            return str;
        }
        return str;
    }

    public static enum PhraseCase {
        Title,
        Sentence,
        Lower;

    }
}

