/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RuntimeVersion {
    private static Pattern versionNumberPattern = Pattern.compile("([1-9][0-9]*((\\.0)*\\.[0-9]*)*(_[0-9]+)?)");
    private static Pattern preReleasePattern = Pattern.compile("([a-zA-Z0-9]+)");
    private static Pattern buildNumberPattern = Pattern.compile("(0|[1-9][0-9]*)");
    private static Pattern buildInformationPattern = Pattern.compile("([-a-zA-Z0-9.]+)");
    private static Pattern versionStringPattern1 = Pattern.compile(versionNumberPattern + "(-" + preReleasePattern + ")?\\+" + buildNumberPattern + "(-" + buildInformationPattern + ")?");
    private static Pattern versionStringPattern2 = Pattern.compile(versionNumberPattern + "-" + preReleasePattern + "(-" + buildInformationPattern + ")?");
    private static Pattern versionStringPattern3 = Pattern.compile(versionNumberPattern + "(\\+?-" + buildInformationPattern + ")?");
    private static Pattern versionStringPattern4 = Pattern.compile(versionNumberPattern + "(-" + preReleasePattern + ")?");
    private int major;
    private int minor;
    private int securityLevel;
    private int update;
    private String preReleaseIdentifier;
    private int buildNumber;
    private String buildInformation;

    private RuntimeVersion(String versionString) {
        Matcher matcher = versionNumberPattern.matcher(versionString);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Improperly formatted version string provided: " + versionString);
        }
        String[] versionNumbers = matcher.group().split("[._]");
        if (versionNumbers.length >= 1) {
            this.major = Integer.parseInt(versionNumbers[0]);
        }
        if (versionNumbers.length >= 2) {
            this.minor = Integer.parseInt(versionNumbers[1]);
        }
        if (versionNumbers.length >= 3) {
            this.securityLevel = Integer.parseInt(versionNumbers[2]);
        }
        if (versionNumbers.length >= 4) {
            this.update = Integer.parseInt(versionNumbers[3]);
        }
        if (versionStringPattern1.matcher(versionString).find()) {
            Matcher infoMatcher = preReleasePattern.matcher(versionString);
            if (infoMatcher.find()) {
                this.preReleaseIdentifier = infoMatcher.group();
            }
            infoMatcher = buildNumberPattern.matcher(versionString);
            infoMatcher.find();
            this.buildNumber = Integer.parseInt(infoMatcher.group());
            infoMatcher = buildInformationPattern.matcher(versionString);
            if (infoMatcher.find()) {
                this.buildInformation = infoMatcher.group();
            }
        } else if (versionStringPattern2.matcher(versionString).find()) {
            Matcher infoMatcher = preReleasePattern.matcher(versionString);
            infoMatcher.find();
            this.preReleaseIdentifier = infoMatcher.group();
            infoMatcher = buildInformationPattern.matcher(versionString);
            if (infoMatcher.find()) {
                this.buildInformation = infoMatcher.group();
            }
        } else if (versionStringPattern3.matcher(versionString).find()) {
            Matcher infoMatcher = buildInformationPattern.matcher(versionString);
            if (infoMatcher.find()) {
                this.buildInformation = infoMatcher.group();
            }
        } else if (versionStringPattern4.matcher(versionString).find()) {
            Matcher infoMatcher = preReleasePattern.matcher(versionString);
            if (infoMatcher.find()) {
                this.preReleaseIdentifier = infoMatcher.group();
            }
        } else {
            throw new IllegalArgumentException("Improperly formatted version string provided: " + versionString);
        }
    }

    public static RuntimeVersion of(String versionString) {
        return new RuntimeVersion(versionString);
    }

    public String toString() {
        return "1." + this.minor + "." + this.securityLevel + "_" + this.update;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public int getUpdate() {
        return this.update;
    }

    public String getPreReleaseIdentifier() {
        return this.preReleaseIdentifier;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildInformation() {
        return this.buildInformation;
    }
}

