/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.util.TextUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.TypeUtils;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T makeDefaultInstanceOf(Class<? extends T> cls) {
        if (null == cls) {
            throw new IllegalArgumentException("Class<? extends T> cls must not be null");
        }
        try {
            Constructor<T> c = cls.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(TextUtil.concatWithSpace("No default constructor found in class", cls.getName()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(TextUtil.concatWithSpace("Can't instantiate class", cls.getName(), "using default constructor"));
        }
    }

    public static <T> T safeCast(Object obj, Class<T> type) {
        if (type.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    public static boolean isInstance(Object obj, Class<?> type) {
        if (Array.class.equals(type)) {
            return obj.getClass().isArray();
        }
        return TypeUtils.isInstance(obj, type);
    }
}

