/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.badlogic.gdx.math.Vector2;

public class PhysicsObject {
    private final Vector2 position;
    private final Vector2 velocity;
    private final Vector2 acceleration;
    private boolean allowVelocitySignChange;

    public PhysicsObject(Vector2 position0, Vector2 velocity0) {
        this(position0, velocity0, new Vector2(0.0f, 0.0f), false);
    }

    public PhysicsObject(Vector2 position0, Vector2 velocity0, Vector2 acceleration0, boolean allowVelocitySignChange0) {
        this.position = position0;
        this.velocity = velocity0;
        this.acceleration = acceleration0;
        this.allowVelocitySignChange = allowVelocitySignChange0;
    }

    public void setDecel(float decelX, float decelY) {
        if (this.velocity.x > 0.0f) {
            decelX = -decelX;
        }
        if (this.velocity.y > 0.0f) {
            decelY = -decelY;
        }
        this.acceleration.set(decelX, decelY);
        this.allowVelocitySignChange = false;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public Vector2 getAcceleration() {
        return this.acceleration;
    }

    public void stop() {
        this.velocity.set(0.0f, 0.0f);
        this.acceleration.set(0.0f, 0.0f);
    }

    public boolean isMoving() {
        return this.velocity.x != 0.0f || this.velocity.y != 0.0f || this.acceleration.x != 0.0f || this.acceleration.y != 0.0f;
    }

    public void advance(float dt) {
        float signum;
        if (this.acceleration.x == 0.0f) {
            this.position.x += this.velocity.x * dt;
        } else {
            signum = Math.signum(this.velocity.x);
            this.position.x += (this.velocity.x + 0.5f * this.acceleration.x * dt) * dt;
            this.velocity.x += this.acceleration.x * dt;
            if (!this.allowVelocitySignChange && Math.signum(this.velocity.x) != signum) {
                this.velocity.x = 0.0f;
                this.acceleration.x = 0.0f;
            }
        }
        if (this.acceleration.y == 0.0f) {
            this.position.y += this.velocity.y * dt;
        } else {
            signum = Math.signum(this.velocity.y);
            this.position.y += (this.velocity.y + 0.5f * this.acceleration.y * dt) * dt;
            this.velocity.y += this.acceleration.y * dt;
            if (!this.allowVelocitySignChange && Math.signum(this.velocity.y) != signum) {
                this.velocity.y = 0.0f;
                this.acceleration.y = 0.0f;
            }
        }
    }
}

