/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.io.IOException;
import java.io.OutputStream;

public class MultiplexOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public MultiplexOutputStream(OutputStream ... streams) {
        if (streams == null) {
            throw new IllegalArgumentException("streams cannot be null.");
        }
        this.streams = streams;
    }

    @Override
    public final void write(int b) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(b);
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(b, off, len);
        }
    }
}

