/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.game.GameObject;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import org.apache.commons.lang3.StringUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    public static String formatMessage(String message, Player player, Object related) {
        if (related instanceof Player && message.contains("{player")) {
            String noun = MessageUtil.mayBeYou(player, related);
            message = TextUtil.fastReplace(TextUtil.fastReplace(message, "{player}", noun), "{player's}", Lang.getInstance().getPossesive(noun));
        }
        return message;
    }

    public static String formatMessage(String message, PlayerView player, Object related) {
        if (related instanceof PlayerView && message.contains("{player")) {
            String noun = MessageUtil.mayBeYou(player, related);
            message = TextUtil.fastReplace(TextUtil.fastReplace(message, "{player}", noun), "{player's}", Lang.getInstance().getPossesive(noun));
        }
        return message;
    }

    public static String formatNotificationMessage(SpellAbility sa, Player player, GameObject target, String value) {
        if (sa == null || sa.getApi() == null || sa.getHostCard() == null) {
            return String.valueOf(value);
        }
        String choser = StringUtils.capitalize(MessageUtil.mayBeYou(player, (Object)target));
        switch (sa.getApi()) {
            case ChoosePlayer: 
            case ChooseDirection: 
            case Clash: 
            case DigMultiple: 
            case Seek: {
                return value;
            }
            case ChooseColor: 
            case Mana: {
                return sa.hasParam("Random") ? Localizer.getInstance().getMessage("lblRandomColorChosen", value) : Localizer.getInstance().getMessage("lblPlayerPickedChosen", choser, value);
            }
            case ChooseNumber: {
                if (sa.hasParam("Secretly")) {
                    return value;
                }
                return sa.hasParam("Random") ? Localizer.getInstance().getMessage("lblPlayerRandomChosenNumberIs", MessageUtil.mayBeYou(player, (Object)target), value) : Localizer.getInstance().getMessage("lblPlayerChoosesNumberIs", MessageUtil.mayBeYou(player, (Object)target), value);
            }
            case ChooseType: {
                return sa.hasParam("AtRandom") ? Localizer.getInstance().getMessage("lblRandomTypeChosen", value) : Localizer.getInstance().getMessage("lblPlayerPickedChosen", choser, value);
            }
            case FlipACoin: {
                String flipper = StringUtils.capitalize(MessageUtil.mayBeYou(player, (Object)target));
                return sa.hasParam("NoCall") ? Localizer.getInstance().getMessage("lblPlayerFlipComesUpValue", Lang.getInstance().getPossesive(flipper), value) : Localizer.getInstance().getMessage("lblPlayerActionFlip", flipper, Lang.joinVerb(flipper, value));
            }
            case GenericChoice: {
                if (sa.hasParam("Secretly") || sa.hasParam("ShowChoice") && sa.getParam("ShowChoice").equals("Description")) {
                    return value;
                }
            }
            case Protection: {
                return Localizer.getInstance().getMessage("lblPlayerChooseValue", choser, value);
            }
            case RollDice: 
            case RollPlanarDice: 
            case PutCounter: {
                return value;
            }
            case Vote: {
                if (sa.hasParam("Secretly")) {
                    return value;
                }
                String chooser = StringUtils.capitalize(MessageUtil.mayBeYou(player, (Object)target));
                return Localizer.getInstance().getMessage("lblPlayerVoteValue", chooser, value);
            }
        }
        String tgt = MessageUtil.mayBeYou(player, (Object)target);
        if (tgt.equals("(null)")) {
            return Localizer.getInstance().getMessage("lblCardEffectValueIs", CardTranslation.getTranslatedName(sa.getHostCard().getName()), value);
        }
        return Localizer.getInstance().getMessage("lblCardEffectToTargetValueIs", CardTranslation.getTranslatedName(sa.getHostCard().getName()), tgt, value);
    }

    public static String mayBeYou(Player player, Object what) {
        return what == null ? "(null)" : (what == player ? Localizer.getInstance().getMessage("lblYou", new Object[0]) : what.toString());
    }

    public static String mayBeYou(PlayerView player, Object what) {
        return what == null ? "(null)" : (what == player ? Localizer.getInstance().getMessage("lblYou", new Object[0]) : what.toString());
    }
}

