/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.badlogic.gdx.files.FileHandle;
import forge.Forge;
import forge.gui.GuiBase;
import forge.util.BuildInfo;
import forge.util.ImageFetcher;
import forge.util.TextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class LibGDXImageFetcher
extends ImageFetcher {
    @Override
    protected Runnable getDownloadTask(String[] downloadUrls, String destPath, Runnable notifyObservers) {
        return new LibGDXDownloadTask(downloadUrls, destPath, notifyObservers);
    }

    private static class LibGDXDownloadTask
    implements Runnable {
        private final String[] downloadUrls;
        private final String destPath;
        private final Runnable notifyObservers;

        LibGDXDownloadTask(String[] downloadUrls, String destPath, Runnable notifyObservers) {
            this.downloadUrls = downloadUrls;
            this.destPath = destPath;
            this.notifyObservers = notifyObservers;
        }

        private void doFetch(String urlToDownload) throws IOException {
            String newdespath;
            String string = newdespath = urlToDownload.contains(".fullborder.") || urlToDownload.startsWith("https://api.scryfall.com/cards/") ? TextUtil.fastReplace(this.destPath, ".full.", ".fullborder.") : this.destPath;
            if (!newdespath.contains(".full") && urlToDownload.startsWith("https://api.scryfall.com/cards/")) {
                newdespath = newdespath.replace(".jpg", ".fullborder.jpg");
            }
            URL url = new URL(urlToDownload);
            System.out.println("Attempting to fetch: " + url);
            URLConnection c = url.openConnection();
            c.setRequestProperty("User-Agent", BuildInfo.getUserAgent());
            InputStream is = c.getInputStream();
            FileHandle destFile = new FileHandle(newdespath + ".tmp");
            System.out.println(newdespath);
            destFile.parent().mkdirs();
            try (OutputStream out = Files.newOutputStream(destFile.file().toPath(), new OpenOption[0]);){
                Forge.getDeviceAdapter().convertToJPEG(is, out);
                is.close();
            }
            destFile.moveTo(new FileHandle(newdespath));
            System.out.println("Saved image to " + newdespath);
            GuiBase.getInterface().invokeInEdtLater(this.notifyObservers);
        }

        private String tofullBorder(String imageurl) {
            if (!imageurl.contains(".full.jpg")) {
                return imageurl;
            }
            try {
                URL url = new URL(imageurl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", BuildInfo.getUserAgent());
                if (conn.getResponseCode() == 404) {
                    imageurl = TextUtil.fastReplace(imageurl, ".full.jpg", ".fullborder.jpg");
                }
                conn.disconnect();
                return imageurl;
            }
            catch (IOException ex) {
                return imageurl;
            }
        }

        @Override
        public void run() {
            for (String urlToDownload : this.downloadUrls) {
                boolean isPlanechaseBG = urlToDownload.startsWith("https://downloads.cardforge.org/images/planes/");
                try {
                    if (isPlanechaseBG) {
                        this.doFetch(urlToDownload);
                        break;
                    }
                    this.doFetch(this.tofullBorder(urlToDownload));
                    break;
                }
                catch (IOException e) {
                    if (isPlanechaseBG) {
                        System.out.println("Failed to download planechase background [" + this.destPath + "] image: " + e.getMessage());
                        continue;
                    }
                    System.out.println("Failed to download card [" + this.destPath + "] image: " + e.getMessage());
                    if (!urlToDownload.contains("tokens")) continue;
                    int setIndex = urlToDownload.lastIndexOf(95);
                    int typeIndex = urlToDownload.lastIndexOf(46);
                    String setlessFilename = urlToDownload.substring(0, setIndex);
                    String extension = urlToDownload.substring(typeIndex);
                    urlToDownload = setlessFilename + extension;
                    try {
                        this.doFetch(this.tofullBorder(urlToDownload));
                        break;
                    }
                    catch (IOException t2) {
                        System.out.println("Failed to download setless token [" + this.destPath + "]: " + e.getMessage());
                    }
                }
            }
        }
    }
}

