/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import forge.item.InventoryItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ItemPool<T extends InventoryItem>
implements Iterable<Map.Entry<T, Integer>>,
Serializable {
    private static final long serialVersionUID = 6572047177527559797L;
    protected final Map<T, Integer> items;
    private final Class<T> myClass;

    public ItemPool(Class<T> cls) {
        this(new ConcurrentHashMap(), cls);
    }

    public static <Tin extends InventoryItem, Tout extends InventoryItem> ItemPool<Tout> createFrom(ItemPool<Tin> from, Class<Tout> clsHint) {
        ItemPool<Tout> result = new ItemPool<Tout>(clsHint);
        if (from != null) {
            for (Map.Entry<Tin, Integer> entry : from) {
                InventoryItem srcKey = (InventoryItem)entry.getKey();
                if (!clsHint.isInstance(srcKey)) continue;
                result.add(srcKey, entry.getValue());
            }
        }
        return result;
    }

    public static <Tin extends InventoryItem, Tout extends InventoryItem> ItemPool<Tout> createFrom(Iterable<Tin> from, Class<Tout> clsHint) {
        ItemPool<Tout> result = new ItemPool<Tout>(clsHint);
        if (from != null) {
            for (InventoryItem srcKey : from) {
                if (!clsHint.isInstance(srcKey)) continue;
                result.add(srcKey, 1);
            }
        }
        return result;
    }

    protected ItemPool(Map<T, Integer> items0, Class<T> cls) {
        this.items = items0 != null ? items0 : new ConcurrentHashMap<T, Integer>();
        this.myClass = cls;
    }

    @Override
    public final Iterator<Map.Entry<T, Integer>> iterator() {
        return this.items.entrySet().iterator();
    }

    public final boolean contains(T item) {
        return this.items.containsKey(item);
    }

    public final int count(T item) {
        if (item == null) {
            return 0;
        }
        Integer boxed = this.items.get(item);
        return boxed == null ? 0 : boxed;
    }

    public final int countAll() {
        int count = 0;
        for (Map.Entry<T, Integer> e : this) {
            count += e.getValue().intValue();
        }
        return count;
    }

    public int countAll(Predicate<T> condition) {
        int count = 0;
        for (Integer v : Maps.filterKeys(this.items, condition).values()) {
            count += v.intValue();
        }
        return count;
    }

    public final <U extends InventoryItem> int countAll(Predicate<U> condition, Class<U> cls) {
        int count = 0;
        Map<T, Integer> matchingKeys = Maps.filterKeys(this.items, item -> cls.isInstance(item) && condition.apply(item));
        for (Integer i : matchingKeys.values()) {
            count += i.intValue();
        }
        return count;
    }

    public final int countDistinct() {
        return this.items.size();
    }

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    public final List<T> toFlatList() {
        ArrayList<InventoryItem> result = new ArrayList<InventoryItem>();
        for (Map.Entry<T, Integer> e : this) {
            for (int i = 0; i < e.getValue(); ++i) {
                result.add((InventoryItem)e.getKey());
            }
        }
        return result;
    }

    public Map<String, Integer> toNameLookup() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<T, Integer> e : this) {
            result.put(((InventoryItem)e.getKey()).getName(), e.getValue());
        }
        return result;
    }

    public Class<T> getMyClass() {
        return this.myClass;
    }

    public ItemPool<T> getView() {
        return new ItemPool<T>(Collections.unmodifiableMap(this.items), this.getMyClass());
    }

    public void add(T item) {
        this.add(item, 1);
    }

    public void add(T item, int amount) {
        if (item == null || amount <= 0) {
            return;
        }
        this.items.put(item, this.count(item) + amount);
    }

    public void addAllFlat(Iterable<T> itms) {
        for (InventoryItem item : itms) {
            this.add(item);
        }
    }

    public void addAll(Iterable<Map.Entry<T, Integer>> map) {
        for (Map.Entry<T, Integer> e : map) {
            this.add((InventoryItem)e.getKey(), e.getValue());
        }
    }

    public <U extends InventoryItem> void addAllOfTypeFlat(Iterable<U> itms) {
        for (InventoryItem item : itms) {
            if (!this.myClass.isInstance(item)) continue;
            this.add(item);
        }
    }

    public <U extends InventoryItem> void addAllOfType(Iterable<Map.Entry<U, Integer>> map) {
        for (Map.Entry<U, Integer> e : map) {
            if (!this.myClass.isInstance(e.getKey())) continue;
            this.add((InventoryItem)e.getKey(), e.getValue());
        }
    }

    public boolean remove(T item) {
        return this.remove(item, 1);
    }

    public boolean remove(T item, int amount) {
        int count = this.count(item);
        if (count == 0 || amount <= 0) {
            return false;
        }
        if (count <= amount) {
            this.items.remove(item);
        } else {
            this.items.put(item, count - amount);
        }
        return true;
    }

    public boolean removeAll(T item) {
        return this.items.remove(item) != null;
    }

    public void removeAll(Iterable<Map.Entry<T, Integer>> map) {
        for (Map.Entry<T, Integer> e : map) {
            this.remove((InventoryItem)e.getKey(), e.getValue());
        }
    }

    public void removeAllFlat(Iterable<T> flat) {
        for (InventoryItem e : flat) {
            this.remove(e);
        }
    }

    public void clear() {
        this.items.clear();
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemPool && this.items.equals(((ItemPool)obj).items);
    }
}

