/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FileSection {
    private final Map<String, String> lines;
    public static final Pattern DOLLAR_SIGN_KV_SEPARATOR = Pattern.compile(Pattern.quote("$"));
    public static final Pattern ARROW_KV_SEPARATOR = Pattern.compile(Pattern.quote("->"));
    public static final Pattern EQUALS_KV_SEPARATOR = Pattern.compile(Pattern.quote("="));
    public static final Pattern COLON_KV_SEPARATOR = Pattern.compile(Pattern.quote(":"));
    private static final String BAR_PAIR_SPLITTER = Pattern.quote("|");
    private static Table<String, Pattern, Map<String, String>> parseToMapCache = HashBasedTable.create();

    protected final Map<String, String> getLines() {
        return this.lines;
    }

    protected FileSection() {
        this(new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
    }

    protected FileSection(Map<String, String> lines0) {
        this.lines = lines0;
    }

    public static Map<String, String> parseToMap(String line, Pattern kvSeparator) {
        Map<String, String> result = parseToMapCache.get(line, kvSeparator);
        if (result != null) {
            return result;
        }
        result = FileSection.parseToMapImpl(line, kvSeparator);
        parseToMapCache.put(line, kvSeparator, result);
        return result;
    }

    private static Map<String, String> parseToMapImpl(String line, Pattern kvSeparator) {
        String[] pairs;
        if (StringUtils.isEmpty(line)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String dd : pairs = line.split(BAR_PAIR_SPLITTER)) {
            String[] v = kvSeparator.split(dd, 2);
            result.put(v[0].trim(), v.length > 1 ? v[1].trim() : "");
        }
        return Collections.unmodifiableMap(result);
    }

    public static FileSection parse(Iterable<String> lines, Pattern kvSeparator) {
        FileSection result = new FileSection();
        for (String dd : lines) {
            String[] v = kvSeparator.split(dd, 2);
            result.lines.put(v[0].trim(), v.length > 1 ? v[1].trim() : "");
        }
        return result;
    }

    public String get(String fieldName) {
        return this.lines.get(fieldName);
    }

    public String get(String fieldName, String defaultValue) {
        return this.lines.containsKey(fieldName) ? this.lines.get(fieldName) : defaultValue;
    }

    public boolean contains(String keyName) {
        return this.lines.containsKey(keyName);
    }

    public double getDouble(String fieldName) {
        return this.getDouble(fieldName, 0.0);
    }

    public double getDouble(String fieldName, double defaultValue) {
        try {
            if (this.get(fieldName) == null) {
                return defaultValue;
            }
            NumberFormat format = NumberFormat.getInstance(Locale.US);
            Number number = format.parse(this.get(fieldName));
            return number.doubleValue();
        }
        catch (NumberFormatException | ParseException ex) {
            return defaultValue;
        }
    }

    public int getInt(String fieldName) {
        return this.getInt(fieldName, 0);
    }

    public int getInt(String fieldName, int defaultValue) {
        try {
            return Integer.parseInt(this.get(fieldName));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String fieldName) {
        return this.getBoolean(fieldName, false);
    }

    public boolean getBoolean(String fieldName, boolean defaultValue) {
        String s2 = this.get(fieldName);
        if (s2 == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(s2);
    }

    public static Map<String, List<String>> parseSections(List<String> source) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        String currentSection = "";
        ArrayList<String> currentList = null;
        for (String s2 : source) {
            String st = s2.trim();
            if (st.length() == 0) continue;
            if (st.startsWith("[") && st.endsWith("]")) {
                String newSection;
                if (currentList != null && currentList.size() > 0) {
                    Object oldVal = result.get(currentSection);
                    if (oldVal != null && oldVal instanceof List) {
                        currentList.addAll((List)oldVal);
                    }
                    result.put(currentSection, currentList);
                }
                currentSection = newSection = st.substring(1, st.length() - 1);
                currentList = null;
                continue;
            }
            if (currentList == null) {
                currentList = new ArrayList<String>();
            }
            currentList.add(st);
        }
        if (currentList != null && currentList.size() > 0) {
            Object oldVal = result.get(currentSection);
            if (oldVal != null && oldVal instanceof List) {
                currentList.addAll((List)oldVal);
            }
            result.put(currentSection, (List<String>)currentList);
        }
        return result;
    }
}

