/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.collect.ImmutableList;

public final class EnumUtil {
    private EnumUtil() {
    }

    public static ImmutableList<String> getNames(Class<? extends Enum<?>> enumType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Enum<?> type : enumType.getEnumConstants()) {
            builder.add(type.name());
        }
        return builder.build();
    }

    public static String getEnumDisplayName(Enum<?> value) {
        boolean uppercase = true;
        String name = value.name();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '_') {
                builder.append(' ');
                uppercase = true;
                continue;
            }
            if (uppercase) {
                builder.append(ch);
                uppercase = false;
                continue;
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }
}

