/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.util.Utils;

public class FToggleSwitch
extends FDisplayObject {
    private static final float BORDER_THICKNESS = Utils.scale(1.0f);
    private static final float INSETS = Utils.scale(2.0f);
    private static final float PADDING = Utils.scale(3.0f);
    private FSkinFont font;
    private String offText;
    private String onText;
    private boolean toggled;
    private boolean pressed;
    private FEvent.FEventHandler changedHandler;

    private static FSkinColor getActiveColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    }

    private static FSkinColor getPressedColor() {
        return FToggleSwitch.getActiveColor().stepColor(-30);
    }

    private static FSkinColor getInactiveColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_INACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_INACTIVE);
    }

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public FToggleSwitch() {
        this("Off", "On");
    }

    public FToggleSwitch(String offText0, String onText0) {
        this.offText = offText0;
        this.onText = onText0;
        this.font = FSkinFont.get(14);
    }

    public String getOffText() {
        return this.offText;
    }

    public void setOffText(String offText0) {
        this.offText = offText0;
    }

    public String getOnText() {
        return this.onText;
    }

    public void setOnText(String onText0) {
        this.onText = onText0;
    }

    public void setFontSize(int fontSize0) {
        this.font = FSkinFont.get(fontSize0);
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean b0) {
        this.setToggled(b0, false);
    }

    private void setToggled(boolean b0, boolean raiseChangedEvent) {
        if (this.toggled == b0) {
            return;
        }
        this.toggled = b0;
        if (raiseChangedEvent && this.changedHandler != null) {
            this.changedHandler.handleEvent(new FEvent(this, FEvent.FEventType.CHANGE, b0));
        }
    }

    public FEvent.FEventHandler getChangedHandler() {
        return this.changedHandler;
    }

    public void setChangedHandler(FEvent.FEventHandler changedHandler0) {
        this.changedHandler = changedHandler0;
    }

    public float getAutoSizeWidth(float height) {
        float onTextWidth = this.font.getBounds((CharSequence)this.onText).width;
        float offTextWidth = this.font.getBounds((CharSequence)this.offText).width;
        float width = onTextWidth > offTextWidth ? onTextWidth : offTextWidth;
        width += 2.0f * (PADDING + INSETS + 1.0f);
        return width += height - PADDING;
    }

    @Override
    public final boolean press(float x, float y) {
        this.pressed = true;
        return true;
    }

    @Override
    public final boolean release(float x, float y) {
        this.pressed = false;
        return true;
    }

    @Override
    public final boolean tap(float x, float y, int count) {
        this.setToggled(!this.toggled, true);
        return true;
    }

    @Override
    public final boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        if (this.contains(this.getLeft() + x, this.getTop() + y)) {
            if (x < this.getHeight()) {
                this.setToggled(false, true);
                return true;
            }
            if (x > this.getWidth() - this.getHeight()) {
                this.setToggled(true, true);
                return true;
            }
            this.pressed = true;
        } else {
            this.pressed = false;
        }
        return false;
    }

    @Override
    public final boolean panStop(float x, float y) {
        if (this.pressed) {
            this.pressed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean fling(float velocityX, float velocityY) {
        return Math.abs(velocityX) > Math.abs(velocityY);
    }

    @Override
    public void draw(Graphics g2) {
        String text;
        float x = BORDER_THICKNESS;
        float y = BORDER_THICKNESS;
        float w = this.getWidth() - 2.0f * x;
        float h2 = this.getHeight() - 2.0f * y;
        g2.fillRect(FToggleSwitch.getInactiveColor(), x, y, w, h2);
        g2.drawRect(BORDER_THICKNESS, FToggleSwitch.getForeColor(), x, y, w, h2);
        float switchWidth = w - h2 + PADDING;
        if (this.toggled) {
            x = w - switchWidth + 1.0f;
            text = this.onText;
        } else {
            text = this.offText;
        }
        w = switchWidth - 2.0f * INSETS;
        g2.fillRect(this.pressed ? FToggleSwitch.getPressedColor() : FToggleSwitch.getActiveColor(), x += INSETS, y += INSETS, w, h2 -= 2.0f * INSETS);
        g2.drawText(text, this.font, FToggleSwitch.getForeColor(), x += PADDING, y, w -= 2.0f * PADDING, h2, false, 1, true);
    }
}

