/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.gui.interfaces.ITextField;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.util.TextBounds;
import forge.util.Utils;

public class FTextField
extends FDisplayObject
implements ITextField {
    private static final FSkinFont DEFAULT_FONT = FSkinFont.get(14);
    private static final float BORDER_THICKNESS = Utils.scale(1.0f);
    public static final float PADDING = Utils.scale(5.0f);
    private FEvent.FEventHandler changedHandler;
    private String text;
    private String ghostText;
    private String textBeforeKeyInput;
    protected FSkinFont font;
    protected FSkinFont renderedFont;
    private int alignment;
    private int selStart;
    private int selLength;
    private boolean isEditing;
    private boolean readOnly;
    private boolean isNumeric;
    private final FPopupMenu contextMenu = new FPopupMenu(){

        @Override
        protected void buildMenu() {
            if (FTextField.this.text.length() > 0) {
                if (!FTextField.this.readOnly) {
                    this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblCut", new Object[0]), e -> {
                        Forge.getClipboard().setContents(FTextField.this.getSelectedText());
                        FTextField.this.textBeforeKeyInput = FTextField.this.text;
                        FTextField.this.insertText("");
                        FTextField.this.endEdit();
                    }));
                }
                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblCopy", new Object[0]), e -> Forge.getClipboard().setContents(FTextField.this.getSelectedText())));
            }
            if (!FTextField.this.readOnly) {
                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblPaste", new Object[0]), e -> {
                    FTextField.this.textBeforeKeyInput = FTextField.this.text;
                    FTextField.this.insertText(Forge.getClipboard().getContents());
                    FTextField.this.endEdit();
                }));
            }
        }
    };

    protected static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    protected static FSkinColor getBackColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_THEME2);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_THEME2);
    }

    protected static FSkinColor getGhostTextColor() {
        return FTextField.getForeColor().alphaColor(0.7f);
    }

    protected static FSkinColor getSelColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    }

    public static float getDefaultHeight() {
        return FTextField.getDefaultHeight(DEFAULT_FONT);
    }

    public static float getDefaultHeight(FSkinFont font0) {
        return font0.getCapHeight() * 3.0f;
    }

    public FTextField() {
        this("");
    }

    public FTextField(String text0) {
        this.text = text0;
        this.ghostText = "";
        this.setFont(DEFAULT_FONT);
        this.alignment = 8;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text0) {
        if (text0 == null) {
            text0 = "";
        }
        this.text = text0;
        this.selStart = 0;
        this.selLength = 0;
    }

    protected void insertText(String text0) {
        int selEnd;
        int insertLength = text0.length();
        if (this.selStart > 0) {
            text0 = this.text.substring(0, this.selStart) + text0;
        }
        if ((selEnd = this.selStart + this.selLength) < this.text.length()) {
            text0 = text0 + this.text.substring(selEnd);
        }
        this.text = text0;
        this.selStart += insertLength;
        this.selLength = 0;
    }

    public String getSelectedText() {
        if (this.selLength > 0) {
            return this.text.substring(this.selStart, this.selLength);
        }
        return "";
    }

    public String getGhostText() {
        return this.ghostText;
    }

    public void setGhostText(String ghostText0) {
        if (ghostText0 == null) {
            ghostText0 = "";
        }
        this.ghostText = ghostText0;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment0) {
        this.alignment = alignment0;
    }

    public FSkinFont getFont() {
        return this.font;
    }

    public void setFont(FSkinFont font0) {
        this.font = font0;
        this.renderedFont = font0;
        this.setHeight(FTextField.getDefaultHeight(this.font));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setIsNumeric(boolean isNumeric0) {
        this.isNumeric = isNumeric0;
    }

    public void setReadOnly(boolean readOnly0) {
        this.readOnly = readOnly0;
    }

    public FEvent.FEventHandler getChangedHandler() {
        return this.changedHandler;
    }

    public void setChangedHandler(FEvent.FEventHandler changedHandler0) {
        this.changedHandler = changedHandler0;
    }

    public float getAutoSizeWidth() {
        return this.getLeftPadding() + this.font.getBounds((CharSequence)this.text).width + this.getRightPadding();
    }

    private int getCharIndexAtPoint(float x, float y) {
        float charLeft = this.getTextLeft();
        if (x < charLeft) {
            return 0;
        }
        if (x >= charLeft + this.renderedFont.getBounds((CharSequence)this.text).width) {
            return this.text.length();
        }
        for (int i = 0; i < this.text.length(); ++i) {
            float charWidth = this.renderedFont.getBounds((CharSequence)this.text.substring((int)i, (int)(i + 1))).width;
            if (x < charLeft + charWidth / 2.0f) {
                return i;
            }
            charLeft += charWidth;
        }
        return this.text.length();
    }

    @Override
    public boolean press(float x, float y) {
        this.placeTextCursor(x, y);
        return false;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        this.placeTextCursor(x, y);
        return true;
    }

    private void placeTextCursor(float x, float y) {
        if (this.isEditing) {
            this.selStart = this.getCharIndexAtPoint(x, y);
            this.selLength = 0;
        }
    }

    @Override
    public boolean longPress(float x, float y) {
        if (this.isEditing) {
            this.endEdit();
        }
        this.selStart = 0;
        this.selLength = this.text.length();
        this.contextMenu.show(this, x, y);
        return true;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        return this.startEdit();
    }

    @Override
    public boolean keyDown(int keyCode) {
        return this.startEdit();
    }

    public boolean startEdit() {
        if (this.readOnly) {
            return false;
        }
        if (this.isEditing) {
            return true;
        }
        this.selStart = 0;
        this.selLength = this.text.length();
        this.textBeforeKeyInput = this.text;
        Forge.startKeyInput(new Forge.KeyInputAdapter(){

            @Override
            public FDisplayObject getOwner() {
                return FTextField.this;
            }

            @Override
            public boolean allowTouchInput() {
                return true;
            }

            @Override
            public boolean keyTyped(char ch) {
                FTextField.this.insertText(String.valueOf(ch));
                return true;
            }

            @Override
            public boolean keyDown(int keyCode) {
                switch (keyCode) {
                    case 61: 
                    case 66: {
                        Forge.endKeyInput();
                        return true;
                    }
                    case 111: {
                        FTextField.this.setText(FTextField.this.textBeforeKeyInput);
                        Forge.endKeyInput();
                        return true;
                    }
                    case 67: {
                        if (FTextField.this.text.length() > 0) {
                            if (FTextField.this.selLength == 0) {
                                if (FTextField.this.selStart > 0) {
                                    FTextField.this.selStart--;
                                }
                                FTextField.this.selLength = 1;
                            }
                            FTextField.this.insertText("");
                        }
                        return true;
                    }
                    case 21: {
                        if (FTextField.this.selLength == 0) {
                            if (FTextField.this.selStart > 0) {
                                FTextField.this.selStart--;
                            }
                        } else {
                            FTextField.this.selLength = 0;
                        }
                        return true;
                    }
                    case 22: {
                        if (FTextField.this.selLength == 0) {
                            if (FTextField.this.selStart < FTextField.this.text.length()) {
                                FTextField.this.selStart++;
                            }
                        } else {
                            FTextField.this.selStart += FTextField.this.selLength;
                            FTextField.this.selLength = 0;
                        }
                        return true;
                    }
                    case 29: {
                        if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                        FTextField.this.selStart = 0;
                        FTextField.this.selLength = FTextField.this.text.length();
                        return true;
                    }
                    case 31: {
                        if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                        if (FTextField.this.selLength > 0) {
                            Forge.getClipboard().setContents(FTextField.this.getSelectedText());
                        }
                        return true;
                    }
                    case 50: {
                        if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                        FTextField.this.insertText(Forge.getClipboard().getContents());
                        return true;
                    }
                    case 52: {
                        if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                        if (FTextField.this.selLength > 0) {
                            Forge.getClipboard().setContents(FTextField.this.getSelectedText());
                            FTextField.this.insertText("");
                        }
                        return true;
                    }
                    case 54: {
                        if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                        FTextField.this.setText(FTextField.this.textBeforeKeyInput);
                        Forge.endKeyInput();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void onInputEnd() {
                FTextField.this.endEdit();
            }
        }, this.isNumeric);
        this.isEditing = true;
        return true;
    }

    protected boolean validate() {
        return true;
    }

    protected void endEdit() {
        this.text = this.text.trim();
        if (!this.text.equals(this.textBeforeKeyInput)) {
            if (this.validate()) {
                if (this.changedHandler != null) {
                    this.changedHandler.handleEvent(new FEvent(this, FEvent.FEventType.CHANGE, this.textBeforeKeyInput));
                }
            } else {
                this.setText(this.textBeforeKeyInput);
            }
        }
        this.isEditing = false;
        this.selStart = 0;
        this.selLength = 0;
        this.textBeforeKeyInput = null;
    }

    @Override
    public void draw(Graphics g2) {
        boolean drawBackground;
        float w = this.getWidth();
        float h2 = this.getHeight();
        boolean bl = drawBackground = !this.readOnly;
        if (drawBackground) {
            g2.fillRect(FTextField.getBackColor(), 0.0f, 0.0f, w, h2);
        }
        this.renderedFont = this.font;
        float availableTextWidth = w - this.getLeftPadding() - this.getRightPadding();
        TextBounds textBounds = this.renderedFont.getMultiLineBounds(this.text);
        while ((textBounds.width > availableTextWidth || textBounds.height > h2) && this.renderedFont.canShrink()) {
            this.renderedFont = this.renderedFont.shrink();
            availableTextWidth = w - this.getLeftPadding() - this.getRightPadding();
            textBounds = this.renderedFont.getMultiLineBounds(this.text);
        }
        if (this.isEditing || this.contextMenu.isVisible()) {
            float selLeft = this.getTextLeft();
            if (this.selStart > 0) {
                selLeft += this.renderedFont.getBounds((CharSequence)this.text.substring((int)0, (int)this.selStart)).width;
            }
            float selTop = PADDING;
            float selHeight = h2 - 2.0f * PADDING;
            if (this.selLength == 0) {
                this.drawText(g2, w, h2);
                g2.drawLine(BORDER_THICKNESS, FTextField.getForeColor(), selLeft, selTop, selLeft, selTop + selHeight);
            } else if (this.selStart == 0 && this.selLength == this.text.length()) {
                float selWidth = this.renderedFont.getBounds((CharSequence)this.text.substring((int)this.selStart, (int)(this.selStart + this.selLength))).width;
                g2.fillRect(FTextField.getSelColor(), selLeft, selTop, selWidth, selHeight);
                this.drawText(g2, w, h2);
            }
        } else {
            this.drawText(g2, w, h2);
        }
        if (drawBackground) {
            g2.drawRect(BORDER_THICKNESS, FTextField.getForeColor(), BORDER_THICKNESS, BORDER_THICKNESS, w - 2.0f * BORDER_THICKNESS, h2 - 2.0f * BORDER_THICKNESS);
        }
    }

    private void drawText(Graphics g2, float w, float h2) {
        float diff = h2 - this.renderedFont.getCapHeight();
        if (diff > 0.0f && Math.round(diff) % 2 == 1) {
            h2 += 1.0f;
        }
        if (!this.text.isEmpty()) {
            g2.drawText(this.text, this.renderedFont, FTextField.getForeColor(), this.getLeftPadding(), 0.0f, w - this.getLeftPadding() - this.getRightPadding(), h2, false, this.alignment, true);
        } else if (!this.ghostText.isEmpty()) {
            g2.drawText(this.ghostText, this.renderedFont, FTextField.getGhostTextColor(), this.getLeftPadding(), 0.0f, w - this.getLeftPadding() - this.getRightPadding(), h2, false, this.alignment, true);
        }
    }

    protected float getTextLeft() {
        switch (this.alignment) {
            default: {
                return this.getLeftPadding();
            }
            case 1: {
                return this.getLeftPadding() + (this.getWidth() - this.getRightPadding() - this.getLeftPadding() - this.renderedFont.getBounds((CharSequence)this.text).width) / 2.0f;
            }
            case 16: 
        }
        return this.getWidth() - this.getRightPadding() - this.renderedFont.getBounds((CharSequence)this.text).width;
    }

    protected float getLeftPadding() {
        return PADDING;
    }

    protected float getRightPadding() {
        return PADDING;
    }

    @Override
    public boolean requestFocusInWindow() {
        return false;
    }
}

