/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.animation.GifAnimation;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;

public class FTextArea
extends FScrollPane {
    private String text;
    private FSkinFont font;
    private int alignment;
    private Vector2 insets;
    private FSkinColor textColor;
    private final TextRenderer renderer;
    private GifAnimation animation;
    private boolean centerVertically;

    public FTextArea(boolean parseReminderText0) {
        this(parseReminderText0, "");
    }

    public FTextArea(boolean parseReminderText0, String text0) {
        this(parseReminderText0, text0, null);
    }

    public FTextArea(boolean parseReminderText0, String text0, GifAnimation gifAnimation) {
        this.text = text0;
        this.font = FSkinFont.get(14);
        this.alignment = 8;
        this.insets = new Vector2(1.0f, 1.0f);
        this.textColor = FLabel.getDefaultTextColor();
        this.animation = gifAnimation;
        this.renderer = new TextRenderer(parseReminderText0);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text0) {
        this.text = text0;
        this.revalidate();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment0) {
        this.alignment = alignment0;
    }

    public boolean getCenterVertically() {
        return this.centerVertically;
    }

    public void setCenterVertically(boolean centerVertically0) {
        this.centerVertically = centerVertically0;
    }

    public FSkinFont getFont() {
        return this.font;
    }

    public void setFont(FSkinFont font0) {
        this.font = font0;
        this.revalidate();
    }

    public FSkinColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(FSkinColor textColor0) {
        this.textColor = textColor0;
    }

    public float getPreferredHeight(float width) {
        return this.renderer.getWrappedBounds((String)this.text, (FSkinFont)this.font, (float)(width - 2.0f * this.insets.x)).height + this.font.getLineHeight() - this.font.getCapHeight() + 2.0f * this.insets.y;
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        return new FScrollPane.ScrollBounds(visibleWidth, this.getPreferredHeight(visibleWidth));
    }

    @Override
    protected void drawBackground(Graphics g2) {
        this.renderer.drawText(g2, this.text, this.font, this.textColor, this.insets.x - this.getScrollLeft(), this.insets.y - this.getScrollTop(), this.getScrollWidth() - 2.0f * this.insets.x, this.getScrollHeight() - 2.0f * this.insets.y, 0.0f, this.getHeight(), true, this.alignment, this.centerVertically);
    }

    @Override
    public void draw(Graphics g2) {
        if (this.animation != null) {
            float w = this.getScrollWidth() - 2.0f * this.insets.x;
            float multiplier = "extrawide".equalsIgnoreCase(Forge.extrawide) ? 0.5f : 0.6f;
            float h2 = w * multiplier;
            float y = this.getPreferredHeight(w);
            this.animation.draw(g2, this.insets.x - this.getScrollLeft(), this.insets.y - this.getScrollTop() + y, w, h2);
        }
        super.draw(g2);
    }
}

