/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.toolbox.FLabel;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class FRadioButton
extends FLabel {
    private static final float EXTRA_GAP = Utils.scale(3.0f);
    private RadioButtonGroup group;

    private static FSkinColor getInnerCircleColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    private static FSkinColor getOuterCircleColor() {
        return FRadioButton.getInnerCircleColor().alphaColor(0.5f);
    }

    public FRadioButton() {
        this("", false);
    }

    public FRadioButton(String text0) {
        this(text0, false);
    }

    public FRadioButton(String text0, boolean selected0) {
        super(new FLabel.Builder().text(text0).align(8).selectable().selected(selected0));
        this.setIcon(new RadioButtonIcon());
    }

    public RadioButtonGroup getGroup() {
        return this.group;
    }

    public void setGroup(RadioButtonGroup group0) {
        if (this.group != null) {
            this.group.buttons.remove(this);
        }
        this.group = group0;
        if (this.group != null) {
            this.group.buttons.add(this);
        }
    }

    @Override
    protected float getExtraGapBetweenIconAndText() {
        return EXTRA_GAP;
    }

    @Override
    public void setSelected(boolean b0) {
        if (this.isSelected() == b0 || !b0) {
            return;
        }
        if (b0 && this.group != null) {
            for (FRadioButton button : this.group.buttons) {
                if (button == this) continue;
                button.superSetSelected(false);
            }
        }
        this.superSetSelected(b0);
    }

    private void superSetSelected(boolean b0) {
        super.setSelected(b0);
    }

    @Override
    public void draw(Graphics g2) {
        this.drawContent(g2, this.getWidth(), this.getHeight(), false);
    }

    public static class RadioButtonGroup {
        private final List<FRadioButton> buttons = new ArrayList<FRadioButton>();
    }

    private class RadioButtonIcon
    implements FImage {
        private RadioButtonIcon() {
        }

        @Override
        public float getWidth() {
            return FRadioButton.this.getHeight();
        }

        @Override
        public float getHeight() {
            return FRadioButton.this.getHeight();
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            float radius = h2 / 3.0f;
            g2.drawCircle(Utils.scale(1.0f), FRadioButton.getOuterCircleColor(), x += w - radius, y += h2 / 2.0f, radius);
            if (FRadioButton.this.isSelected()) {
                g2.fillCircle(FRadioButton.getInnerCircleColor(), x, y, radius / 2.0f);
            }
        }
    }
}

