/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.utils.Timer;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.gui.FThreads;
import forge.screens.FScreen;
import forge.screens.match.MatchController;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class FOverlay
extends FContainer {
    public static final float ALPHA_COMPOSITE = 0.5f;
    private static final Stack<FOverlay> overlays = new Stack();
    private static boolean hidingAll = false;
    private static FOverlay tempOverlay;
    private FSkinColor backColor;
    private FScreen openedOnScreen;
    private static final Timer.Task hideTempOverlayTask;

    public FOverlay() {
        this(Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_OVERLAY).alphaColor(0.5f) : FSkinColor.get(FSkinColor.Colors.CLR_OVERLAY).alphaColor(0.5f));
    }

    public FOverlay(FSkinColor backColor0) {
        this.backColor = backColor0;
        super.setVisible(false);
    }

    public static FOverlay getTopOverlay() {
        if (overlays.isEmpty()) {
            return null;
        }
        return overlays.peek();
    }

    public static Iterable<FOverlay> getOverlays() {
        return overlays;
    }

    public static Iterable<FOverlay> getOverlaysTopDown() {
        if (overlays.size() < 2) {
            return overlays;
        }
        ArrayList<FOverlay> reversedList = new ArrayList<FOverlay>();
        for (int i = overlays.size() - 1; i >= 0; --i) {
            reversedList.add((FOverlay)overlays.get(i));
        }
        return reversedList;
    }

    public boolean preventInputBehindOverlay() {
        return true;
    }

    public static void hideAll() {
        hidingAll = true;
        for (int i = overlays.size() - 1; i >= 0; --i) {
            ((FOverlay)overlays.get(i)).hide();
        }
        overlays.clear();
        hidingAll = false;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void finishedloading() {
        Forge.setLoadingaMatch(false);
    }

    public boolean isVisibleOnScreen(FScreen screen) {
        return this.openedOnScreen == screen;
    }

    @Override
    public void setVisible(boolean visible0) {
        FThreads.assertExecutedByEdt(true);
        if (this.isVisible() == visible0) {
            return;
        }
        if (tempOverlay != this && hideTempOverlayTask.isScheduled()) {
            hideTempOverlayTask.cancel();
            hideTempOverlayTask.run();
        }
        if (visible0) {
            this.setRotate180(MatchController.getView() != null && MatchController.getView().isTopHumanPlayerActive());
            overlays.push(this);
            this.openedOnScreen = Forge.getCurrentScreen();
        } else {
            this.openedOnScreen = null;
            if (!hidingAll) {
                if (overlays.get(overlays.size() - 1) == this) {
                    if (tempOverlay != this && this.backColor != null) {
                        tempOverlay = this;
                        Timer.schedule(hideTempOverlayTask, 0.025f);
                        return;
                    }
                    overlays.pop();
                } else {
                    overlays.remove(this);
                }
            }
        }
        super.setVisible(visible0);
    }

    public FSkinColor getBackColor() {
        return this.backColor;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        if (this.backColor == null) {
            return;
        }
        g2.fillRect(this.backColor, 0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean press(float x, float y) {
        return true;
    }

    @Override
    public boolean longPress(float x, float y) {
        return true;
    }

    @Override
    public boolean release(float x, float y) {
        return true;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        return true;
    }

    @Override
    public boolean flick(float x, float y) {
        return true;
    }

    @Override
    public boolean fling(float velocityX, float velocityY) {
        return true;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        return true;
    }

    @Override
    public boolean panStop(float x, float y) {
        return true;
    }

    @Override
    public boolean zoom(float x, float y, float amount) {
        return true;
    }

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        if (tempOverlay == this) {
            return;
        }
        super.buildTouchListeners(screenX, screenY, listeners);
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (tempOverlay == this) {
            return false;
        }
        if (keyCode == 111 || keyCode == 4) {
            if (Forge.endKeyInput()) {
                return true;
            }
            this.hide();
            return true;
        }
        return super.keyDown(keyCode);
    }

    static {
        hideTempOverlayTask = new Timer.Task(){

            @Override
            public void run() {
                tempOverlay.hide();
                tempOverlay = null;
            }
        };
    }
}

