/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinTexture;
import forge.item.InventoryItem;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.toolbox.ListChooser;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FList<T>
extends FScrollPane
implements Iterable<T> {
    public static final float PADDING = Utils.scale(3.0f);
    public static final float LINE_THICKNESS = Utils.scale(1.0f);
    protected final List<T> items = new ArrayList<T>();
    private FSkinFont font;
    private ListItemRenderer<T> renderer;
    private int pressedIndex = -1;

    public static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public static FSkinColor getPressedColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE).alphaColor(0.9f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE).alphaColor(0.9f);
    }

    public static FSkinColor getLineColor() {
        return FList.getForeColor().alphaColor(0.5f);
    }

    public FList() {
        this.initialize();
    }

    public FList(T[] itemArray) {
        for (T item : itemArray) {
            this.addItem(item);
        }
        this.initialize();
    }

    public FList(Iterable<? extends T> items0) {
        for (T item : items0) {
            this.addItem(item);
        }
        this.initialize();
    }

    private void initialize() {
        this.font = FSkinFont.get(14);
        this.renderer = new DefaultListItemRenderer<T>();
    }

    public synchronized void addItem(T item) {
        this.items.add(item);
    }

    public synchronized void removeItem(T item) {
        this.items.remove(item);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.items.clear();
    }

    public List<T> extractListData() {
        return new ArrayList<T>(this.items);
    }

    public synchronized void setListData(Iterable<? extends T> items0) {
        this.clear();
        for (T item : items0) {
            this.addItem(item);
        }
        this.revalidate();
    }

    public synchronized void setListData(T[] items0) {
        this.clear();
        for (T item : items0) {
            this.addItem(item);
        }
        this.revalidate();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getCount() {
        return this.items.size();
    }

    public T getItemAt(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return this.items.get(index);
    }

    public int getIndexOf(T item) {
        return this.items.indexOf(item);
    }

    public T getItemAtPoint(float x, float y) {
        return this.getItemAt(this.getIndexAtPoint(x, y));
    }

    public int getIndexAtPoint(float x, float y) {
        if (this.renderer.layoutHorizontal()) {
            return (int)((this.getScrollLeft() + x) / this.renderer.getItemHeight());
        }
        return (int)((this.getScrollTop() + y) / this.renderer.getItemHeight());
    }

    public ListItemRenderer<T> getListItemRenderer() {
        return this.renderer;
    }

    public void setListItemRenderer(ListItemRenderer<T> renderer0) {
        this.renderer = renderer0;
    }

    public FSkinFont getFont() {
        return this.font;
    }

    public void setFont(FSkinFont font0) {
        this.font = font0;
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        if (this.renderer.layoutHorizontal()) {
            return new FScrollPane.ScrollBounds((float)this.items.size() * this.renderer.getItemHeight(), visibleHeight);
        }
        return new FScrollPane.ScrollBounds(visibleWidth, (float)this.items.size() * this.renderer.getItemHeight());
    }

    @Override
    public boolean press(float x, float y) {
        this.pressedIndex = this.getIndexAtPoint(x, y);
        return true;
    }

    @Override
    public boolean release(float x, float y) {
        this.pressedIndex = -1;
        return true;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        int index = this.getIndexAtPoint(x, y);
        T item = this.getItemAt(index);
        if (item == null) {
            return false;
        }
        if (this.renderer.layoutHorizontal()) {
            return this.renderer.tap(index, item, x - this.getItemStartPosition(index), y, count);
        }
        return this.renderer.tap(index, item, x, y - this.getItemStartPosition(index), count);
    }

    @Override
    public boolean longPress(float x, float y) {
        int index = this.getIndexAtPoint(x, y);
        T item = this.getItemAt(index);
        if (item == null) {
            return false;
        }
        return this.renderer.showMenu(index, item, this, x, y);
    }

    public float getScrollPosition() {
        if (this.renderer.layoutHorizontal()) {
            return this.getScrollLeft();
        }
        return this.getScrollTop();
    }

    public void setScrollPosition(float scrollPosition) {
        if (this.renderer.layoutHorizontal()) {
            this.setScrollLeft(scrollPosition);
        }
        this.setScrollTop(scrollPosition);
    }

    public float getVisibleSize() {
        if (this.renderer.layoutHorizontal()) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public float getItemStartPosition(int index) {
        return (float)index * this.renderer.getItemHeight() - this.getScrollPosition();
    }

    public void scrollIntoView(int index) {
        float itemStartPos = this.getItemStartPosition(index);
        if (itemStartPos < 0.0f) {
            this.setScrollPosition(this.getScrollPosition() + itemStartPos);
        } else {
            float visibleSize;
            float itemEndPosition = itemStartPos + this.renderer.getItemHeight();
            if (itemEndPosition > (visibleSize = this.getVisibleSize())) {
                this.setScrollPosition(this.getScrollPosition() + itemEndPosition - visibleSize);
            }
        }
    }

    @Override
    protected void drawBackground(Graphics g2) {
        g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, -this.getScrollLeft(), -this.getScrollTop(), this.getScrollWidth(), this.getScrollHeight());
        g2.fillRect(FScreen.getTextureOverlayColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    @Override
    public synchronized void draw(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.startClip(0.0f, 0.0f, w, h2);
        this.drawBackground(g2);
        if (!this.items.isEmpty()) {
            int startIndex = this.getIndexAtPoint(0.0f, 0.0f);
            boolean drawSeparators = this.drawLineSeparators();
            float x = 0.0f;
            float y = Math.round(this.getItemStartPosition(startIndex));
            float itemWidth = w;
            float itemHeight = this.renderer.getItemHeight();
            boolean layoutHorizontal = this.renderer.layoutHorizontal();
            if (layoutHorizontal) {
                x = y;
                y = 0.0f;
                itemWidth = itemHeight;
                itemHeight = h2;
            }
            float padding = this.getPadding();
            float valueWidth = itemWidth - 2.0f * padding;
            float valueHeight = itemHeight - 2.0f * padding;
            for (int i = startIndex; i < this.items.size() && !(x > w) && !(y > h2); ++i) {
                FSkinColor fillColor = this.getItemFillColor(i);
                if (fillColor != null) {
                    g2.fillRect(fillColor, x, y, w, itemHeight);
                }
                this.renderer.drawValue(g2, i, this.items.get(i), this.font, FList.getForeColor(), fillColor, this.pressedIndex == i, x + padding, y + padding, valueWidth, valueHeight);
                if (layoutHorizontal) {
                    x += itemWidth;
                } else {
                    y += itemHeight;
                }
                if (!drawSeparators) continue;
                if (layoutHorizontal) {
                    g2.drawLine(LINE_THICKNESS, FList.getLineColor(), x -= LINE_THICKNESS / 2.0f, 0.0f, x, h2);
                    continue;
                }
                g2.drawLine(LINE_THICKNESS, FList.getLineColor(), 0.0f, y -= LINE_THICKNESS / 2.0f, w, y);
            }
        }
        this.drawOverlay(g2);
        g2.endClip();
    }

    protected FSkinColor getItemFillColor(int index) {
        if (index == this.pressedIndex) {
            return FList.getPressedColor();
        }
        return null;
    }

    protected boolean drawLineSeparators() {
        return true;
    }

    protected float getPadding() {
        return PADDING;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public static class CompactModeHandler {
        private static final float REQ_AMOUNT = Utils.AVG_FINGER_WIDTH;
        private float totalZoomAmount;
        private boolean compactMode = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_LIST_ITEMS);

        public boolean isCompactMode() {
            return this.compactMode;
        }

        public void setCompactMode(boolean compactMode0) {
            this.compactMode = compactMode0;
        }

        public boolean update(float amount) {
            this.totalZoomAmount += amount;
            if (this.totalZoomAmount >= REQ_AMOUNT) {
                this.compactMode = false;
                this.totalZoomAmount = 0.0f;
                return true;
            }
            if (this.totalZoomAmount <= -REQ_AMOUNT) {
                this.compactMode = true;
                this.totalZoomAmount = 0.0f;
                return true;
            }
            return false;
        }
    }

    public static class DefaultListItemRenderer<V>
    extends ListItemRenderer<V> {
        @Override
        public float getItemHeight() {
            return Utils.AVG_FINGER_HEIGHT;
        }

        @Override
        public boolean tap(Integer index, V value, float x, float y, int count) {
            return false;
        }

        @Override
        public void drawValue(Graphics g2, Integer index, V value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
            g2.drawText(value.toString(), font, foreColor, x, y, w, h2, false, 8, true);
        }
    }

    public static abstract class ListItemRenderer<V> {
        public abstract float getItemHeight();

        public abstract boolean tap(Integer var1, V var2, float var3, float var4, int var5);

        public abstract void drawValue(Graphics var1, Integer var2, V var3, FSkinFont var4, FSkinColor var5, FSkinColor var6, boolean var7, float var8, float var9, float var10, float var11);

        public boolean showMenu(Integer index, V value, FDisplayObject owner, float x, float y) {
            return false;
        }

        public boolean layoutHorizontal() {
            return false;
        }

        public AdvancedSearchFilter<? extends InventoryItem> getAdvancedSearchFilter(ListChooser<V> listChooser) {
            return null;
        }
    }
}

