/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinTexture;
import forge.screens.FScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FScrollPane;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class FGroupList<E>
extends FScrollPane {
    private static final float GROUP_HEADER_HEIGHT = Math.round(Utils.AVG_FINGER_HEIGHT * 0.6f);
    private final List<ListGroup> groups = new ArrayList<ListGroup>();
    private FSkinFont font;
    private FList.ListItemRenderer<E> renderer;

    public FGroupList() {
        this.initialize();
    }

    public FGroupList(E[] itemArray) {
        for (E item : itemArray) {
            this.addItem(item);
        }
        this.initialize();
    }

    public FGroupList(Iterable<E> items0) {
        for (E item : items0) {
            this.addItem(item);
        }
        this.initialize();
    }

    private void initialize() {
        this.font = FSkinFont.get(14);
        this.renderer = new FList.DefaultListItemRenderer<E>();
    }

    public void addGroup(String groupName) {
        this.groups.add(this.add(new ListGroup(groupName)));
    }

    public void addItem(E item) {
        this.addItem(item, 0);
    }

    public void addItem(E item, int groupIndex) {
        if (this.groups.isEmpty()) {
            this.addGroup(null);
        }
        if (groupIndex > this.groups.size()) {
            groupIndex = this.groups.size() - 1;
        }
        this.groups.get(groupIndex).addItem(new ListItem(item));
    }

    public void removeItem(E item) {
        for (ListGroup group : this.groups) {
            for (ListItem groupItem : group.items) {
                if (groupItem.value != item) continue;
                group.removeItem(groupItem);
                if (group.items.isEmpty()) {
                    this.groups.remove(group);
                }
                return;
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.groups.clear();
    }

    public void setListData(Iterable<E> items0) {
        this.clear();
        for (E item : items0) {
            this.addItem(item);
        }
        this.revalidate();
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public int getCount() {
        int count = 0;
        for (ListGroup group : this.groups) {
            count += group.items.size();
        }
        return count;
    }

    public ListItem getItemAt(int index) {
        int count = 0;
        for (ListGroup group : this.groups) {
            for (ListItem item : group.items) {
                if (index == count) {
                    return item;
                }
                ++count;
            }
        }
        return null;
    }

    public E getItemValueAt(int index) {
        ListItem item = this.getItemAt(index);
        if (item == null) {
            return null;
        }
        return (E)item.value;
    }

    public int getIndexOf(E value) {
        int count = 0;
        for (ListGroup group : this.groups) {
            for (ListItem item : group.items) {
                if (item.value == value) {
                    return count;
                }
                ++count;
            }
        }
        return -1;
    }

    public void setListItemRenderer(FList.ListItemRenderer<E> renderer0) {
        this.renderer = renderer0;
    }

    public FSkinFont getFont() {
        return this.font;
    }

    public void setFont(FSkinFont font0) {
        this.font = font0;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, -this.getScrollLeft(), -this.getScrollTop(), this.getScrollWidth(), this.getScrollHeight());
        g2.fillRect(FScreen.getTextureOverlayColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        float y = 0.0f;
        for (ListGroup group : this.groups) {
            if (!group.isVisible()) continue;
            float groupHeight = group.getPreferredHeight();
            group.setBounds(0.0f, y, visibleWidth, groupHeight);
            y += groupHeight;
        }
        return new FScrollPane.ScrollBounds(visibleWidth, y);
    }

    protected FSkinColor getItemFillColor(ListItem item) {
        if (item.pressed) {
            return FList.getPressedColor();
        }
        return null;
    }

    protected boolean drawLineSeparators() {
        return true;
    }

    public class ListItem
    extends FDisplayObject {
        private final E value;
        private boolean pressed;

        private ListItem(E value0) {
            this.value = value0;
        }

        @Override
        public boolean press(float x, float y) {
            this.pressed = true;
            return true;
        }

        @Override
        public boolean release(float x, float y) {
            this.pressed = false;
            return true;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            return FGroupList.this.renderer.tap(-1, this.value, x, y, count);
        }

        @Override
        public boolean longPress(float x, float y) {
            return FGroupList.this.renderer.showMenu(-1, this.value, this, x, y);
        }

        @Override
        public final void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = FGroupList.this.renderer.getItemHeight();
            FSkinColor fillColor = FGroupList.this.getItemFillColor(this);
            if (fillColor != null) {
                g2.fillRect(fillColor, 0.0f, 0.0f, w, h2);
            }
            FGroupList.this.renderer.drawValue(g2, -1, this.value, FGroupList.this.font, FList.getForeColor(), fillColor, this.pressed, FList.PADDING, FList.PADDING, w - 2.0f * FList.PADDING, h2 - 2.0f * FList.PADDING);
            if (FGroupList.this.drawLineSeparators()) {
                g2.drawLine(1.0f, FList.getLineColor(), 0.0f, h2, w, h2);
            }
        }
    }

    private class ListGroup
    extends FContainer {
        private final FLabel header;
        private final List<ListItem> items = new ArrayList<ListItem>();
        private boolean isCollapsed;

        private ListGroup(String name0) {
            this.header = name0 == null ? null : this.add(new FLabel.ButtonBuilder().text(name0).command(e -> {
                this.isCollapsed = !this.isCollapsed;
                FGroupList.this.revalidate();
            }).build());
            this.setVisible(false);
        }

        public void addItem(ListItem item) {
            this.items.add(item);
            this.add(item);
            this.setVisible(true);
        }

        public boolean removeItem(ListItem item) {
            if (this.items.remove(item)) {
                this.remove(item);
                this.setVisible(this.items.size() > 0);
                return true;
            }
            return false;
        }

        public float getPreferredHeight() {
            float height = 0.0f;
            if (this.header != null) {
                height += GROUP_HEADER_HEIGHT;
            }
            if (!this.isCollapsed) {
                height += FGroupList.this.renderer.getItemHeight() * (float)this.items.size() + 1.0f;
            }
            return height;
        }

        @Override
        protected void doLayout(float width, float height) {
            float y = 0.0f;
            if (this.header != null) {
                this.header.setBounds(0.0f, y, width, GROUP_HEADER_HEIGHT);
                y += GROUP_HEADER_HEIGHT;
            }
            float itemHeight = FGroupList.this.renderer.getItemHeight();
            for (ListItem item : this.items) {
                item.setBounds(0.0f, y, width, itemHeight);
                y += itemHeight;
            }
        }
    }
}

