/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Timer;
import forge.Forge;
import forge.assets.FSkin;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Utils;

public abstract class FGestureAdapter
extends InputAdapter {
    private float tapSquareSize;
    private float longPressDelay;
    private float lastTapX;
    private float lastTapY;
    private float tapSquareCenterX;
    private float tapSquareCenterY;
    private long tapCountInterval;
    private long flingDelay;
    private long lastTapTime;
    private int tapCount;
    private int lastTapButton;
    private int lastTapPointer;
    private boolean inTapSquare;
    private boolean pressed;
    private boolean longPressed;
    private boolean longPressHandled;
    private boolean pinching;
    private boolean panning;
    private boolean disablePanning;
    private final VelocityTracker tracker = new VelocityTracker();
    private final Vector2 pointer1 = new Vector2();
    private final Vector2 pointer2 = new Vector2();
    private final Vector2 prevPointer1 = new Vector2();
    private final Vector2 prevPointer2 = new Vector2();
    private final Vector2 focalPoint = new Vector2();
    private final Timer.Task longPressTask = new Timer.Task(){

        @Override
        public void run() {
            if (FGestureAdapter.this.pressed) {
                if (Gdx.input.isTouched(0)) {
                    if (!FGestureAdapter.this.longPressed) {
                        FGestureAdapter.this.longPressed = true;
                        if (FGestureAdapter.this.longPress(((FGestureAdapter)FGestureAdapter.this).pointer1.x, ((FGestureAdapter)FGestureAdapter.this).pointer1.y)) {
                            if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_VIBRATE_ON_LONG_PRESS)) {
                                Gdx.input.vibrate(25);
                            }
                            FGestureAdapter.this.endPress(((FGestureAdapter)FGestureAdapter.this).pointer1.x, ((FGestureAdapter)FGestureAdapter.this).pointer1.y);
                            FGestureAdapter.this.longPressHandled = true;
                        }
                    }
                } else {
                    FGestureAdapter.this.endPress(((FGestureAdapter)FGestureAdapter.this).pointer1.x, ((FGestureAdapter)FGestureAdapter.this).pointer1.y);
                }
            }
        }
    };

    public abstract boolean press(float var1, float var2);

    public abstract boolean longPress(float var1, float var2);

    public abstract boolean release(float var1, float var2);

    public abstract boolean tap(float var1, float var2, int var3);

    public abstract boolean flick(float var1, float var2);

    public abstract boolean fling(float var1, float var2);

    public abstract boolean pan(float var1, float var2, float var3, float var4, boolean var5);

    public abstract boolean panStop(float var1, float var2);

    public abstract boolean zoom(float var1, float var2, float var3);

    @Override
    public abstract boolean scrolled(float var1, float var2);

    public FGestureAdapter() {
        this(Utils.AVG_FINGER_WIDTH / 2.0f, 0.25f, 0.5f, 0.15f);
    }

    public FGestureAdapter(float tapSquareSize0, float tapCountInterval0, float longPressDelay0, float flingDelay0) {
        this.tapSquareSize = tapSquareSize0;
        this.tapCountInterval = Utils.secondsToTimeSpan(tapCountInterval0);
        this.longPressDelay = longPressDelay0;
        this.flingDelay = Utils.secondsToTimeSpan(flingDelay0);
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        Forge.magnify = true;
        return super.mouseMoved(screenX, screenY);
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        return this.touchDown((float)x, (float)y, pointer, button);
    }

    private boolean touchDown(float x, float y, int pointer, int button) {
        if (button == 1) {
            return true;
        }
        if (pointer > 1) {
            return false;
        }
        if (pointer == 0) {
            this.pointer1.set(x, y);
            if (!Gdx.input.isTouched(1)) {
                this.tracker.start(x, y, Gdx.input.getCurrentEventTime());
                this.inTapSquare = true;
                this.panning = false;
                this.pinching = false;
                this.tapSquareCenterX = x;
                this.tapSquareCenterY = y;
                this.startPress();
                return true;
            }
        } else {
            this.pointer2.set(x, y);
            if (!Gdx.input.isTouched(0)) {
                return true;
            }
        }
        this.inTapSquare = false;
        this.panning = false;
        this.pinching = true;
        this.prevPointer1.set(this.pointer1);
        this.prevPointer2.set(this.pointer2);
        this.focalPoint.set(Utils.getMidpoint(this.pointer1, this.pointer2));
        this.endPress(this.pointer1.x, this.pointer1.y);
        return true;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        return this.touchDragged((float)x, (float)y, pointer);
    }

    private boolean touchDragged(float x, float y, int pointer) {
        if (pointer > 1) {
            return false;
        }
        if (pointer == 0) {
            this.prevPointer1.set(this.pointer1);
            this.pointer1.set(x, y);
        } else {
            this.prevPointer2.set(this.pointer2);
            this.pointer2.set(x, y);
        }
        if (this.pinching) {
            return this.zoom(this.focalPoint.x, this.focalPoint.y, this.pointer1.dst(this.pointer2) - this.prevPointer1.dst(this.prevPointer2));
        }
        if (this.disablePanning) {
            return false;
        }
        this.tracker.update(x, y, Gdx.input.getCurrentEventTime());
        if (this.inTapSquare && !this.isWithinTapSquare(x, y, this.tapSquareCenterX, this.tapSquareCenterY)) {
            this.endPress(x, y);
            this.inTapSquare = false;
        }
        if (!this.inTapSquare) {
            this.panning = true;
            boolean moreVertical = Math.abs(this.tracker.startY - y) > Math.abs(this.tracker.startX - x);
            return this.pan(x, y, this.tracker.deltaX, this.tracker.deltaY, moreVertical);
        }
        return false;
    }

    @Override
    public boolean touchCancelled(int x, int y, int pointer, int button) {
        return this.touchUp((float)x, (float)y, pointer, button);
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        return this.touchUp((float)x, (float)y, pointer, button);
    }

    private boolean touchUp(float x, float y, int pointer, int button) {
        if (button == 1) {
            if (this.inTapSquare) {
                long time = Gdx.input.getCurrentEventTime();
                if (this.tapCount == 2 || this.lastTapButton != button || this.lastTapPointer != pointer || time - this.lastTapTime > this.tapCountInterval || !this.isWithinTapSquare(x, y, this.lastTapX, this.lastTapY)) {
                    Forge.magnifyShowDetails = !Forge.magnifyShowDetails;
                    this.tapCount = 0;
                }
                ++this.tapCount;
                this.lastTapTime = time;
                this.lastTapX = x;
                this.lastTapY = y;
                this.lastTapButton = button;
                this.lastTapPointer = pointer;
                Forge.magnify = Forge.magnifyToggle = !Forge.magnifyToggle;
                if (Forge.magnifyToggle) {
                    Forge.setCursor(FSkin.getCursor().get(1), "1");
                } else {
                    Forge.setCursor(FSkin.getCursor().get(2), "2");
                }
            }
            return false;
        }
        if (pointer > 1) {
            return false;
        }
        if (this.longPressHandled) {
            this.longPressHandled = false;
            return false;
        }
        if (this.inTapSquare && !this.isWithinTapSquare(x, y, this.tapSquareCenterX, this.tapSquareCenterY)) {
            this.inTapSquare = false;
        }
        boolean wasPanning = this.panning;
        this.panning = false;
        boolean wasPressed = this.pressed;
        this.endPress(x, y);
        if (this.inTapSquare) {
            long time = Gdx.input.getCurrentEventTime();
            if (this.tapCount == 2 || this.lastTapButton != button || this.lastTapPointer != pointer || time - this.lastTapTime > this.tapCountInterval || !this.isWithinTapSquare(x, y, this.lastTapX, this.lastTapY)) {
                this.tapCount = 0;
            }
            ++this.tapCount;
            this.lastTapTime = time;
            this.lastTapX = x;
            this.lastTapY = y;
            this.lastTapButton = button;
            this.lastTapPointer = pointer;
            if (wasPressed) {
                Forge.magnify = false;
                return this.tap(x, y, this.tapCount);
            }
            return false;
        }
        if (this.pinching) {
            this.pinching = false;
            this.disablePanning = true;
            return false;
        }
        this.disablePanning = false;
        boolean handled = false;
        if (wasPanning) {
            handled = this.panStop(x, y);
            long time = Gdx.input.getCurrentEventTime();
            if (time - this.tracker.lastTime < this.flingDelay) {
                this.tracker.update(x, y, time);
                float velocityX = this.tracker.getVelocityX();
                float velocityY = this.tracker.getVelocityY();
                if (velocityY < 0.0f && Math.abs(velocityY) > Math.abs(velocityX)) {
                    handled = this.flick(this.tracker.startX, this.tracker.startY) || handled;
                }
                handled = this.fling(velocityX, velocityY) || handled;
            }
        }
        return handled;
    }

    private void startPress() {
        this.longPressed = false;
        this.longPressHandled = false;
        if (!this.pressed) {
            this.pressed = true;
            this.press(this.pointer1.x, this.pointer1.y);
        }
        if (!this.longPressTask.isScheduled()) {
            Timer.schedule(this.longPressTask, this.longPressDelay);
        }
    }

    private void endPress(float x, float y) {
        this.longPressTask.cancel();
        this.longPressed = false;
        if (this.pressed) {
            this.pressed = false;
            this.release(x, y);
        }
    }

    private boolean isWithinTapSquare(float x, float y, float centerX, float centerY) {
        return Math.abs(x - centerX) < this.tapSquareSize && Math.abs(y - centerY) < this.tapSquareSize;
    }

    private static class VelocityTracker {
        int sampleSize = 10;
        float startX;
        float startY;
        float lastX;
        float lastY;
        float deltaX;
        float deltaY;
        long lastTime;
        int numSamples;
        float[] meanX = new float[this.sampleSize];
        float[] meanY = new float[this.sampleSize];
        long[] meanTime = new long[this.sampleSize];

        private VelocityTracker() {
        }

        public void start(float x, float y, long timeStamp) {
            this.startX = x;
            this.startY = y;
            this.lastX = x;
            this.lastY = y;
            this.deltaX = 0.0f;
            this.deltaY = 0.0f;
            this.numSamples = 0;
            for (int i = 0; i < this.sampleSize; ++i) {
                this.meanX[i] = 0.0f;
                this.meanY[i] = 0.0f;
                this.meanTime[i] = 0L;
            }
            this.lastTime = timeStamp;
        }

        public void update(float x, float y, long timeStamp) {
            long currTime = timeStamp;
            this.deltaX = x - this.lastX;
            this.deltaY = y - this.lastY;
            this.lastX = x;
            this.lastY = y;
            long deltaTime = currTime - this.lastTime;
            this.lastTime = currTime;
            int index = this.numSamples % this.sampleSize;
            this.meanX[index] = this.deltaX;
            this.meanY[index] = this.deltaY;
            this.meanTime[index] = deltaTime;
            ++this.numSamples;
        }

        public float getVelocityX() {
            float meanX = this.getAverage(this.meanX, this.numSamples);
            float meanTime = (float)this.getAverage(this.meanTime, this.numSamples) / 1.0E9f;
            if (meanTime == 0.0f) {
                return 0.0f;
            }
            return meanX / meanTime;
        }

        public float getVelocityY() {
            float meanY = this.getAverage(this.meanY, this.numSamples);
            float meanTime = (float)this.getAverage(this.meanTime, this.numSamples) / 1.0E9f;
            if (meanTime == 0.0f) {
                return 0.0f;
            }
            return meanY / meanTime;
        }

        private float getAverage(float[] values, int numSamples) {
            numSamples = Math.min(this.sampleSize, numSamples);
            float sum = 0.0f;
            for (int i = 0; i < numSamples; ++i) {
                sum += values[i];
            }
            return sum / (float)numSamples;
        }

        private long getAverage(long[] values, int numSamples) {
            numSamples = Math.min(this.sampleSize, numSamples);
            long sum = 0L;
            for (int i = 0; i < numSamples; ++i) {
                sum += values[i];
            }
            if (numSamples == 0) {
                return 0L;
            }
            return sum / (long)numSamples;
        }
    }
}

