/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.math.Vector2;
import forge.Graphics;
import forge.gui.error.BugReporter;
import forge.toolbox.FDisplayObject;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

public abstract class FContainer
extends FDisplayObject {
    private final List<FDisplayObject> children = new ArrayList<FDisplayObject>();

    public <T extends FDisplayObject> T add(T child) {
        this.children.add(child);
        return child;
    }

    public <T extends FDisplayObject> boolean remove(T child) {
        return this.children.remove(child);
    }

    public void clear() {
        this.children.clear();
    }

    public int indexOf(FDisplayObject child) {
        return this.children.indexOf(child);
    }

    public FDisplayObject getChildAt(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Iterable<FDisplayObject> getChildren() {
        return this.children;
    }

    protected void drawBackground(Graphics g2) {
    }

    @Override
    public void draw(Graphics g2) {
        try {
            this.drawBackground(g2);
            boolean needOverlayDrawn = true;
            for (FDisplayObject child : this.children) {
                boolean disabled;
                if (!child.isVisible()) continue;
                if (child.drawAboveOverlay() && needOverlayDrawn) {
                    this.drawOverlay(g2);
                    needOverlayDrawn = false;
                }
                boolean bl = disabled = !child.isEnabled();
                if (disabled) {
                    g2.setAlphaComposite(0.25f);
                }
                g2.draw(child);
                if (disabled) {
                    g2.resetAlphaComposite();
                }
                child.drawOnContainer(g2);
            }
            if (needOverlayDrawn) {
                this.drawOverlay(g2);
            }
        }
        catch (ConcurrentModificationException needOverlayDrawn) {
        }
        catch (Exception ex) {
            BugReporter.reportException(ex);
        }
    }

    protected void drawOverlay(Graphics g2) {
    }

    @Override
    public void setBounds(float x, float y, float width, float height) {
        super.setBounds(x, y, width, height);
        this.doLayout(width, height);
    }

    @Override
    public void setSize(float width, float height) {
        if (this.getWidth() == width && this.getHeight() == height || width == 0.0f || height == 0.0f) {
            return;
        }
        super.setSize(width, height);
        this.doLayout(width, height);
    }

    public void revalidate() {
        this.revalidate(false);
    }

    public void revalidate(boolean forced) {
        if (forced) {
            this.doLayout(this.getWidth(), this.getHeight());
            return;
        }
        float w = this.getWidth();
        float h2 = this.getHeight();
        if (w == 0.0f || h2 == 0.0f) {
            return;
        }
        this.doLayout(w, h2);
    }

    protected abstract void doLayout(float var1, float var2);

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        if (this.isEnabled() && this.isVisible() && this.screenPos.contains(screenX, screenY)) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                this.children.get(i).buildTouchListeners(screenX, screenY, listeners);
            }
            listeners.add(this);
        }
    }

    public final Vector2 getChildRelativePosition(FDisplayObject child) {
        return this.getChildRelativePosition(child, 0.0f, 0.0f);
    }

    protected Vector2 getChildRelativePosition(FDisplayObject child, float offsetX, float offsetY) {
        for (FDisplayObject c : this.children) {
            if (child != c) continue;
            return new Vector2(c.getLeft() + offsetX, c.getTop() + offsetY);
        }
        for (FDisplayObject c : this.children) {
            Vector2 pos;
            if (!(c instanceof FContainer) || (pos = ((FContainer)c).getChildRelativePosition(child, c.getLeft() + offsetX, c.getTop() + offsetY)) == null) continue;
            return pos;
        }
        return null;
    }

    @Override
    public boolean keyDown(int keyCode) {
        try {
            for (FDisplayObject c : this.children) {
                if (!c.isEnabled() || !c.keyDown(keyCode)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

