/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Graphics;
import forge.gui.interfaces.IComboBox;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FComboBox<T>
extends FTextField
implements IComboBox<T> {
    private final List<T> items = new ArrayList<T>();
    private T selectedItem;
    private String label = "";
    private final DropDown dropDown = new DropDown();
    private FEvent.FEventHandler dropDownItemTap;
    private FEvent.FEventHandler dropDownChangeHandler;
    private boolean autoClose = true;

    public FComboBox() {
        this.initialize();
    }

    public FComboBox(String label0) {
        this.initialize();
        this.setLabel(label0);
    }

    public FComboBox(T[] itemArray) {
        this.items.addAll(Arrays.asList(itemArray));
        this.initialize();
    }

    public FComboBox(Iterable<T> items0) {
        for (T item : items0) {
            this.items.add(item);
        }
        this.initialize();
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    private void initialize() {
        if (!this.items.isEmpty()) {
            this.setSelectedItem(this.items.get(0));
        }
    }

    protected String getDisplayText(T item) {
        return item.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label0) {
        if (label0 == null) {
            label0 = "";
        }
        if (this.label.equals(label0)) {
            return;
        }
        this.label = label0;
        if (this.selectedItem != null) {
            super.setText(this.label + this.getDisplayText(this.selectedItem));
        } else {
            super.setText(this.label);
        }
    }

    public void setItems(T[] itemArray, T selectedItem0) {
        this.items.clear();
        if (itemArray != null) {
            this.items.addAll(Arrays.asList(itemArray));
        }
        this.setSelectedItem(selectedItem0);
    }

    public void setItems(Iterable<T> items0, T selectedItem0) {
        this.items.clear();
        if (items0 != null) {
            for (T item : items0) {
                this.items.add(item);
            }
        }
        this.setSelectedItem(selectedItem0);
    }

    @Override
    public void addItem(T item) {
        this.items.add(item);
        if (this.items.size() == 1) {
            this.setSelectedItem(item);
        }
    }

    public boolean removeItem(T item) {
        int restoreIndex = -1;
        if (this.selectedItem == item) {
            restoreIndex = this.getSelectedIndex();
        }
        if (this.items.remove(item) && restoreIndex >= 0) {
            this.setSelectedIndex(restoreIndex);
        }
        return false;
    }

    @Override
    public void removeAllItems() {
        this.items.clear();
        this.setSelectedItem((T)null);
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int getSelectedIndex() {
        if (this.selectedItem == null) {
            return -1;
        }
        return this.items.indexOf(this.selectedItem);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < 0) {
            this.setSelectedItem((T)null);
            return;
        }
        if (index >= this.items.size()) {
            index = this.items.size() - 1;
        }
        this.setSelectedItem(this.items.get(index));
    }

    @Override
    public T getSelectedItem() {
        return this.selectedItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSelectedItem(T item) {
        if (this.selectedItem == item) {
            return;
        }
        if (item != null) {
            if (!this.items.contains(item)) return;
            this.selectedItem = item;
            super.setText(this.label + this.getDisplayText(item));
        } else {
            this.selectedItem = null;
            super.setText(this.label);
        }
        if (this.getChangedHandler() == null) return;
        this.getChangedHandler().handleEvent(new FEvent(this, FEvent.FEventType.CHANGE, item));
    }

    @Override
    public void setText(String text0) {
        for (T item : this.items) {
            if (!this.getDisplayText(item).equals(text0)) continue;
            this.setSelectedItem(item);
            return;
        }
        this.selectedItem = null;
        super.setText(this.label + text0);
    }

    @Override
    public boolean tap(float x, float y, int count) {
        this.dropDown.setVisible(!this.dropDown.isVisible());
        return true;
    }

    @Override
    public boolean startEdit() {
        return false;
    }

    public FEvent.FEventHandler getDropDownItemTap() {
        return this.dropDownItemTap;
    }

    public void setDropDownItemTap(FEvent.FEventHandler itemTap0) {
        this.dropDownItemTap = itemTap0;
    }

    public FEvent.FEventHandler getDropDownChangeHandler() {
        return this.dropDownChangeHandler;
    }

    public boolean getDropDownisVisible() {
        return this.dropDown != null && this.dropDown.isVisible();
    }

    public void hideDropDown() {
        if (this.dropDown != null) {
            this.dropDown.hide();
        }
    }

    public void setDropDownChangeHandler(FEvent.FEventHandler changedHandler0) {
        this.dropDownChangeHandler = changedHandler0;
    }

    @Override
    public float getAutoSizeWidth() {
        float maxTextWidth = 0.0f;
        for (T item : this.items) {
            float width = this.font.getBounds((CharSequence)this.getDisplayText(item)).width;
            if (!(width > maxTextWidth)) continue;
            maxTextWidth = width;
        }
        return PADDING + maxTextWidth + this.getRightPadding();
    }

    @Override
    public void draw(Graphics g2) {
        super.draw(g2);
        float divotWidth = this.getDivotWidth();
        float divotHeight = divotWidth * 0.5f;
        float x3 = this.getWidth() - PADDING - 1.0f;
        float x1 = x3 - divotWidth;
        float x2 = x1 + divotWidth / 2.0f;
        float y1 = this.getHeight() / 2.0f - 1.0f;
        float y2 = y1 + divotHeight;
        float y3 = y1;
        g2.fillTriangle(FComboBox.getForeColor(), x1, y1, x2, y2, x3, y3);
    }

    private float getDivotWidth() {
        return this.getHeight() / 3.0f + 1.0f;
    }

    @Override
    protected float getLeftPadding() {
        if (this.getAlignment() == 1) {
            return this.getRightPadding();
        }
        return super.getLeftPadding();
    }

    @Override
    protected float getRightPadding() {
        return this.getDivotWidth() + 2.0f * PADDING;
    }

    private class DropDown
    extends FDropDownMenu {
        private DropDown() {
        }

        @Override
        protected boolean autoHide() {
            return FComboBox.this.autoClose;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (!FComboBox.this.autoClose) {
                this.hide();
            }
            return super.tap(x, y, count);
        }

        @Override
        protected void buildMenu() {
            for (Object item : FComboBox.this.items) {
                FMenuItem menuItem = new FMenuItem(FComboBox.this.getDisplayText(item), e -> {
                    if (FComboBox.this.dropDownItemTap != null) {
                        FComboBox.this.dropDownItemTap.handleEvent(new FEvent(FComboBox.this, FEvent.FEventType.TAP, item));
                    }
                    if (item != FComboBox.this.selectedItem) {
                        FComboBox.this.setSelectedItem(item);
                        if (FComboBox.this.dropDownChangeHandler != null) {
                            FComboBox.this.dropDownChangeHandler.handleEvent(new FEvent(FComboBox.this, FEvent.FEventType.CHANGE, item));
                        }
                    }
                });
                if (FComboBox.this.selectedItem == item) {
                    menuItem.setSelected(true);
                }
                this.addItem(menuItem);
            }
        }

        @Override
        protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
            this.clear();
            this.items.clear();
            this.buildMenu();
            float width = FComboBox.this.getWidth();
            float y = 0.0f;
            for (FMenuItem item : this.items) {
                item.setBounds(0.0f, y, width, FMenuItem.HEIGHT);
                y += FMenuItem.HEIGHT;
            }
            return new FScrollPane.ScrollBounds(width, y);
        }

        @Override
        protected void updateSizeAndPosition() {
            FContainer container = this.getContainer();
            float containerHeight = container.getHeight();
            float x = container.screenToLocalX(FComboBox.this.localToScreenX(0.0f));
            float y = FComboBox.this.localToScreenY(FComboBox.this.getHeight());
            float maxVisibleHeight = containerHeight - y;
            this.paneSize = this.updateAndGetPaneSize(FComboBox.this.getWidth(), maxVisibleHeight);
            this.setBounds(Math.round(x), Math.round(y), Math.round(FComboBox.this.getWidth()), Math.min((float)Math.round(this.paneSize.getHeight()), maxVisibleHeight));
        }

        @Override
        protected FDisplayObject getDropDownOwner() {
            return FComboBox.this;
        }
    }
}

