/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.gui.interfaces.ICheckBox;
import forge.toolbox.FLabel;
import forge.util.Utils;

public class FCheckBox
extends FLabel
implements ICheckBox {
    private static final float EXTRA_GAP = Utils.scale(3.0f);

    private static FSkinColor getCheckColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    private static FSkinColor getBoxColor() {
        return FCheckBox.getCheckColor().alphaColor(0.5f);
    }

    public FCheckBox() {
        this("", false);
    }

    public FCheckBox(String text0) {
        this(text0, false);
    }

    public FCheckBox(String text0, boolean selected0) {
        super(new FLabel.Builder().text(text0).align(8).selectable().selected(selected0));
        this.setIcon(new CheckBoxIcon());
    }

    @Override
    protected float getExtraGapBetweenIconAndText() {
        return EXTRA_GAP;
    }

    @Override
    public void draw(Graphics g2) {
        this.drawContent(g2, this.getWidth(), this.getHeight(), false);
    }

    public static void drawCheckBox(Graphics g2, boolean isChecked, float x, float y, float w, float h2) {
        FCheckBox.drawCheckBox(g2, FCheckBox.getBoxColor(), FCheckBox.getCheckColor(), isChecked, x, y, w, h2);
    }

    public static void drawCheckBox(Graphics g2, FSkinColor boxColor, FSkinColor checkColor, boolean isChecked, float x, float y, float w, float h2) {
        g2.drawRect(Utils.scale(1.0f), boxColor, x, y, w, h2);
        if (isChecked) {
            float padX = Utils.scale(3.0f);
            float thickness = Utils.scale(2.0f);
            g2.drawLine(thickness, checkColor, x += padX, (y += Utils.scale(1.0f)) + (h2 -= Utils.scale(3.0f)) / 2.0f, x + (w -= 2.0f * padX) / 2.0f, y + h2);
            g2.drawLine(thickness, checkColor, x + w / 2.0f, y + h2, x + w, y);
        }
    }

    private class CheckBoxIcon
    implements FImage {
        private CheckBoxIcon() {
        }

        @Override
        public float getWidth() {
            return FCheckBox.this.getHeight();
        }

        @Override
        public float getHeight() {
            return FCheckBox.this.getHeight();
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            FCheckBox.drawCheckBox(g2, FCheckBox.this.isSelected(), x, y, w, h2);
        }
    }
}

