/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkin;
import forge.card.CardImageRenderer;
import forge.card.CardRenderer;
import forge.card.CardStateName;
import forge.game.card.CardView;
import forge.game.zone.ZoneType;
import forge.screens.match.MatchController;
import forge.toolbox.FDisplayObject;
import forge.util.Utils;

public class FCardPanel
extends FDisplayObject {
    public static final float ASPECT_RATIO = 1.4f;
    public static final float PADDING = Utils.scale(2.0f);
    public static final float TARGET_ORIGIN_FACTOR_X = 0.15f;
    public static final float TARGET_ORIGIN_FACTOR_Y = 0.5f;
    private CardView card;
    private boolean tapped;
    private boolean highlighted;
    CardTapAnimation tapAnimation;
    CardUnTapAnimation untapAnimation;
    CardDestroyedAnimation destroyedAnimation;
    CardTransformAnimation transformAnimation;

    public FCardPanel() {
        this(null);
    }

    public FCardPanel(CardView card0) {
        this.card = card0;
        this.tapAnimation = new CardTapAnimation();
        this.untapAnimation = new CardUnTapAnimation();
        this.destroyedAnimation = new CardDestroyedAnimation();
        this.transformAnimation = new CardTransformAnimation();
    }

    public CardView getCard() {
        return this.card;
    }

    public void setCard(CardView card0) {
        this.card = card0;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted0) {
        this.highlighted = highlighted0;
    }

    public boolean isTapped() {
        return this.tapped;
    }

    public void setTapped(boolean tapped0) {
        this.tapped = tapped0;
    }

    protected float getTappedAngle() {
        return -90.0f;
    }

    protected boolean renderedCardContains(float x, float y) {
        float h2;
        float left = PADDING;
        float top = PADDING;
        float w = this.getWidth() - 2.0f * PADDING;
        if (w == (h2 = this.getHeight() - 2.0f * PADDING)) {
            w = h2 / 1.4f;
        }
        if (this.tapped) {
            top += h2 - w;
            float temp = w;
            w = h2;
            h2 = temp;
        }
        return x >= left && x <= left + w && y >= top && y <= top + h2;
    }

    protected float getPadding() {
        return PADDING;
    }

    protected CardRenderer.CardStackPosition getStackPosition() {
        return CardRenderer.CardStackPosition.Top;
    }

    @Override
    public void draw(Graphics g2) {
        float h2;
        if (this.card == null) {
            return;
        }
        boolean animate = Forge.animatedCardTapUntap;
        float mod = (this.isHighlighted() || this.isHovered()) && !Forge.hasGamepad() ? this.getWidth() / 16.0f : 0.0f;
        float padding = this.getPadding();
        float x = padding - mod / 2.0f;
        float y = padding - mod / 2.0f;
        float w = this.getWidth() - 2.0f * padding + mod;
        if (w == (h2 = this.getHeight() - 2.0f * padding + mod)) {
            w = h2 / 1.4f;
        }
        float edgeOffset = w / 2.0f;
        if (!ZoneType.Battlefield.equals((Object)this.card.getZone())) {
            this.rotateTransform(g2, x, y, w, h2, edgeOffset, false);
            return;
        }
        if (!animate || MatchController.instance.isGameFast() || MatchController.instance.getGameView() != null && MatchController.instance.getGameView().isMatchOver()) {
            this.rotateTransform(g2, x, y, w, h2, edgeOffset, false);
            this.card.updateNeedsTapAnimation(false);
            this.card.updateNeedsUntapAnimation(false);
            this.card.updateNeedsTransformAnimation(false);
        } else {
            if (this.card.wasDestroyed()) {
                if (this.destroyedAnimation.progress < 1.0f) {
                    this.destroyedAnimation.start();
                    this.destroyedAnimation.drawCard(g2, this.card, x, y, w, h2, edgeOffset);
                } else {
                    this.rotateTransform(g2, x, y, w, h2, edgeOffset, animate);
                }
                return;
            }
            if (this.card.needsTapAnimation()) {
                if (this.tapAnimation.progress < 1.0f) {
                    this.tapAnimation.start();
                    this.tapAnimation.drawCard(g2, this.card, x, y, w, h2, w / 2.0f, this.getTappedAngle());
                } else {
                    this.rotateTransform(g2, x, y, w, h2, edgeOffset, animate);
                }
            } else if (this.card.needsUntapAnimation()) {
                if (this.untapAnimation.progress < 1.0f) {
                    this.untapAnimation.start();
                    this.untapAnimation.drawCard(g2, this.card, x, y, w, h2, edgeOffset);
                } else {
                    this.rotateTransform(g2, x, y, w, h2, edgeOffset, animate);
                }
            } else {
                this.rotateTransform(g2, x, y, w, h2, edgeOffset, animate);
            }
        }
    }

    private void rotateTransform(Graphics g2, float x, float y, float w, float h2, float edgeOffset, boolean animate) {
        if (this.tapped) {
            g2.startRotateTransform(x + edgeOffset, y + h2 - edgeOffset, this.getTappedAngle());
        }
        if (this.card.needsTransformAnimation() && animate) {
            this.transformAnimation.start();
            this.transformAnimation.drawCard(g2, this.card, x, y, w, h2);
        } else {
            CardRenderer.drawCardWithOverlays(g2, this.card, x, y, w, h2, this.getStackPosition());
            if (Forge.hasGamepad() && this.isHovered()) {
                g2.drawRect(3.0f, Color.LIME, x, y, w, h2);
            }
        }
        if (this.tapped) {
            g2.endTransform();
        }
    }

    public String toString() {
        return this.card == null ? "" : this.card.toString();
    }

    private class CardTapAnimation
    extends ForgeAnimation {
        private static final float DURATION = 0.18f;
        private float progress = 0.0f;

        private CardTapAnimation() {
        }

        private void drawCard(Graphics g2, CardView card, float x, float y, float w, float h2, float edgeOffset, float angle) {
            float percentage = this.progress / 0.18f;
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
                this.progress = 0.0f;
            }
            g2.startRotateTransform(x + edgeOffset, y + h2 - edgeOffset, percentage * angle);
            CardRenderer.drawCardWithOverlays(g2, card, x, y, w, h2, FCardPanel.this.getStackPosition());
            g2.endTransform();
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < 0.18f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            FCardPanel.this.card.updateNeedsTapAnimation(false);
        }
    }

    private class CardUnTapAnimation
    extends ForgeAnimation {
        private static final float DURATION = 0.18f;
        private float progress = 0.0f;

        private CardUnTapAnimation() {
        }

        private void drawCard(Graphics g2, CardView card, float x, float y, float w, float h2, float edgeOffset) {
            float percentage = this.progress / 0.18f;
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
                this.progress = 0.0f;
            }
            float angle = -90.0f + percentage * 90.0f;
            g2.startRotateTransform(x + edgeOffset, y + h2 - edgeOffset, angle);
            CardRenderer.drawCardWithOverlays(g2, card, x, y, w, h2, FCardPanel.this.getStackPosition());
            g2.endTransform();
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < 0.18f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            FCardPanel.this.card.updateNeedsUntapAnimation(false);
        }
    }

    private class CardTransformAnimation
    extends ForgeAnimation {
        private float DURATION = 0.18f;
        private float progress = 0.0f;

        private CardTransformAnimation() {
        }

        private void drawCard(Graphics g2, CardView card, float x, float y, float w, float h2) {
            float percentage = this.progress / this.DURATION;
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
                this.progress = 0.0f;
            }
            float mod = percentage;
            float y2 = y + (h2 - h2 * mod) / 2.0f;
            float x2 = x + (w - w * mod) / 2.0f;
            float w2 = w * mod;
            float h22 = h2 * mod;
            float gap = h2 / 2.0f - percentage * (h2 / 2.0f);
            if (card.getCurrentState().getState() == CardStateName.Original) {
                this.DURATION = 0.16f;
                CardRenderer.drawCardWithOverlays(g2, card, x2, y, w2, h2, FCardPanel.this.getStackPosition());
            } else if (card.getCurrentState().getState() == CardStateName.Transformed || card.getCurrentState().getState() == CardStateName.Flipped) {
                this.DURATION = 0.16f;
                CardRenderer.drawCardWithOverlays(g2, card, x2, y, w2, h2, FCardPanel.this.getStackPosition());
            } else if (card.getCurrentState().getState() == CardStateName.Meld) {
                if (CardRenderer.getMeldCardParts(card.getCurrentState().getImageKey(), false) == CardImageRenderer.forgeArt) {
                    this.DURATION = 0.18f;
                    CardRenderer.drawCardWithOverlays(g2, card, x2, y2, w2, h22, FCardPanel.this.getStackPosition());
                } else {
                    this.DURATION = 0.25f;
                    g2.drawImage(CardRenderer.getMeldCardParts(card.getCurrentState().getImageKey(), false), x, y - gap, w, h2 / 2.0f);
                    g2.drawImage(CardRenderer.getMeldCardParts(card.getCurrentState().getImageKey(), true), x, y + h2 / 2.0f + gap, w, h2 / 2.0f);
                }
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < this.DURATION;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            FCardPanel.this.card.updateNeedsTransformAnimation(false);
        }
    }

    private class CardDestroyedAnimation
    extends ForgeAnimation {
        private static final float DURATION = 0.6f;
        private float progress = 0.0f;
        private Texture splatter = Forge.getAssets().getTexture(FSkin.getDefaultSkinFile("splatter.png"));

        private CardDestroyedAnimation() {
        }

        private void drawCard(Graphics g2, CardView card, float x, float y, float w, float h2, float edgeOffset) {
            float percentage = this.progress / 0.6f;
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
                this.progress = 0.0f;
            }
            float mod = w * percentage;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (FCardPanel.this.tapped) {
                g2.startRotateTransform(x + edgeOffset, y + h2 - edgeOffset, FCardPanel.this.getTappedAngle());
            }
            CardRenderer.drawCardWithOverlays(g2, card, x - mod / 2.0f, y - mod / 2.0f, w + mod, h2 + mod, FCardPanel.this.getStackPosition());
            if (this.splatter != null) {
                g2.setAlphaComposite(0.6f);
                g2.drawCardImage(this.splatter, null, x - mod / 2.0f, y - mod / 2.0f, w + mod, h2 + mod, true, false);
                g2.setAlphaComposite(oldAlpha);
            }
            if (FCardPanel.this.tapped) {
                g2.endTransform();
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < 0.6f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
        }
    }
}

