/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.toolbox.FButton;
import forge.toolbox.FChoiceList;
import forge.toolbox.FDialog;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.util.Callback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DualListBox<T>
extends FDialog {
    private final ChoiceList sourceList;
    private final ChoiceList destList;
    private final FButton addButton;
    private final FButton addAllButton;
    private final FButton removeButton;
    private final FButton removeAllButton;
    private final FLabel orderedLabel;
    private final FLabel selectOrder;
    private final int targetRemainingSourcesMin;
    private final int targetRemainingSourcesMax;

    public DualListBox(String title, int remainingSources, List<T> sourceElements, List<T> destElements, Callback<List<T>> callback) {
        this(title, remainingSources, remainingSources, sourceElements, destElements, callback);
    }

    public DualListBox(String title, int remainingSourcesMin, int remainingSourcesMax, List<T> sourceElements, List<T> destElements, Callback<List<T>> callback) {
        super(title, 2);
        this.targetRemainingSourcesMin = remainingSourcesMin;
        this.targetRemainingSourcesMax = remainingSourcesMax;
        FEvent.FEventHandler onAdd = new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                if (!DualListBox.this.addButton.isEnabled()) {
                    return;
                }
                List selected = DualListBox.this.sourceList.getSelectedItems();
                DualListBox.this.destList.clearSelection();
                for (Object item : selected) {
                    DualListBox.this.sourceList.removeItem(item);
                    DualListBox.this.destList.addSelectedIndex(DualListBox.this.destList.getCount());
                    DualListBox.this.destList.addItem(item);
                }
                DualListBox.this.sourceList.cleanUpSelections();
                DualListBox.this.setButtonState();
            }
        };
        FEvent.FEventHandler onRemove = new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                if (!DualListBox.this.removeButton.isEnabled()) {
                    return;
                }
                List selected = DualListBox.this.destList.getSelectedItems();
                DualListBox.this.sourceList.clearSelection();
                for (Object item : selected) {
                    DualListBox.this.destList.removeItem(item);
                    DualListBox.this.sourceList.addSelectedIndex(DualListBox.this.sourceList.getCount());
                    DualListBox.this.sourceList.addItem(item);
                }
                DualListBox.this.destList.cleanUpSelections();
                DualListBox.this.setButtonState();
            }
        };
        Object typeItem = null;
        if (sourceElements != null && sourceElements.size() > 0) {
            typeItem = sourceElements.get(0);
        } else if (destElements != null && destElements.size() > 0) {
            typeItem = destElements.get(0);
        }
        this.sourceList = this.add(new ChoiceList(sourceElements, typeItem, onAdd));
        this.destList = this.add(new ChoiceList(destElements, typeItem, onRemove));
        this.addButton = this.add(new FButton(">", onAdd));
        this.addAllButton = this.add(new FButton(">>", e -> this.addAll()));
        this.removeButton = this.add(new FButton("<", onRemove));
        this.removeAllButton = this.add(new FButton("<<", e -> this.removeAll()));
        FEvent.FEventHandler onAccept = e -> {
            this.hide();
            callback.run(this.destList.extractListData());
        };
        this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), onAccept);
        this.initButton(1, Forge.getLocalizer().getMessage("lblAuto", new Object[0]), e -> {
            this.addAll();
            onAccept.handleEvent(e);
        });
        this.selectOrder = this.add(new FLabel.Builder().align(1).text(Forge.getLocalizer().getMessage("lblSelectOrder", new Object[0])).build());
        this.orderedLabel = this.add(new FLabel.Builder().align(1).build());
        this.setButtonState();
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float x = FOptionPane.PADDING;
        float y = FOptionPane.PADDING / 2.0f;
        width -= 2.0f * x;
        float gapBetweenButtons = FOptionPane.PADDING / 2.0f;
        float labelHeight = this.selectOrder.getAutoSizeBounds().height;
        float listHeight = (maxHeight - 2.0f * labelHeight - 2.0f * FOptionPane.PADDING) / 2.0f;
        float addButtonWidth = this.addAllButton.getAutoSizeBounds().width * 1.2f;
        float addButtonHeight = listHeight / 2.0f - gapBetweenButtons;
        float listWidth = width - addButtonWidth - gapBetweenButtons;
        this.selectOrder.setBounds(x, y, width, labelHeight);
        this.sourceList.setBounds(x, y += labelHeight, listWidth, listHeight);
        this.addButton.setBounds(x += width - addButtonWidth, y, addButtonWidth, addButtonHeight);
        this.addAllButton.setBounds(x, y + addButtonHeight + gapBetweenButtons, addButtonWidth, addButtonHeight);
        x = FOptionPane.PADDING;
        this.orderedLabel.setBounds(x, y += listHeight + FOptionPane.PADDING / 2.0f, width, labelHeight);
        this.removeButton.setBounds(x, y += labelHeight, addButtonWidth, addButtonHeight);
        this.removeAllButton.setBounds(x, y + addButtonHeight + gapBetweenButtons, addButtonWidth, addButtonHeight);
        this.destList.setBounds(x + width - listWidth, y, listWidth, listHeight);
        return maxHeight;
    }

    public void setSecondColumnLabelText(String label) {
        this.orderedLabel.setText(label);
    }

    public List<T> getRemainingSourceList() {
        return this.sourceList.extractListData();
    }

    private void addAll() {
        this.destList.clearSelection();
        for (Object item : this.sourceList) {
            this.destList.addSelectedIndex(this.destList.getCount());
            this.destList.addItem(item);
        }
        this.sourceList.clear();
        this.setButtonState();
    }

    private void removeAll() {
        this.sourceList.clearSelection();
        for (Object item : this.destList) {
            this.sourceList.addSelectedIndex(this.sourceList.getCount());
            this.sourceList.addItem(item);
        }
        this.destList.clear();
        this.setButtonState();
    }

    private void setButtonState() {
        boolean anySize = this.targetRemainingSourcesMax < 0;
        boolean canAdd = this.sourceList.getCount() != 0 && (anySize || this.targetRemainingSourcesMin <= this.sourceList.getCount());
        boolean canRemove = this.destList.getCount() != 0;
        boolean targetReached = anySize || this.targetRemainingSourcesMin <= this.sourceList.getCount() && this.targetRemainingSourcesMax >= this.sourceList.getCount();
        this.setButtonEnabled(1, this.targetRemainingSourcesMax == 0 && !targetReached);
        this.addButton.setEnabled(canAdd);
        this.addAllButton.setEnabled(canAdd);
        this.removeButton.setEnabled(canRemove);
        this.removeAllButton.setEnabled(canRemove);
        this.setButtonEnabled(0, targetReached);
    }

    @Override
    public boolean keyDown(int keyCode) {
        switch (keyCode) {
            case 66: 
            case 111: {
                if (this.getButton(0).trigger()) {
                    return true;
                }
                return this.getButton(1).trigger();
            }
            case 62: {
                if (!this.getButton(0).trigger()) break;
                return true;
            }
            case 4: {
                return true;
            }
        }
        return super.keyDown(keyCode);
    }

    private class ChoiceList
    extends FChoiceList<T> {
        private final FEvent.FEventHandler onActivate;

        private ChoiceList(Collection<T> items, T typeItem, FEvent.FEventHandler onActivate0) {
            super(items != null ? items : new ArrayList(), typeItem);
            this.onActivate = onActivate0;
        }

        @Override
        protected void onItemActivate(Integer index, T value) {
            this.onActivate.handleEvent(new FEvent(this, FEvent.FEventType.ACTIVATE, value));
        }
    }
}

