/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import forge.Forge;
import forge.adventure.stage.GameHUD;
import forge.sound.IAudioMusic;

public class AudioMusic
implements IAudioMusic {
    private Music music;
    private FileHandle file;

    public AudioMusic(String filename) {
        this.file = Gdx.files.absolute(filename);
        this.music = Forge.getAssets().getMusic(this.file);
    }

    @Override
    public void play(Runnable onComplete) {
        if (this.music == null) {
            return;
        }
        if (Forge.isMobileAdventureMode && GameHUD.getInstance().audioIsPlaying()) {
            return;
        }
        this.music.setOnCompletionListener(music -> onComplete.run());
        this.music.play();
    }

    @Override
    public void pause() {
        if (this.music == null) {
            return;
        }
        if (this.music.isPlaying()) {
            this.music.pause();
        }
    }

    @Override
    public void resume() {
        if (this.music == null) {
            return;
        }
        if (!this.music.isPlaying()) {
            this.music.play();
        }
    }

    @Override
    public void stop() {
        if (this.music == null) {
            return;
        }
        this.music.setOnCompletionListener(null);
        this.music.stop();
    }

    @Override
    public void dispose() {
        this.stop();
        Forge.getAssets().manager().unload(this.file.path());
    }

    @Override
    public void setVolume(float value) {
        if (this.music == null) {
            return;
        }
        this.music.setVolume(value);
    }
}

