/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import forge.sound.IAudioClip;

public class AudioClip
implements IAudioClip {
    private Sound clip;

    public static AudioClip createClip(String filename) {
        FileHandle fileHandle = Gdx.files.absolute(filename);
        if (!fileHandle.exists()) {
            return null;
        }
        return new AudioClip(fileHandle);
    }

    private AudioClip(FileHandle fileHandle) {
        try {
            this.clip = Gdx.audio.newSound(fileHandle);
        }
        catch (Exception ex) {
            System.err.println("Unable to load sound file: " + fileHandle.toString());
        }
    }

    @Override
    public final void play(float value) {
        if (this.clip == null) {
            return;
        }
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.clip.play(value);
    }

    @Override
    public final void loop() {
        if (this.clip == null) {
            return;
        }
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.clip.loop();
    }

    @Override
    public void dispose() {
        if (this.clip != null) {
            this.clip.dispose();
            this.clip = null;
        }
    }

    @Override
    public final void stop() {
        if (this.clip == null) {
            return;
        }
        this.clip.stop();
    }

    @Override
    public final boolean isDone() {
        return this.clip != null;
    }
}

