/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.settings;

import forge.Forge;
import forge.gui.UiCommand;
import forge.gui.download.GuiDownloadService;
import forge.gui.download.GuiDownloadZipService;
import forge.toolbox.FDialog;
import forge.toolbox.FEvent;
import forge.toolbox.FProgressBar;
import forge.toolbox.FRadioButton;
import forge.toolbox.FTextField;
import forge.util.Callback;
import forge.util.Utils;
import java.net.Proxy;

public class GuiDownloader
extends FDialog {
    public static final Proxy.Type[] TYPES = Proxy.Type.values();
    private static final float PADDING = Utils.scale(10.0f);
    private final FProgressBar progressBar = this.add(new FProgressBar());
    private final FTextField txtAddress = this.add(new FTextField());
    private final FTextField txtPort = this.add(new FTextField());
    private final FRadioButton radProxyNone = this.add(new FRadioButton("No Proxy"));
    private final FRadioButton radProxySocks = this.add(new FRadioButton("SOCKS Proxy"));
    private final FRadioButton radProxyHTTP = this.add(new FRadioButton("HTTP Proxy"));
    private final UiCommand cmdClose = new UiCommand(){

        @Override
        public void run() {
            Forge.stopContinuousRendering();
            GuiDownloader.this.service.setCancel(true);
            GuiDownloader.this.hide();
            if (GuiDownloader.this.callback != null) {
                GuiDownloader.this.callback.run(GuiDownloader.this.getButton(0).getText() == "OK");
            }
        }
    };
    private final GuiDownloadService service;
    private final Callback<Boolean> callback;

    public GuiDownloader(GuiDownloadService service0) {
        this(service0, null);
    }

    public GuiDownloader(GuiDownloadService service0, Callback<Boolean> callback0) {
        super(service0.getTitle(), 2);
        this.service = service0;
        this.callback = callback0;
        this.txtAddress.setGhostText("Proxy Address");
        this.txtPort.setGhostText("Proxy Port");
        this.txtAddress.setEnabled(false);
        this.txtPort.setEnabled(false);
        FRadioButton.RadioButtonGroup group = new FRadioButton.RadioButtonGroup();
        this.radProxyNone.setGroup(group);
        this.radProxyHTTP.setGroup(group);
        this.radProxySocks.setGroup(group);
        this.radProxyNone.setCommand(new ProxyHandler(0));
        this.radProxyHTTP.setCommand(new ProxyHandler(1));
        this.radProxySocks.setCommand(new ProxyHandler(2));
        this.radProxyNone.setSelected(true);
        this.getButton(0).setText("Start");
        this.initButton(1, "Cancel", e -> this.cmdClose.run());
        this.progressBar.reset();
        this.progressBar.setShowProgressTrail(true);
        this.progressBar.setDescription("Scanning for existing items...");
    }

    @Override
    public void show() {
        Forge.startContinuousRendering();
        super.show();
        this.service.initialize(this.txtAddress, this.txtPort, this.progressBar, this.getButton(0), this.cmdClose, () -> {
            if (!(this.service instanceof GuiDownloadZipService)) {
                Forge.stopContinuousRendering();
            }
            this.progressBar.setShowProgressTrail(false);
        }, null);
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float x = PADDING;
        float y = PADDING;
        float w = width - 2.0f * PADDING;
        float radioButtonWidth = w / 3.0f;
        float radioButtonHeight = this.radProxyNone.getAutoSizeBounds().height;
        this.radProxyNone.setBounds(x, y, radioButtonWidth, radioButtonHeight);
        this.radProxyHTTP.setBounds(x += radioButtonWidth, y, radioButtonWidth, radioButtonHeight);
        this.radProxySocks.setBounds(x += radioButtonWidth, y, radioButtonWidth, radioButtonHeight);
        x = PADDING;
        this.txtAddress.setBounds(x, y += radioButtonHeight + PADDING, w, this.txtAddress.getHeight());
        this.txtPort.setBounds(x, y += this.txtAddress.getHeight() + PADDING, w, this.txtPort.getHeight());
        this.progressBar.setBounds(x, y += this.txtPort.getHeight() + PADDING * 2.0f, w, this.txtPort.getHeight() * 1.5f);
        return y += this.progressBar.getHeight() + PADDING * 2.0f;
    }

    private class ProxyHandler
    implements FEvent.FEventHandler {
        private final int type;

        public ProxyHandler(int type) {
            this.type = type;
        }

        @Override
        public void handleEvent(FEvent e) {
            if (((FRadioButton)e.getSource()).isSelected()) {
                GuiDownloader.this.service.setType(this.type);
                GuiDownloader.this.txtAddress.setEnabled(this.type != 0);
                GuiDownloader.this.txtPort.setEnabled(this.type != 0);
            }
        }
    }
}

