/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FTextureRegionImage;
import forge.assets.ImageCache;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.FDeckEditor;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.quest.IQuestTournamentView;
import forge.gamemodes.quest.QuestDraftUtils;
import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.QuestTournamentController;
import forge.gamemodes.quest.data.QuestEventDraftContainer;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.LoadingOverlay;
import forge.screens.limited.DraftingProcessScreen;
import forge.screens.quest.QuestDraftDeckEditor;
import forge.screens.quest.QuestEventPanel;
import forge.screens.quest.QuestLaunchScreen;
import forge.toolbox.FButton;
import forge.toolbox.FContainer;
import forge.toolbox.FLabel;
import forge.toolbox.FTextField;
import forge.util.Utils;
import java.util.Arrays;

public class QuestTournamentsScreen
extends QuestLaunchScreen
implements IQuestTournamentView {
    private final SelectTournamentPanel pnlSelectTournament = this.add(new SelectTournamentPanel());
    private final FLabel lblCredits = this.pnlSelectTournament.add(new FLabel.Builder().icon(FSkinImage.QUEST_COINSTACK).iconScaleFactor(0.75f).font(FSkinFont.get(16)).build());
    private final FLabel btnSpendToken = this.pnlSelectTournament.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("btnSpendToken", new Object[0]) + " (0)").build());
    private final FLabel lblInfo = this.pnlSelectTournament.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblSelectaTournament", new Object[0]) + ":").align(1).font(FSkinFont.get(16)).build());
    private final FLabel lblNoTournaments = this.pnlSelectTournament.add(new FLabel.Builder().align(1).text(Forge.getLocalizer().getMessage("lblNoTournaments", new Object[0])).insets(Vector2.Zero).font(FSkinFont.get(12)).build());
    private final QuestEventPanel.Container pnlTournaments = this.pnlSelectTournament.add(new QuestEventPanel.Container());
    private final PrepareDeckPanel pnlPrepareDeck = this.add(new PrepareDeckPanel());
    private final FButton btnEditDeck = this.add(new FButton(Forge.getLocalizer().getMessage("btnEditDeck", new Object[0])));
    private final FButton btnLeaveTournament = this.add(new FButton(Forge.getLocalizer().getMessage("btnLeaveTournament", new Object[0])));
    private final CardManager deckViewer = this.pnlPrepareDeck.add(new CardManager(false));
    private final TournamentActivePanel pnlTournamentActive = this.add(new TournamentActivePanel());
    private final FButton btnEditDeckInTourn = this.add(new FButton(Forge.getLocalizer().getMessage("btnEditDeck", new Object[0])));
    private final FButton btnLeaveTournamentInTourn = this.add(new FButton(Forge.getLocalizer().getMessage("btnLeaveTournament", new Object[0])));
    private static final FSkinFont RESULTS_FONT = FSkinFont.get(15);
    private static final Vector2 RESULTS_INSETS = new Vector2(2.0f * PADDING, 0.0f);
    private final FLabel lblFirst = new FLabel.Builder().font(RESULTS_FONT).insets(RESULTS_INSETS).build();
    private final FLabel lblSecond = new FLabel.Builder().font(RESULTS_FONT).insets(RESULTS_INSETS).build();
    private final FLabel lblThird = new FLabel.Builder().font(RESULTS_FONT).insets(RESULTS_INSETS).build();
    private final FLabel lblFourth = new FLabel.Builder().font(RESULTS_FONT).insets(RESULTS_INSETS).build();
    private QuestDraftUtils.Mode mode;
    private final QuestTournamentController controller = new QuestTournamentController(this);

    public QuestTournamentsScreen() {
        this.btnSpendToken.setCommand(event -> FThreads.invokeInBackgroundThread(this.controller::spendToken));
        this.btnEditDeck.setCommand(event -> this.editDeck(true));
        this.btnLeaveTournament.setCommand(event -> FThreads.invokeInBackgroundThread(this.controller::endTournamentAndAwardPrizes));
        this.btnEditDeckInTourn.setCommand(event -> this.editDeck(true));
        this.btnLeaveTournamentInTourn.setCommand(event -> FThreads.invokeInBackgroundThread(this.controller::endTournamentAndAwardPrizes));
        this.pnlPrepareDeck.add(this.btnEditDeck);
        this.pnlPrepareDeck.add(this.btnLeaveTournament);
        this.pnlTournamentActive.add(this.btnEditDeckInTourn);
        this.pnlTournamentActive.add(this.btnLeaveTournamentInTourn);
        this.deckViewer.setCaption(Forge.getLocalizer().getMessage("ttMain", new Object[0]));
        this.deckViewer.setup(ItemManagerConfig.QUEST_DRAFT_DECK_VIEWER);
        this.setMode(QuestDraftUtils.Mode.SELECT_TOURNAMENT);
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        this.pnlSelectTournament.setBounds(0.0f, startY, width, height -= startY);
        this.pnlPrepareDeck.setBounds(0.0f, startY, width, height);
        this.pnlTournamentActive.setBounds(0.0f, startY, width, height);
    }

    @Override
    protected String getGameType() {
        return "Tournaments";
    }

    @Override
    public void onUpdate() {
        this.controller.update();
        if (this.mode == QuestDraftUtils.Mode.PREPARE_DECK) {
            Deck deck = this.getDeck();
            if (deck != null) {
                this.deckViewer.setPool(deck.getMain());
            } else {
                this.deckViewer.setPool(new CardPool());
            }
        }
    }

    @Override
    protected void updateHeaderCaption() {
        if (this.mode == QuestDraftUtils.Mode.PREPARE_DECK) {
            String title = FModel.getQuest().getAchievements().getCurrentDraft() == null ? "" : FModel.getQuest().getAchievements().getCurrentDraft().getTitle();
            this.setHeaderCaption(FModel.getQuest().getName() + " - " + this.getGameType() + "\n" + Forge.getLocalizer().getMessage("lblDraft", new Object[0]) + " - " + title);
        } else {
            super.updateHeaderCaption();
        }
    }

    @Override
    public QuestDraftUtils.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(QuestDraftUtils.Mode mode0) {
        if (this.mode == mode0) {
            return;
        }
        this.mode = mode0;
        this.pnlSelectTournament.setVisible(this.mode == QuestDraftUtils.Mode.SELECT_TOURNAMENT || this.mode == QuestDraftUtils.Mode.EMPTY);
        this.pnlPrepareDeck.setVisible(this.mode == QuestDraftUtils.Mode.PREPARE_DECK);
        this.pnlTournamentActive.setVisible(this.mode == QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
        this.btnEditDeckInTourn.setVisible(this.mode == QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
        this.btnLeaveTournamentInTourn.setVisible(this.mode == QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
        this.btnEditDeck.setVisible(this.mode == QuestDraftUtils.Mode.PREPARE_DECK);
        this.btnLeaveTournament.setVisible(this.mode == QuestDraftUtils.Mode.PREPARE_DECK);
        this.updateHeaderCaption();
    }

    @Override
    public void populate() {
    }

    @Override
    public void updateEventList(QuestEventDraftContainer events) {
        this.pnlTournaments.clear();
        if (events != null) {
            for (QuestEventDraft event : events) {
                this.pnlTournaments.add(new QuestEventPanel(event, this.pnlTournaments));
            }
        }
        this.pnlTournaments.revalidate();
        boolean hasTournaments = this.pnlTournaments.getChildCount() > 0;
        this.pnlTournaments.setVisible(hasTournaments);
        this.lblNoTournaments.setVisible(!hasTournaments);
    }

    @Override
    public void updateTournamentBoxLabel(String playerID, int iconID, int box, boolean first) {
        this.pnlTournamentActive.clear();
        this.pnlTournamentActive.revalidate();
    }

    @Override
    public void startDraft(BoosterDraft draft) {
        FThreads.invokeInEdtLater(() -> LoadingOverlay.show("Loading Quest Tournament", true, () -> Forge.openScreen(new DraftingProcessScreen(draft, FDeckEditor.EditorType.QuestDraft, this.controller))));
    }

    private Deck getDeck() {
        DeckGroup deckGroup = FModel.getQuest().getDraftDecks().get("Tournament Deck");
        if (deckGroup != null) {
            return deckGroup.getHumanDeck();
        }
        return null;
    }

    @Override
    public void editDeck(boolean isExistingDeck) {
        Deck deck = this.getDeck();
        if (deck != null) {
            ImageCache.preloadCache(deck);
            if (isExistingDeck) {
                Forge.openScreen(new QuestDraftDeckEditor(deck.getName()));
            } else {
                Forge.openScreen(new QuestDraftDeckEditor(deck));
            }
        }
    }

    @Override
    protected void startMatch() {
        if (this.mode == QuestDraftUtils.Mode.TOURNAMENT_ACTIVE && QuestDraftUtils.isNextMatchAIvsAI()) {
            this.controller.startNextMatch();
            this.revalidate();
            return;
        }
        FThreads.invokeInBackgroundThread(() -> {
            switch (this.mode) {
                case SELECT_TOURNAMENT: {
                    this.controller.startDraft();
                    break;
                }
                case PREPARE_DECK: {
                    this.controller.startTournament();
                    break;
                }
                case TOURNAMENT_ACTIVE: {
                    this.controller.startNextMatch();
                    break;
                }
            }
        });
    }

    @Override
    public FLabel getLblCredits() {
        return this.lblCredits;
    }

    @Override
    public FLabel getLblFirst() {
        return this.lblFirst;
    }

    @Override
    public FLabel getLblSecond() {
        return this.lblSecond;
    }

    @Override
    public FLabel getLblThird() {
        return this.lblThird;
    }

    @Override
    public FLabel getLblFourth() {
        return this.lblFourth;
    }

    @Override
    public FLabel getBtnSpendToken() {
        return this.btnSpendToken;
    }

    @Override
    public FButton getBtnLeaveTournament() {
        return this.btnLeaveTournament;
    }

    public FButton getBtnEditDeckInTourn() {
        return this.btnEditDeckInTourn;
    }

    public FButton getBtnLeaveTournamentInTourn() {
        return this.btnLeaveTournamentInTourn;
    }

    private class TournamentActivePanel
    extends FContainer {
        private TournamentActivePanel() {
        }

        @Override
        protected void doLayout(float width, float height) {
            QuestEventDraft qd = FModel.getQuest().getAchievements().getCurrentDraft();
            if (qd == null) {
                return;
            }
            float x = QuestLaunchScreen.PADDING;
            float w = width - 2.0f * QuestLaunchScreen.PADDING;
            float buttonWidth = (width - 3.0f * QuestLaunchScreen.PADDING) / 2.0f;
            float y = QuestLaunchScreen.PADDING;
            FLabel[] labels = new FLabel[16];
            String[] playerIDs = new String[16];
            int[] iconIDs = new int[16];
            String draftTitle = qd.getFullTitle();
            FLabel lblStandings = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblDraft", new Object[0]) + ": " + draftTitle).align(1).font(FSkinFont.get(20)).build());
            lblStandings.setBounds(x, y, w, lblStandings.getAutoSizeBounds().height);
            y += lblStandings.getHeight() + QuestLaunchScreen.PADDING;
            boolean tournamentComplete = !qd.playerHasMatchesLeft();
            QuestTournamentsScreen.this.btnEditDeckInTourn.setVisible(QuestTournamentsScreen.this.mode == QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
            QuestTournamentsScreen.this.btnLeaveTournamentInTourn.setVisible(QuestTournamentsScreen.this.mode == QuestDraftUtils.Mode.TOURNAMENT_ACTIVE);
            if (tournamentComplete) {
                String sid = qd.getStandings()[qd.getStandings().length - 1];
                String winnersName = sid.equals("quest_draft_human_place") ? FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME) : (sid.equals("quest_draft_undetermined_place") ? "---" : qd.getAINames()[Integer.parseInt(sid) - 1]);
                FLabel lblWinner = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblWinner", new Object[0]) + ": " + winnersName).align(1).font(FSkinFont.get(20)).build());
                lblWinner.setBounds(x, y, w, lblStandings.getAutoSizeBounds().height);
                y += lblWinner.getHeight() + QuestLaunchScreen.PADDING;
                QuestTournamentsScreen.this.getBtnLeaveTournamentInTourn().setText(Forge.getLocalizer().getMessage("lblCollectPrizes", new Object[0]));
            } else {
                QuestTournamentsScreen.this.getBtnLeaveTournamentInTourn().setText(Forge.getLocalizer().getMessage("btnLeaveTournament", new Object[0]));
                String pairedPlayer1 = "NONE";
                String pairedPlayer2 = "NONE";
                int pos = Arrays.asList(qd.getStandings()).indexOf("quest_draft_undetermined_place");
                if (pos != -1) {
                    int offset = (pos - 8) * 2;
                    String sid1 = qd.getStandings()[offset];
                    String sid2 = qd.getStandings()[offset + 1];
                    pairedPlayer1 = sid1.equals("quest_draft_human_place") ? FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME) : qd.getAINames()[Integer.parseInt(sid1) - 1];
                    pairedPlayer2 = sid2.equals("quest_draft_human_place") ? FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME) : qd.getAINames()[Integer.parseInt(sid2) - 1];
                }
                block15: for (int i = 0; i < 15; ++i) {
                    String playerID;
                    switch (playerID = qd.getStandings()[i]) {
                        case "quest_draft_human_place": {
                            playerIDs[i] = FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
                            if (FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",").length <= 0) continue block15;
                            iconIDs[i] = Integer.parseInt(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",")[0]);
                            continue block15;
                        }
                        case "quest_draft_undetermined_place": {
                            playerIDs[i] = "Undetermined";
                            iconIDs[i] = GuiBase.getInterface().getAvatarCount() - 1;
                            continue block15;
                        }
                        default: {
                            iconIDs[i] = qd.getAIIcons()[Integer.parseInt(playerID) - 1];
                            playerIDs[i] = qd.getAINames()[Integer.parseInt(playerID) - 1];
                        }
                    }
                }
                for (int j = 0; j < 13; j += 2) {
                    switch (j) {
                        case 0: {
                            FLabel qfinals = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblQuarterfinals", new Object[0])).align(1).font(FSkinFont.get(16)).build());
                            qfinals.setBounds(x, y, w, qfinals.getAutoSizeBounds().height);
                            y += qfinals.getHeight() + QuestLaunchScreen.PADDING;
                            break;
                        }
                        case 8: {
                            FLabel sfinals = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblSemifinals", new Object[0])).align(1).font(FSkinFont.get(16)).build());
                            sfinals.setBounds(x, y, w, sfinals.getAutoSizeBounds().height);
                            y += sfinals.getHeight() + QuestLaunchScreen.PADDING;
                            break;
                        }
                        case 12: {
                            FLabel finals = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblFinalMatch", new Object[0])).align(1).font(FSkinFont.get(16)).build());
                            finals.setBounds(x, y, w, finals.getAutoSizeBounds().height);
                            y += finals.getHeight() + QuestLaunchScreen.PADDING;
                            break;
                        }
                    }
                    boolean currentMatch = !(!playerIDs[j].equals(pairedPlayer1) && !playerIDs[j + 1].equals(pairedPlayer1) || !playerIDs[j].equals(pairedPlayer2) && !playerIDs[j + 1].equals(pairedPlayer2));
                    String labelText = playerIDs[j] + " vs. " + playerIDs[j + 1];
                    if (Forge.isLandscapeMode()) {
                        try {
                            FTextureRegionImage avatar1 = new FTextureRegionImage(FSkin.getAvatars().get(iconIDs[j]));
                            FTextureRegionImage avatar2 = new FTextureRegionImage(FSkin.getAvatars().get(iconIDs[j + 1]));
                            FLabel PlayerA = this.add(new FLabel.Builder().icon(avatar1).build());
                            FLabel PlayerB = this.add(new FLabel.Builder().icon(avatar2).build());
                            if (currentMatch) {
                                float avatarSize = FSkinFont.get(20).getLineHeight() * 4.0f;
                                PlayerA.setBounds(QuestLaunchScreen.PADDING * 2.0f, 0.0f, avatarSize, avatarSize);
                                PlayerB.setBounds(width - avatarSize - QuestLaunchScreen.PADDING, 0.0f, avatarSize, avatarSize);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    labels[j] = Forge.hdbuttons ? this.add(new FLabel.Builder().icon(currentMatch ? FSkinImage.HDSTAR_FILLED : FSkinImage.HDSTAR_OUTLINE).text(labelText).align(1).font(FSkinFont.get(16)).build()) : this.add(new FLabel.Builder().icon(currentMatch ? FSkinImage.STAR_FILLED : FSkinImage.STAR_OUTLINE).text(labelText).align(1).font(FSkinFont.get(16)).build());
                    labels[j].setBounds(x, y, w, labels[j].getAutoSizeBounds().height);
                    if (currentMatch) {
                        labels[j].setTextColor(FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE));
                    }
                    y += labels[j].getHeight();
                    if (j != 6 && j != 10) continue;
                    y += QuestLaunchScreen.PADDING;
                }
            }
            QuestTournamentsScreen.this.btnEditDeckInTourn.setBounds(QuestLaunchScreen.PADDING, y += lblStandings.getHeight() - QuestLaunchScreen.PADDING * 3.0f, buttonWidth, FTextField.getDefaultHeight());
            QuestTournamentsScreen.this.btnLeaveTournamentInTourn.setBounds(QuestTournamentsScreen.this.btnEditDeckInTourn.getRight() + QuestLaunchScreen.PADDING, y, buttonWidth, QuestTournamentsScreen.this.btnEditDeckInTourn.getHeight());
        }
    }

    private class PrepareDeckPanel
    extends FContainer {
        private PrepareDeckPanel() {
        }

        @Override
        protected void doLayout(float width, float height) {
            float y = QuestLaunchScreen.PADDING;
            float buttonWidth = (width - 3.0f * QuestLaunchScreen.PADDING) / 2.0f;
            QuestTournamentsScreen.this.btnEditDeck.setBounds(QuestLaunchScreen.PADDING, y, buttonWidth, FTextField.getDefaultHeight());
            QuestTournamentsScreen.this.btnLeaveTournament.setBounds(QuestTournamentsScreen.this.btnEditDeck.getRight() + QuestLaunchScreen.PADDING, y, buttonWidth, QuestTournamentsScreen.this.btnEditDeck.getHeight());
            QuestTournamentsScreen.this.deckViewer.setBounds(0.0f, y += QuestTournamentsScreen.this.btnEditDeck.getHeight() + QuestLaunchScreen.PADDING - ItemFilter.PADDING, width, height - y);
        }
    }

    private class SelectTournamentPanel
    extends FContainer {
        private SelectTournamentPanel() {
        }

        @Override
        protected void doLayout(float width, float height) {
            float gap;
            float y = gap = Utils.scale(2.0f);
            float halfWidth = width / 2.0f;
            QuestTournamentsScreen.this.lblCredits.setBounds(0.0f, y, halfWidth, ((QuestTournamentsScreen)QuestTournamentsScreen.this).lblCredits.getAutoSizeBounds().height);
            QuestTournamentsScreen.this.btnSpendToken.setBounds(halfWidth, y, halfWidth - gap, QuestTournamentsScreen.this.lblCredits.getHeight());
            float x = QuestLaunchScreen.PADDING;
            float w = width - 2.0f * QuestLaunchScreen.PADDING;
            QuestTournamentsScreen.this.lblInfo.setBounds(x, y += QuestTournamentsScreen.this.lblCredits.getHeight() + gap, w, ((QuestTournamentsScreen)QuestTournamentsScreen.this).lblInfo.getAutoSizeBounds().height);
            QuestTournamentsScreen.this.lblNoTournaments.setBounds(x, y += QuestTournamentsScreen.this.lblInfo.getHeight() + gap, w, ((QuestTournamentsScreen)QuestTournamentsScreen.this).lblNoTournaments.getAutoSizeBounds().height);
            QuestTournamentsScreen.this.pnlTournaments.setBounds(x, y, w, height - y);
        }
    }
}

