/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.assets.FSkinImage;
import forge.deck.FDeckEditor;
import forge.gamemodes.quest.IVQuestStats;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.QuestDataIO;
import forge.gui.FThreads;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.ICheckBox;
import forge.gui.interfaces.IComboBox;
import forge.localinstance.properties.ForgeConstants;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.HomeScreen;
import forge.screens.home.LoadGameMenu;
import forge.screens.home.NewGameMenu;
import forge.screens.quest.QuestBazaarScreen;
import forge.screens.quest.QuestChallengesScreen;
import forge.screens.quest.QuestDecksScreen;
import forge.screens.quest.QuestDuelsScreen;
import forge.screens.quest.QuestPrefsScreen;
import forge.screens.quest.QuestSpellShopScreen;
import forge.screens.quest.QuestStatsScreen;
import forge.screens.quest.QuestTournamentsScreen;
import forge.util.ThreadUtil;
import java.io.File;
import java.io.IOException;

public class QuestMenu
extends FPopupMenu
implements IVQuestStats {
    private static final QuestMenu questMenu = new QuestMenu();
    private static final QuestBazaarScreen bazaarScreen = new QuestBazaarScreen();
    private static final QuestChallengesScreen challengesScreen = new QuestChallengesScreen();
    private static final QuestDecksScreen decksScreen = new QuestDecksScreen();
    private static final QuestDuelsScreen duelsScreen = new QuestDuelsScreen();
    private static final QuestPrefsScreen prefsScreen = new QuestPrefsScreen();
    private static final QuestSpellShopScreen spellShopScreen = new QuestSpellShopScreen();
    private static final QuestStatsScreen statsScreen = new QuestStatsScreen();
    private static final QuestTournamentsScreen tournamentsScreen = new QuestTournamentsScreen();
    private static final FMenuItem duelsItem = new FMenuItem(Forge.getLocalizer().getMessage("lblDuels", new Object[0]), FSkinImage.QUEST_BIG_SWORD, event -> QuestMenu.setCurrentScreen(duelsScreen));
    private static final FMenuItem challengesItem = new FMenuItem(Forge.getLocalizer().getMessage("lblChallenges", new Object[0]), FSkinImage.QUEST_HEART, event -> QuestMenu.setCurrentScreen(challengesScreen));
    private static final FMenuItem tournamentsItem = new FMenuItem(Forge.getLocalizer().getMessage("lblTournaments", new Object[0]), FSkinImage.QUEST_BIG_SHIELD, event -> QuestMenu.setCurrentScreen(tournamentsScreen));
    private static final FMenuItem decksItem = new FMenuItem(Forge.getLocalizer().getMessage("lblQuestDecks", new Object[0]), FSkinImage.QUEST_BIG_BAG, event -> QuestMenu.setCurrentScreen(decksScreen));
    private static final FMenuItem spellShopItem = new FMenuItem(Forge.getLocalizer().getMessage("lblSpellShop", new Object[0]), FSkinImage.QUEST_BOOK, event -> QuestMenu.setCurrentScreen(spellShopScreen));
    private static final FMenuItem bazaarItem = new FMenuItem(Forge.getLocalizer().getMessage("lblBazaar", new Object[0]), FSkinImage.QUEST_BOTTLES, event -> QuestMenu.setCurrentScreen(bazaarScreen));
    private static final FMenuItem statsItem = new FMenuItem(Forge.getLocalizer().getMessage("lblStatistics", new Object[0]), FSkinImage.MENU_STATS, event -> QuestMenu.setCurrentScreen(statsScreen));
    private static final FMenuItem unlockSetsItem = new FMenuItem(Forge.getLocalizer().getMessage("btnUnlockSets", new Object[0]), FSkinImage.QUEST_MAP, event -> ThreadUtil.invokeInGameThread(() -> {
        QuestUtil.chooseAndUnlockEdition();
        FThreads.invokeInEdtLater(QuestMenu::updateCurrentQuestScreen);
    }));
    private static final FMenuItem travelItem = new FMenuItem(Forge.getLocalizer().getMessage("btnTravel", new Object[0]), FSkinImage.QUEST_MAP, event -> ThreadUtil.invokeInGameThread(() -> {
        QuestUtil.travelWorld();
        FThreads.invokeInEdtLater(QuestMenu::updateCurrentQuestScreen);
    }));
    private static final FMenuItem prefsItem = new FMenuItem(Forge.getLocalizer().getMessage("Preferences", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPREFERENCE : FSkinImage.SETTINGS, event -> QuestMenu.setCurrentScreen(prefsScreen));

    private static void setCurrentScreen(FScreen screen0) {
        Forge.openScreen(screen0, Forge.getCurrentScreen() != duelsScreen);
    }

    private static void updateCurrentQuestScreen() {
        if (duelsItem.isSelected()) {
            duelsScreen.update();
        } else if (challengesItem.isSelected()) {
            challengesScreen.update();
        } else if (tournamentsItem.isSelected()) {
            tournamentsScreen.update();
        } else if (decksItem.isSelected()) {
            decksScreen.refreshDecks();
        } else if (spellShopItem.isSelected()) {
            spellShopScreen.update();
        } else if (statsItem.isSelected()) {
            statsScreen.update();
        }
    }

    public static QuestMenu getMenu() {
        return questMenu;
    }

    private QuestMenu() {
    }

    public static void launchQuestMode(LaunchReason reason, boolean commanderMode) {
        Forge.lastButtonIndex = 6;
        HomeScreen.instance.updateQuestCommanderMode(commanderMode);
        QuestMenu.decksScreen.commanderMode = commanderMode;
        File dirQuests = new File(ForgeConstants.QUEST_SAVE_DIR);
        String questname = FModel.getQuestPreferences().getPref(QuestPreferences.QPref.CURRENT_QUEST);
        File data = new File(dirQuests.getPath(), questname);
        if (data.exists()) {
            LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingCurrentQuest", new Object[0]), true, () -> {
                try {
                    FModel.getQuest().load(QuestDataIO.loadData(data));
                }
                catch (IOException e) {
                    System.err.printf("Failed to load quest '%s'%n", questname);
                    return;
                }
                FDeckEditor.EditorType.Quest.getController().setRootFolder(FModel.getQuest().getMyDecks());
                FDeckEditor.EditorType.QuestCommander.getController().setRootFolder(FModel.getQuest().getMyDecks());
                FDeckEditor.EditorType.QuestDraft.getController().setRootFolder(FModel.getQuest().getDraftDecks());
                if (reason == LaunchReason.StartQuestMode) {
                    if (QuestUtil.getCurrentDeck() == null) {
                        Forge.openScreen(decksScreen);
                    } else {
                        Forge.openScreen(duelsScreen);
                    }
                } else {
                    duelsScreen.update();
                    challengesScreen.update();
                    tournamentsScreen.update();
                    decksScreen.refreshDecks();
                    Forge.openScreen(duelsScreen);
                    if (reason == LaunchReason.NewQuest) {
                        LoadGameMenu.LoadGameScreen.QuestMode.setAsBackScreen(true);
                    }
                }
                HomeScreen.instance.updateQuestWorld(FModel.getQuest().getWorld() == null ? "" : FModel.getQuest().getWorld().toString());
            });
            return;
        }
        if (dirQuests.exists() && dirQuests.isDirectory() && dirQuests.list().length > 0) {
            LoadGameMenu.LoadGameScreen.QuestMode.open();
        } else {
            NewGameMenu.NewGameScreen.QuestMode.open();
        }
    }

    @Override
    protected void buildMenu() {
        FScreen currentScreen = Forge.getCurrentScreen();
        this.addItem(duelsItem);
        duelsItem.setSelected(currentScreen == duelsScreen);
        this.addItem(challengesItem);
        challengesItem.setSelected(currentScreen == challengesScreen);
        this.addItem(tournamentsItem);
        tournamentsItem.setSelected(currentScreen == tournamentsScreen);
        this.addItem(decksItem);
        decksItem.setSelected(currentScreen == decksScreen);
        this.addItem(spellShopItem);
        spellShopItem.setSelected(currentScreen == spellShopScreen);
        this.addItem(bazaarItem);
        bazaarItem.setSelected(currentScreen == bazaarScreen);
        this.addItem(unlockSetsItem);
        if (!HomeScreen.instance.getQuestCommanderMode()) {
            this.addItem(travelItem);
        }
        this.addItem(statsItem);
        statsItem.setSelected(currentScreen == statsScreen);
        this.addItem(prefsItem);
        prefsItem.setSelected(currentScreen == prefsScreen);
    }

    @Override
    public IButton getBtnBazaar() {
        return bazaarItem;
    }

    @Override
    public IButton getBtnSpellShop() {
        return spellShopItem;
    }

    @Override
    public IButton getBtnUnlock() {
        return unlockSetsItem;
    }

    @Override
    public IButton getBtnTravel() {
        return travelItem;
    }

    @Override
    public IButton getLblCredits() {
        return statsScreen.getLblCredits();
    }

    @Override
    public IButton getLblLife() {
        return statsScreen.getLblLife();
    }

    @Override
    public IButton getLblWorld() {
        return statsScreen.getLblWorld();
    }

    @Override
    public IButton getLblWins() {
        return statsScreen.getLblWins();
    }

    @Override
    public IButton getLblLosses() {
        return statsScreen.getLblLosses();
    }

    @Override
    public IButton getLblNextChallengeInWins() {
        return Forge.getCurrentScreen() == challengesScreen ? challengesScreen.getLblNextChallengeInWins() : duelsScreen.getLblNextChallengeInWins();
    }

    @Override
    public IButton getLblCurrentDeck() {
        return Forge.getCurrentScreen() == challengesScreen ? challengesScreen.getLblCurrentDeck() : duelsScreen.getLblCurrentDeck();
    }

    @Override
    public IButton getLblWinStreak() {
        return statsScreen.getLblWinStreak();
    }

    @Override
    public IComboBox<String> getCbxPet() {
        return statsScreen.getCbxPet();
    }

    @Override
    public ICheckBox getCbPlant() {
        return statsScreen.getCbPlant();
    }

    @Override
    public IComboBox<String> getCbxMatchLength() {
        return statsScreen.getCbxMatchLength();
    }

    @Override
    public IButton getLblZep() {
        return statsScreen.getLblZep();
    }

    @Override
    public boolean isChallengesView() {
        return Forge.getCurrentScreen() == challengesScreen || Forge.getCurrentScreen() == statsScreen;
    }

    @Override
    public boolean allowHtml() {
        return false;
    }

    public static void showSpellShop() {
        Forge.openScreen(spellShopScreen);
    }

    public static void showBazaar() {
        Forge.openScreen(bazaarScreen);
    }

    static {
        statsScreen.addTournamentResultsLabels(tournamentsScreen);
        if (Forge.isLandscapeMode()) {
            HomeScreen.instance.addButtonForMode("-" + Forge.getLocalizer().getMessage("lblQuestMode", new Object[0]), event -> QuestMenu.launchQuestMode(LaunchReason.StartQuestMode, HomeScreen.instance.getQuestCommanderMode()));
        }
    }

    public static enum LaunchReason {
        StartQuestMode,
        LoadQuest,
        NewQuest;

    }
}

