/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import com.badlogic.gdx.graphics.Color;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.ImageCache;
import forge.gamemodes.quest.IQuestEvent;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FList;
import forge.toolbox.FScrollPane;
import forge.util.Utils;

class QuestEventPanel
extends FDisplayObject {
    private static final FSkinFont TITLE_FONT = FSkinFont.get(16);
    private static final FSkinFont DESC_FONT = FSkinFont.get(12);
    private static final FSkinColor TITLE_COLOR = FList.getForeColor();
    private static final FSkinColor DESC_COLOR = SettingsScreen.DESC_COLOR;
    private static final float PADDING = Utils.scale(5.0f);
    private static final FSkinColor GRADIENT_LEFT_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_THEME2).alphaColor(0.78431374f);
    private static final Color GRADIENT_RIGHT_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.0f);
    private static final float RADIO_BUTTON_RADIUS = Utils.AVG_FINGER_WIDTH / 4.0f;
    private static final float MIN_HEIGHT = 2.0f * Utils.AVG_FINGER_HEIGHT;
    private final IQuestEvent event;
    private final FImage image;
    private final Container container;

    QuestEventPanel(IQuestEvent e0, Container container0) {
        this.event = e0;
        this.image = this.event.getFullTitle().startsWith("Random Opponent") ? FSkinImage.UNKNOWN : (this.event.hasImage() ? ImageCache.getIcon(e0) : null);
        this.container = container0;
        if (this.container.selectedPanel == null) {
            this.setSelected(true);
        }
    }

    public IQuestEvent getEvent() {
        return this.event;
    }

    public boolean isSelected() {
        return this.container.selectedPanel == this;
    }

    public void setSelected(boolean selected0) {
        if (this.container.selectedPanel == this) {
            if (!selected0) {
                this.container.selectedPanel = null;
            }
        } else if (selected0) {
            this.container.selectedPanel = this;
            this.event.select();
        }
    }

    @Override
    public boolean tap(float x, float y, int count) {
        this.setSelected(true);
        if (count == 2 && this.container.activateHandler != null) {
            this.container.activateHandler.handleEvent(new FEvent(this, FEvent.FEventType.ACTIVATE));
        }
        return true;
    }

    @Override
    public void draw(Graphics g2) {
        float w = this.getWidth() * 0.85f;
        float h2 = this.getHeight() * 0.85f;
        g2.fillGradientRect(GRADIENT_LEFT_COLOR, GRADIENT_RIGHT_COLOR, false, 0.0f, 0.0f, w, h2);
        float x = PADDING;
        float y = PADDING;
        if (this.image != null) {
            float imageSize = h2 - 2.0f * PADDING;
            float maxImageSize = w / 3.0f;
            if (imageSize > maxImageSize) {
                y += (imageSize - maxImageSize) / 2.0f;
                imageSize = maxImageSize;
            }
            g2.drawImage(this.image, x, y, imageSize, imageSize);
            x += imageSize + 2.0f * PADDING;
            y = 2.0f * PADDING;
        }
        String title = this.event.getFullTitle();
        g2.drawText(title, TITLE_FONT, TITLE_COLOR, x, y, w -= x + 2.0f * (RADIO_BUTTON_RADIUS + PADDING), h2, false, 8, false);
        g2.drawText(this.event.getDescription(), DESC_FONT, DESC_COLOR, x, y += TITLE_FONT.getCapHeight() + 2.0f * PADDING, w, h2 - PADDING - y, true, 8, false);
        x = this.getWidth() - PADDING - RADIO_BUTTON_RADIUS;
        y = h2 / 2.0f;
        g2.drawCircle(Utils.scale(1.0f), SettingsScreen.DESC_COLOR, x, y, RADIO_BUTTON_RADIUS);
        if (this.isSelected()) {
            g2.fillCircle(TITLE_COLOR, x, y, RADIO_BUTTON_RADIUS / 2.0f);
        }
    }

    static class Container
    extends FScrollPane {
        private QuestEventPanel selectedPanel;
        private FEvent.FEventHandler activateHandler;

        Container() {
        }

        void setActivateHandler(FEvent.FEventHandler activateHandler0) {
            this.activateHandler = activateHandler0;
        }

        @Override
        public void clear() {
            super.clear();
            this.selectedPanel = null;
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            if (this.getChildCount() == 0) {
                return new FScrollPane.ScrollBounds(visibleWidth, visibleHeight);
            }
            int numberOfPanels = Math.max(3, this.getChildCount());
            float y = 0.0f;
            float panelHeight = Math.max(MIN_HEIGHT, (visibleHeight + PADDING * (float)(numberOfPanels - 1)) / (float)numberOfPanels);
            for (FDisplayObject pnl : this.getChildren()) {
                pnl.setBounds(0.0f, y, visibleWidth, panelHeight);
                y += panelHeight - PADDING;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y -= PADDING);
        }
    }
}

