/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.assets.FSkinFont;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gui.FThreads;
import forge.gui.interfaces.IButton;
import forge.model.FModel;
import forge.screens.LoadingOverlay;
import forge.screens.quest.QuestEventPanel;
import forge.screens.quest.QuestLaunchScreen;
import forge.toolbox.FLabel;
import java.util.List;

public class QuestDuelsScreen
extends QuestLaunchScreen {
    private final FLabel lblInfo = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblSelectNextDuel", new Object[0])).align(1).font(FSkinFont.get(16)).build());
    private final FLabel lblCurrentDeck = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblNoDuelDeck", new Object[0])).align(1).insets(Vector2.Zero).font(FSkinFont.get(12)).build());
    private final FLabel lblNextChallengeInWins = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblNextChallengeNotYet", new Object[0])).align(1).insets(Vector2.Zero).font(FSkinFont.get(12)).build());
    private final QuestEventPanel.Container pnlDuels = this.add(new QuestEventPanel.Container());

    public QuestDuelsScreen() {
        this.pnlDuels.setActivateHandler(event -> this.startMatch());
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING / 2.0f;
        float w = width - 2.0f * PADDING;
        this.lblInfo.setBounds(x, y, w, this.lblInfo.getAutoSizeBounds().height);
        this.lblCurrentDeck.setBounds(x, y += this.lblInfo.getHeight(), w, this.lblCurrentDeck.getAutoSizeBounds().height);
        this.lblNextChallengeInWins.setBounds(x, y += this.lblCurrentDeck.getHeight(), w, this.lblCurrentDeck.getHeight());
        this.pnlDuels.setBounds(x, y += this.lblCurrentDeck.getHeight() + PADDING / 2.0f, w, height - y + PADDING * 2.0f);
    }

    public IButton getLblNextChallengeInWins() {
        return this.lblNextChallengeInWins;
    }

    public IButton getLblCurrentDeck() {
        return this.lblCurrentDeck;
    }

    @Override
    protected String getGameType() {
        return "Duels";
    }

    @Override
    public void onUpdate() {
        this.generateDuels();
    }

    private void generateDuels() {
        FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingCurrentQuest", new Object[0]), true, () -> {
            this.pnlDuels.clear();
            List<QuestEventDuel> duels = FModel.getQuest().getDuelsManager().generateDuels();
            if (duels != null) {
                for (QuestEventDuel duel : duels) {
                    this.pnlDuels.add(new QuestEventPanel(duel, this.pnlDuels));
                }
            }
            this.pnlDuels.revalidate();
        }));
    }
}

