/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.deck.DeckProxy;
import forge.deck.FDeckEditor;
import forge.gamemodes.quest.QuestSpellShop;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManagerConfig;
import forge.model.FModel;
import java.util.HashMap;
import java.util.Map;

public class QuestDeckEditor
extends FDeckEditor {
    public QuestDeckEditor(boolean commander) {
        super(commander ? FDeckEditor.EditorType.QuestCommander : FDeckEditor.EditorType.Quest, "", false);
    }

    public QuestDeckEditor(DeckProxy editDeck, boolean commander) {
        super(commander ? FDeckEditor.EditorType.QuestCommander : FDeckEditor.EditorType.Quest, editDeck, true);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        QuestSpellShop.updateDecksForEachCard();
    }

    @Override
    protected Map<ColumnDef, ItemColumn> getColOverrides(ItemManagerConfig config) {
        HashMap<ColumnDef, ItemColumn> colOverrides = new HashMap<ColumnDef, ItemColumn>();
        switch (config) {
            case QUEST_EDITOR_POOL: {
                ItemColumn.addColOverride(config, colOverrides, ColumnDef.NEW, FModel.getQuest().getCards().getFnNewCompare(), FModel.getQuest().getCards().getFnNewGet());
                break;
            }
            case QUEST_DECK_EDITOR: {
                ItemColumn.addColOverride(config, colOverrides, ColumnDef.NEW, FModel.getQuest().getCards().getFnNewCompare(), FModel.getQuest().getCards().getFnNewGet());
                ItemColumn.addColOverride(config, colOverrides, ColumnDef.DECKS, QuestSpellShop.fnDeckCompare, QuestSpellShop.fnDeckGet);
                break;
            }
            default: {
                colOverrides = null;
            }
        }
        return colOverrides;
    }

    public void addCheatCard(PaperCard card, int qty) {
        this.getCatalogPage().addCard(card, qty);
        FModel.getQuest().getCards().getCardpool().add(card, qty);
    }
}

