/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.StartingPoolPreferences;
import forge.gamemodes.quest.StartingPoolType;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.FThreads;
import forge.gui.UiCommand;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.item.PreconDeck;
import forge.itemmanager.filters.ArchivedFormatSelect;
import forge.localinstance.properties.ForgeConstants;
import forge.model.CardCollections;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.NewGameMenu;
import forge.screens.quest.QuestMenu;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FNumericTextField;
import forge.toolbox.FOptionPane;
import forge.toolbox.FRadioButton;
import forge.toolbox.FScrollPane;
import forge.util.FileUtil;
import forge.util.ThreadUtil;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class NewQuestScreen
extends FScreen {
    private static final float EMBARK_BTN_HEIGHT = 2.0f * Utils.AVG_FINGER_HEIGHT;
    private static final float PADDING = FOptionPane.PADDING;
    private final List<String> customFormatCodes = new ArrayList<String>();
    private final List<String> customPrizeFormatCodes = new ArrayList<String>();
    private final FScrollPane scroller = this.add(new FScrollPane(){
        private int colorBoxCount = 0;

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float x = PADDING;
            float y = PADDING;
            float right = visibleWidth - PADDING;
            float h2 = NewQuestScreen.this.cbxStartingWorld.getHeight();
            float gapY = PADDING / 2.0f;
            for (FDisplayObject obj : this.getChildren()) {
                if (!obj.isVisible()) continue;
                if (obj instanceof FColorCheckBox) {
                    float visWidth = (visibleWidth - PADDING) / 3.0f;
                    float xAdjustment = visWidth * (float)(this.colorBoxCount++ % 3);
                    if (this.colorBoxCount == 1 || this.colorBoxCount == 4) {
                        xAdjustment += PADDING;
                    }
                    obj.setBounds(xAdjustment, y, visWidth, h2);
                    x += obj.getWidth();
                    if (this.colorBoxCount % 3 != 0) continue;
                    y += h2 + gapY;
                    x = PADDING;
                    continue;
                }
                if (obj instanceof FLabel && obj != NewQuestScreen.this.lblPoolDistribution && obj != NewQuestScreen.this.lblPoolOptions && obj != NewQuestScreen.this.lblPreferredColor) {
                    FLabel lbl = (FLabel)obj;
                    if (lbl.getText().endsWith(":")) {
                        obj.setBounds(x, y, visibleWidth / 2.0f - x, h2);
                        x += obj.getWidth();
                        continue;
                    }
                    if (lbl.getAlignment() == 16) {
                        y -= gapY;
                    }
                }
                obj.setBounds(x, y, right - x, h2);
                x = PADDING;
                y += h2 + gapY;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }
    });
    private final FLabel lblStartingWorld = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblStartingWorld", new Object[0]) + ":").build());
    private final FComboBox<QuestWorld> cbxStartingWorld = this.scroller.add(new FComboBox());
    private final FLabel lblDifficulty = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblDifficulty", new Object[0]) + ":").build());
    private final FComboBox<String> cbxDifficulty = this.scroller.add(new FComboBox<String>(new String[]{Forge.getLocalizer().getMessage("questDifficultyEasy", new Object[0]), Forge.getLocalizer().getMessage("questDifficultyMedium", new Object[0]), Forge.getLocalizer().getMessage("questDifficultyHard", new Object[0]), Forge.getLocalizer().getMessage("questDifficultyExpert", new Object[0])}));
    private final FLabel lblStartingPool = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblStartingPool", new Object[0]) + ":").build());
    private final FComboBox<StartingPoolType> cbxStartingPool = this.scroller.add(new FComboBox());
    private final FLabel lblUnrestricted = this.scroller.add(new FLabel.Builder().align(16).font(FSkinFont.get(12)).text(Forge.getLocalizer().getMessage("lblAllCardsAvailable", new Object[0])).build());
    private final FLabel lblPreconDeck = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblStarterEventdeck", new Object[0]) + ":").build());
    private final FComboBox<String> cbxPreconDeck = this.scroller.add(new FComboBox());
    private final FLabel lblFormat = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblSelectFormat", new Object[0]) + ":").build());
    private final FComboBox<GameFormat> cbxFormat = this.scroller.add(new FComboBox());
    private final FLabel lblCustomDeck = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblCustomdeck", new Object[0]) + ":").build());
    private final FComboBox<Deck> cbxCustomDeck = this.scroller.add(new FComboBox());
    private final FLabel btnSelectFormat = this.scroller.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblChooseFormats", new Object[0])).build());
    private final FLabel lblPoolDistribution = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblStartingPoolDistribution", new Object[0]) + ":").build());
    private final FRadioButton radBalanced = this.scroller.add(new FRadioButton(Forge.getLocalizer().getMessage("lblBalanced", new Object[0])));
    private final FRadioButton radSurpriseMe = this.scroller.add(new FRadioButton(Forge.getLocalizer().getMessage("lblSurpriseMe", new Object[0])));
    private final FRadioButton radRandom = this.scroller.add(new FRadioButton(Forge.getLocalizer().getMessage("lblRandom", new Object[0])));
    private final FRadioButton radBoosters = this.scroller.add(new FRadioButton(Forge.getLocalizer().getMessage("lblBoosters", new Object[0])));
    private final FNumericTextField numberOfBoostersField = this.scroller.add(new FNumericTextField(10));
    private final FLabel lblPreferredColor = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblStartingPoolColors", new Object[0]) + ":").build());
    private final FColorCheckBox cbBlack = this.scroller.add(new FColorCheckBox(Forge.getLocalizer().getMessage("lblBlack", new Object[0])));
    private final FColorCheckBox cbBlue = this.scroller.add(new FColorCheckBox(Forge.getLocalizer().getMessage("lblBlue", new Object[0])));
    private final FColorCheckBox cbGreen = this.scroller.add(new FColorCheckBox(Forge.getLocalizer().getMessage("lblGreen", new Object[0])));
    private final FColorCheckBox cbRed = this.scroller.add(new FColorCheckBox(Forge.getLocalizer().getMessage("lblRed", new Object[0])));
    private final FColorCheckBox cbWhite = this.scroller.add(new FColorCheckBox(Forge.getLocalizer().getMessage("lblWhite", new Object[0])));
    private final FColorCheckBox cbColorless = this.scroller.add(new FColorCheckBox(Forge.getLocalizer().getMessage("lblColorless", new Object[0])));
    private final FLabel lblPoolOptions = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblStartingPoolOptions", new Object[0]) + ":").build());
    private final FCheckBox cbCompleteSet = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("lblStartWithAllCards", new Object[0])));
    private final FCheckBox cbDuplicateCards = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("lblAllowDuplicatesStartingPool", new Object[0])));
    private final FCheckBox cbIncludeArtifacts = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("lblIncludeArtifactsStartingPool", new Object[0])));
    private final FLabel lblPrizedCards = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblPrizedCards", new Object[0]) + ":").build());
    private final FComboBox<Object> cbxPrizedCards = this.scroller.add(new FComboBox());
    private final FLabel lblPrizeFormat = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblDefinedFormat", new Object[0]) + ":").build());
    private final FComboBox<GameFormat> cbxPrizeFormat = this.scroller.add(new FComboBox());
    private final FLabel lblPrizeUnrestricted = this.scroller.add(new FLabel.Builder().align(16).font(FSkinFont.get(12)).text(Forge.getLocalizer().getMessage("lblAllCardsAvailableWin", new Object[0])).build());
    private final FLabel lblPrizeSameAsStarting = this.scroller.add(new FLabel.Builder().align(16).font(FSkinFont.get(12)).text(Forge.getLocalizer().getMessage("lblOnlyInStartingPoolAvailable", new Object[0])).build());
    private final FLabel btnPrizeSelectFormat = this.scroller.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblChooseFormats", new Object[0])).build());
    private final FCheckBox cbAllowUnlocks = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("lblAllowUnlockAdEd", new Object[0])));
    private final FCheckBox cbFantasy = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("rbFantasyMode", new Object[0])));
    private final FCheckBox cbCommander = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("rbCommanderSubformat", new Object[0])));
    private final FLabel btnEmbark = this.add(new FLabel.ButtonBuilder().font(FSkinFont.get(22)).text(Forge.getLocalizer().getMessage("lblEmbark", new Object[0])).icon(FSkinImage.QUEST_ZEP).command(event -> ThreadUtil.invokeInGameThread(this::newQuest)).build());

    public NewQuestScreen() {
        super(null, NewGameMenu.getMenu());
        this.cbxStartingPool.addItem(StartingPoolType.Complete);
        this.cbxStartingPool.addItem(StartingPoolType.Sanctioned);
        this.cbxStartingPool.addItem(StartingPoolType.Casual);
        this.cbxStartingPool.addItem(StartingPoolType.Precon);
        this.cbxStartingPool.addItem(StartingPoolType.DraftDeck);
        this.cbxStartingPool.addItem(StartingPoolType.SealedDeck);
        this.cbxStartingPool.addItem(StartingPoolType.Cube);
        this.cbxStartingPool.setChangedHandler(event -> {
            this.updateStartingPoolOptions();
            this.scroller.revalidate();
        });
        this.cbxPrizedCards.addItem(Forge.getLocalizer().getMessage("lblSameAsStartingPool", new Object[0]));
        this.cbxPrizedCards.addItem((Object)StartingPoolType.Complete);
        this.cbxPrizedCards.addItem((Object)StartingPoolType.Sanctioned);
        this.cbxPrizedCards.addItem((Object)StartingPoolType.Casual);
        this.cbxPrizedCards.setChangedHandler(event -> {
            this.updatePrizeOptions();
            this.scroller.revalidate();
        });
        for (GameFormat gf : FModel.getFormats().getSanctionedList()) {
            this.cbxFormat.addItem(gf);
            this.cbxPrizeFormat.addItem(gf);
        }
        FRadioButton.RadioButtonGroup distributionGroup = new FRadioButton.RadioButtonGroup();
        this.radBalanced.setGroup(distributionGroup);
        this.radBalanced.setSelected(true);
        this.radRandom.setGroup(distributionGroup);
        this.radBoosters.setGroup(distributionGroup);
        this.radSurpriseMe.setGroup(distributionGroup);
        this.numberOfBoostersField.setEnabled(false);
        UiCommand colorBoxEnabler = () -> {
            this.cbBlack.setEnabled(this.radBalanced.isSelected());
            this.cbBlue.setEnabled(this.radBalanced.isSelected());
            this.cbGreen.setEnabled(this.radBalanced.isSelected());
            this.cbRed.setEnabled(this.radBalanced.isSelected());
            this.cbWhite.setEnabled(this.radBalanced.isSelected());
            this.cbColorless.setEnabled(this.radBalanced.isSelected());
            this.cbIncludeArtifacts.setEnabled(!this.radSurpriseMe.isSelected());
            this.numberOfBoostersField.setEnabled(this.radBoosters.isSelected());
        };
        this.radBalanced.setCommand(colorBoxEnabler);
        this.radRandom.setCommand(colorBoxEnabler);
        this.radBoosters.setCommand(colorBoxEnabler);
        this.radSurpriseMe.setCommand(colorBoxEnabler);
        for (QuestWorld qw : FModel.getWorlds()) {
            this.cbxStartingWorld.addItem(qw);
        }
        this.cbxStartingWorld.setSelectedItem(FModel.getWorlds().get("Main world"));
        this.cbxStartingWorld.setChangedHandler(event -> this.updateEnabledFormats());
        this.updateStartingPoolOptions();
        this.updatePrizeOptions();
        this.updateEnabledFormats();
        this.cbAllowUnlocks.setSelected(true);
        for (PreconDeck preconDeck : QuestController.getPrecons()) {
            if (QuestController.getPreconDeals(preconDeck).getMinWins() > 0) continue;
            String name = preconDeck.getName();
            this.cbxPreconDeck.addItem(name);
        }
        ArrayList<String> unselectableSets = new ArrayList<String>();
        unselectableSets.add("LEA");
        unselectableSets.add("LEB");
        unselectableSets.add("MBP");
        unselectableSets.add("VAN");
        unselectableSets.add("ARC");
        unselectableSets.add("PC2");
        this.btnSelectFormat.setCommand(event -> {
            ArchivedFormatSelect archivedFormatSelect = new ArchivedFormatSelect();
            archivedFormatSelect.setOnCloseCallBack(() -> {
                this.customFormatCodes.clear();
                this.btnSelectFormat.setText(archivedFormatSelect.getSelectedFormat().getName());
                List<String> setsToAdd = archivedFormatSelect.getSelectedFormat().getAllowedSetCodes();
                for (String setName : setsToAdd) {
                    if (unselectableSets.contains(setName)) continue;
                    this.customFormatCodes.add(setName);
                }
            });
            Forge.openScreen(archivedFormatSelect);
        });
        this.btnPrizeSelectFormat.setCommand(event -> {
            ArchivedFormatSelect archivedFormatSelect = new ArchivedFormatSelect();
            archivedFormatSelect.setOnCloseCallBack(() -> {
                this.customPrizeFormatCodes.clear();
                this.btnPrizeSelectFormat.setText(archivedFormatSelect.getSelectedFormat().getName());
                List<String> setsToAdd = archivedFormatSelect.getSelectedFormat().getAllowedSetCodes();
                for (String setName : setsToAdd) {
                    if (unselectableSets.contains(setName)) continue;
                    this.customPrizeFormatCodes.add(setName);
                }
            });
            Forge.openScreen(archivedFormatSelect);
        });
        this.cbFantasy.setSelected(true);
        this.cbFantasy.setEnabled(true);
        this.cbCommander.setSelected(false);
        this.cbCommander.setCommand(event -> {
            if (!this.isCommander()) {
                return;
            }
            this.cbxStartingWorld.setSelectedItem(FModel.getWorlds().get("Random Commander"));
        });
    }

    private void updateStartingPoolOptions() {
        StartingPoolType newVal = this.getStartingPoolType();
        this.lblUnrestricted.setVisible(newVal == StartingPoolType.Complete);
        this.lblPreconDeck.setVisible(newVal == StartingPoolType.Precon);
        this.cbxPreconDeck.setVisible(newVal == StartingPoolType.Precon);
        this.lblFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.cbxFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.btnSelectFormat.setVisible(newVal == StartingPoolType.Casual);
        boolean usesDeckList = newVal == StartingPoolType.SealedDeck || newVal == StartingPoolType.DraftDeck || newVal == StartingPoolType.Cube;
        this.lblCustomDeck.setVisible(usesDeckList);
        this.cbxCustomDeck.setVisible(usesDeckList);
        if (usesDeckList) {
            this.cbxCustomDeck.removeAllItems();
            CardCollections decks = FModel.getDecks();
            switch (newVal) {
                case SealedDeck: {
                    for (DeckGroup d : decks.getSealed()) {
                        this.cbxCustomDeck.addItem(d.getHumanDeck());
                    }
                    break;
                }
                case DraftDeck: {
                    for (DeckGroup d : decks.getDraft()) {
                        this.cbxCustomDeck.addItem(d.getHumanDeck());
                    }
                    break;
                }
                case Cube: {
                    for (Deck d : decks.getCubes()) {
                        this.cbxCustomDeck.addItem(d);
                    }
                    break;
                }
            }
        }
    }

    private void updatePrizeOptions() {
        StartingPoolType newVal = this.getPrizedPoolType();
        this.lblPrizeUnrestricted.setVisible(newVal == StartingPoolType.Complete);
        this.cbAllowUnlocks.setVisible(newVal != StartingPoolType.Complete);
        this.lblPrizeFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.cbxPrizeFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.btnPrizeSelectFormat.setVisible(newVal == StartingPoolType.Casual);
        this.lblPrizeSameAsStarting.setVisible(newVal == null);
        this.scroller.revalidate();
    }

    private void updateEnabledFormats() {
        QuestWorld qw = FModel.getWorlds().get(this.getStartingWorldName());
        if (qw != null) {
            this.cbxStartingPool.setEnabled(qw.getFormat() == null);
            this.cbxFormat.setEnabled(qw.getFormat() == null);
            this.cbxCustomDeck.setEnabled(qw.getFormat() == null);
            this.btnSelectFormat.setEnabled(qw.getFormat() == null);
        }
    }

    public int getSelectedDifficulty() {
        int difficulty = this.cbxDifficulty.getSelectedIndex();
        if (difficulty < 0) {
            difficulty = 0;
        }
        return difficulty;
    }

    public String getSelectedPrecon() {
        return this.cbxPreconDeck.getSelectedItem();
    }

    public Deck getSelectedDeck() {
        Deck sel = this.cbxCustomDeck.getSelectedItem();
        return sel != null ? sel : null;
    }

    public boolean isUnlockSetsAllowed() {
        return this.cbAllowUnlocks.isSelected();
    }

    public boolean startWithCompleteSet() {
        return this.cbCompleteSet.isSelected();
    }

    public boolean allowDuplicateCards() {
        return this.cbDuplicateCards.isSelected();
    }

    public StartingPoolType getStartingPoolType() {
        return this.cbxStartingPool.getSelectedItem();
    }

    public StartingPoolType getPrizedPoolType() {
        Object v = this.cbxPrizedCards.getSelectedItem();
        return v instanceof StartingPoolType ? (StartingPoolType)((Object)v) : null;
    }

    public String getStartingWorldName() {
        return this.cbxStartingWorld.getSelectedItem().toString();
    }

    public boolean isFantasy() {
        return this.cbFantasy.isSelected();
    }

    public boolean isCommander() {
        return this.cbCommander.isSelected();
    }

    public StartingPoolPreferences.PoolType getPoolType() {
        if (this.radSurpriseMe.isSelected()) {
            return StartingPoolPreferences.PoolType.RANDOM_BALANCED;
        }
        if (this.radRandom.isSelected()) {
            return StartingPoolPreferences.PoolType.RANDOM;
        }
        if (this.radBoosters.isSelected()) {
            return StartingPoolPreferences.PoolType.BOOSTERS;
        }
        return StartingPoolPreferences.PoolType.BALANCED;
    }

    public List<Byte> getPreferredColors() {
        ArrayList<Byte> preferredColors = new ArrayList<Byte>();
        if (this.cbBlack.isSelected()) {
            preferredColors.add((byte)4);
        }
        if (this.cbBlue.isSelected()) {
            preferredColors.add((byte)2);
        }
        if (this.cbGreen.isSelected()) {
            preferredColors.add((byte)16);
        }
        if (this.cbRed.isSelected()) {
            preferredColors.add((byte)8);
        }
        if (this.cbWhite.isSelected()) {
            preferredColors.add((byte)1);
        }
        if (this.cbColorless.isSelected()) {
            preferredColors.add((byte)0);
        }
        return preferredColors;
    }

    public GameFormat getSanctionedFormat() {
        return this.cbxFormat.getSelectedItem();
    }

    public GameFormat getPrizedRotatingFormat() {
        return this.cbxPrizeFormat.getSelectedItem();
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.btnEmbark.setBounds(PADDING, height - EMBARK_BTN_HEIGHT - PADDING, width - 2.0f * PADDING, EMBARK_BTN_HEIGHT);
        this.scroller.setBounds(0.0f, startY, width, this.btnEmbark.getTop() - startY);
    }

    private void newQuest() {
        String questName;
        GameFormat fmtPrizes;
        StartingPoolType prizedPoolType;
        GameFormat fmtStartPool;
        Deck dckStartPool;
        block22: {
            GameFormatQuest worldFormat;
            block21: {
                dckStartPool = null;
                fmtStartPool = null;
                QuestWorld startWorld = FModel.getWorlds().get(this.getStartingWorldName());
                GameFormatQuest gameFormatQuest = worldFormat = startWorld == null ? null : startWorld.getFormat();
                if (worldFormat != null) break block21;
                switch (this.getStartingPoolType()) {
                    case Sanctioned: {
                        fmtStartPool = this.getSanctionedFormat();
                        break;
                    }
                    case Casual: 
                    case CustomFormat: {
                        if (this.customFormatCodes.isEmpty() && !SOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblCustomFormatWithoutRestrictionGame", new Object[0]))) {
                            return;
                        }
                        fmtStartPool = this.customFormatCodes.isEmpty() ? null : new GameFormatQuest("Custom", this.customFormatCodes, null);
                        break;
                    }
                    case SealedDeck: 
                    case DraftDeck: 
                    case Cube: {
                        dckStartPool = this.getSelectedDeck();
                        if (dckStartPool == null) {
                            SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lbldckStartPool", new Object[0]), Forge.getLocalizer().getMessage("lblCannotStartaQuest", new Object[0]), SOptionPane.ERROR_ICON);
                            return;
                        }
                        break block22;
                    }
                    case Precon: {
                        dckStartPool = QuestController.getPrecons().get(this.getSelectedPrecon()).getDeck();
                        break;
                    }
                }
                break block22;
            }
            fmtStartPool = worldFormat;
        }
        if (null == (prizedPoolType = this.getPrizedPoolType())) {
            fmtPrizes = fmtStartPool;
            if (null == fmtPrizes && dckStartPool != null) {
                HashSet<String> sets = new HashSet<String>();
                for (PaperCard card : dckStartPool.getAllCardsInASinglePool().toFlatList()) {
                    sets.add(card.getEdition());
                }
                fmtPrizes = new GameFormat("From deck", sets, null);
            }
        } else {
            switch (prizedPoolType) {
                case Complete: {
                    fmtPrizes = null;
                    break;
                }
                case Casual: 
                case CustomFormat: {
                    if (this.customPrizeFormatCodes.isEmpty() && !SOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblCustomFormatWithoutRestrictionPrized", new Object[0]))) {
                        return;
                    }
                    fmtPrizes = this.customPrizeFormatCodes.isEmpty() ? null : new GameFormat("Custom Prizes", this.customPrizeFormatCodes, null);
                    break;
                }
                case Sanctioned: {
                    fmtPrizes = this.getPrizedRotatingFormat();
                    break;
                }
                default: {
                    throw new RuntimeException("Should not get this result");
                }
            }
        }
        while (true) {
            if ((questName = SOptionPane.showInputDialog(Forge.getLocalizer().getMessage("MsgQuestNewName", new Object[0]) + ":", Forge.getLocalizer().getMessage("TitQuestNewName", new Object[0]))) == null) {
                return;
            }
            if ((questName = QuestUtil.cleanString(questName)).isEmpty()) {
                SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblQuestNameEmpty", new Object[0]));
                continue;
            }
            if (!FileUtil.doesFileExist(ForgeConstants.QUEST_SAVE_DIR + questName + ".dat")) break;
            SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblQuestExists", new Object[0]));
        }
        this.startNewQuest(questName, fmtPrizes, dckStartPool, fmtStartPool);
    }

    private void startNewQuest(String questName, GameFormat fmtPrizes, Deck dckStartPool, GameFormat fmtStartPool) {
        FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblCreatingNewQuest", new Object[0]), true, () -> {
            QuestMode mode = this.isFantasy() ? QuestMode.Fantasy : QuestMode.Classic;
            StartingPoolPreferences userPrefs = new StartingPoolPreferences(this.getPoolType(), this.getPreferredColors(), this.cbIncludeArtifacts.isSelected(), this.startWithCompleteSet(), this.allowDuplicateCards(), this.numberOfBoostersField.getValue());
            QuestController qc = FModel.getQuest();
            DeckConstructionRules dcr = this.isCommander() ? DeckConstructionRules.Commander : DeckConstructionRules.Default;
            qc.newGame(questName, this.getSelectedDifficulty(), mode, fmtPrizes, this.isUnlockSetsAllowed(), dckStartPool, fmtStartPool, this.getStartingWorldName(), userPrefs, dcr);
            qc.save();
            FModel.getQuestPreferences().setPref(QuestPreferences.QPref.CURRENT_QUEST, questName + ".dat");
            FModel.getQuestPreferences().save();
            QuestMenu.launchQuestMode(QuestMenu.LaunchReason.NewQuest, this.isCommander());
        }));
    }

    private final class FColorCheckBox
    extends FCheckBox {
        private FColorCheckBox(String text0) {
            super(text0);
        }
    }
}

