/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.google.common.collect.Iterables;
import forge.Forge;
import forge.assets.FImage;
import forge.card.CardImage;
import forge.card.CardListPreview;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.gamemodes.planarconquest.ConquestController;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gui.FThreads;
import forge.item.PaperCard;
import forge.localinstance.achievements.PlaneswalkerAchievements;
import forge.model.FModel;
import forge.screens.LoadingOverlay;
import forge.screens.MultiStepWizardScreen;
import forge.screens.home.NewGameMenu;
import forge.screens.planarconquest.ConquestMenu;
import forge.screens.planarconquest.ConquestPlaneSelector;
import forge.screens.planarconquest.NewConquestScreenModel;
import forge.toolbox.FChoiceList;
import forge.toolbox.FOptionPane;
import forge.util.ThreadUtil;

public class NewConquestScreen
extends MultiStepWizardScreen<NewConquestScreenModel> {
    private static final float PADDING = FOptionPane.PADDING;

    public NewConquestScreen() {
        super(null, NewGameMenu.getMenu(), new MultiStepWizardScreen.WizardStep[]{new SelectStartingPlaneStep(), new SelectStartingCommanderStep(), new SelectStartingPlaneswalkerStep()}, new NewConquestScreenModel());
    }

    @Override
    protected void finish() {
        ThreadUtil.invokeInGameThread(this::newConquest);
    }

    private void newConquest() {
        String conquestName = ConquestUtil.promptForName();
        if (conquestName == null) {
            return;
        }
        this.startNewConquest(conquestName);
    }

    private void startNewConquest(String conquestName) {
        FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblStartingNewConquest", new Object[0]), true, () -> {
            ConquestController qc = FModel.getConquest();
            qc.setModel(new ConquestData(conquestName, ((NewConquestScreenModel)this.model).startingPlane, ((NewConquestScreenModel)this.model).startingPlaneswalker, ((NewConquestScreenModel)this.model).startingCommander));
            qc.getDecks().add(((ConquestCommander)Iterables.getFirst(qc.getModel().getCommanders(), null)).getDeck());
            qc.getModel().saveData();
            FModel.getConquestPreferences().setPref(ConquestPreferences.CQPref.CURRENT_CONQUEST, conquestName);
            FModel.getConquestPreferences().save();
            ConquestMenu.launchPlanarConquest(ConquestMenu.LaunchReason.NewConquest);
        }));
    }

    private static class SelectStartingPlaneswalkerStep
    extends MultiStepWizardScreen.WizardStep<NewConquestScreenModel> {
        private final FChoiceList<PaperCard> lstPlaneswalkers = this.add(new FChoiceList<PaperCard>(((ConquestPlane)FModel.getPlanes().iterator().next()).getCommanders()){

            @Override
            protected void onItemActivate(Integer index, PaperCard value) {
                this.advance();
            }

            @Override
            protected void onSelectionChange() {
                if (tokenDisplay == null) {
                    return;
                }
                this.updatePreview();
            }
        });
        private final CardListPreview tokenDisplay = this.add(new CardListPreview(this.lstPlaneswalkers));

        protected SelectStartingPlaneswalkerStep() {
            super(Forge.getLocalizer().getMessage("lblSelectStartingPlaneswalker", new Object[0]));
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = PADDING;
            float y = PADDING;
            float w = width - 2.0f * PADDING;
            this.tokenDisplay.setBounds(x, y, w, height * 0.5f);
            this.lstPlaneswalkers.setBounds(x, y += this.tokenDisplay.getHeight() + PADDING, w, height - y - PADDING);
        }

        @Override
        protected void reset() {
            if (this.lstPlaneswalkers.getCount() > 0) {
                this.lstPlaneswalkers.setSelectedIndex(0);
            }
        }

        private void updatePreview() {
            PaperCard planeswalker = this.lstPlaneswalkers.getSelectedItem();
            if (planeswalker != null) {
                this.tokenDisplay.setIcon((FImage)PlaneswalkerAchievements.getTrophyImage(planeswalker.getName(), planeswalker));
            } else {
                this.tokenDisplay.setIcon(null);
            }
        }

        @Override
        protected void onActivate(NewConquestScreenModel model) {
            this.lstPlaneswalkers.setListData(ConquestUtil.getStartingPlaneswalkerOptions(model.startingCommander));
            this.reset();
        }

        @Override
        protected boolean updateModelAndAdvance(NewConquestScreenModel model) {
            model.startingPlaneswalker = this.lstPlaneswalkers.getSelectedItem();
            return model.startingPlaneswalker != null;
        }
    }

    private static class SelectStartingCommanderStep
    extends MultiStepWizardScreen.WizardStep<NewConquestScreenModel> {
        private final FChoiceList<PaperCard> lstCommanders = this.add(new FChoiceList<PaperCard>(((ConquestPlane)FModel.getPlanes().iterator().next()).getCommanders()){

            @Override
            protected void onItemActivate(Integer index, PaperCard value) {
                this.advance();
            }

            @Override
            protected void onSelectionChange() {
                if (cardDisplay == null) {
                    return;
                }
                this.updatePreview();
            }
        });
        private final CardListPreview cardDisplay = this.add(new CardListPreview(this.lstCommanders));

        protected SelectStartingCommanderStep() {
            super(Forge.getLocalizer().getMessage("lblSelectStartingCommander", new Object[0]));
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = PADDING;
            float y = PADDING;
            float w = width - 2.0f * PADDING;
            this.cardDisplay.setBounds(x, y, w, height * 0.5f);
            this.lstCommanders.setBounds(x, y += this.cardDisplay.getHeight() + PADDING, w, height - y - PADDING);
        }

        @Override
        protected void reset() {
            if (this.lstCommanders.getCount() > 0) {
                this.lstCommanders.setSelectedIndex(0);
            }
        }

        private void updatePreview() {
            PaperCard card = this.lstCommanders.getSelectedItem();
            if (card != null) {
                this.cardDisplay.setIcon(new CardImage(card));
            } else {
                this.cardDisplay.setIcon(null);
            }
        }

        @Override
        protected void onActivate(NewConquestScreenModel model) {
            this.lstCommanders.setListData(model.startingPlane.getCommanders());
            this.reset();
        }

        @Override
        protected boolean updateModelAndAdvance(NewConquestScreenModel model) {
            model.startingCommander = this.lstCommanders.getSelectedItem();
            return model.startingCommander != null;
        }
    }

    private static class SelectStartingPlaneStep
    extends MultiStepWizardScreen.WizardStep<NewConquestScreenModel> {
        private final ConquestPlaneSelector planeSelector = this.add(new ConquestPlaneSelector());

        protected SelectStartingPlaneStep() {
            super(Forge.getLocalizer().getMessage("lblSelectStartingPlane", new Object[0]));
        }

        @Override
        protected void doLayout(float width, float height) {
            this.planeSelector.setBounds(0.0f, 0.0f, width, height);
        }

        @Override
        protected void reset() {
            this.planeSelector.reset();
        }

        @Override
        protected void onActivate(NewConquestScreenModel model) {
            this.planeSelector.activate();
        }

        @Override
        protected boolean updateModelAndAdvance(NewConquestScreenModel model) {
            model.startingPlane = this.planeSelector.getSelectedPlane();
            if (model.startingPlane != null) {
                this.planeSelector.deactivate();
                return true;
            }
            return false;
        }
    }
}

