/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.Gdx;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.planarconquest.ConquestController;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.screens.LaunchScreen;
import forge.screens.home.LoadGameMenu;
import forge.screens.home.NewGameMenu;
import forge.screens.planarconquest.ConquestMenu;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FButton;
import forge.toolbox.FList;
import forge.toolbox.FTextArea;
import forge.util.FileUtil;
import forge.util.ThreadUtil;
import forge.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class LoadConquestScreen
extends LaunchScreen {
    private static final float ITEM_HEIGHT = Utils.AVG_FINGER_HEIGHT;
    private static final float PADDING = Utils.AVG_FINGER_HEIGHT * 0.1f;
    private static final FSkinColor OLD_CONQUESTS_BACK_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_INACTIVE).getContrastColor(20);
    private static final FSkinColor SEL_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    private final FTextArea lblOldConquests = this.add(new FTextArea(false, Forge.getLocalizer().getMessage("lblLoadingExistingConquests", new Object[0])));
    private final ConquestFileLister lstConquests = this.add(new ConquestFileLister());
    private final FButton btnNewConquest = this.add(new FButton(Forge.getLocalizer().getMessage("lblNewQuest", new Object[0])));
    private final FButton btnRenameConquest = this.add(new FButton(Forge.getLocalizer().getMessage("lblRename", new Object[0])));
    private final FButton btnDeleteConquest = this.add(new FButton(Forge.getLocalizer().getMessage("lblDelete", new Object[0])));

    public LoadConquestScreen() {
        super(null, LoadGameMenu.getMenu());
        this.lblOldConquests.setFont(FSkinFont.get(12));
        this.lblOldConquests.setAlignment(1);
        this.btnNewConquest.setFont(FSkinFont.get(16));
        this.btnNewConquest.setCommand(e -> NewGameMenu.NewGameScreen.PlanarConquest.open());
        this.btnRenameConquest.setFont(this.btnNewConquest.getFont());
        this.btnRenameConquest.setCommand(e -> this.renameConquest(this.lstConquests.getSelectedConquest()));
        this.btnDeleteConquest.setFont(this.btnNewConquest.getFont());
        this.btnDeleteConquest.setCommand(e -> this.deleteConquest(this.lstConquests.getSelectedConquest()));
    }

    @Override
    public void onActivate() {
        this.lblOldConquests.setText(Forge.getLocalizer().getMessage("lblLoadingExistingConquests", new Object[0]));
        this.lstConquests.clear();
        this.updateEnabledButtons();
        this.revalidate();
        FThreads.invokeInBackgroundThread(() -> {
            File dirConquests = new File(ForgeConstants.CONQUEST_SAVE_DIR);
            ConquestController qc = FModel.getConquest();
            HashMap<String, ConquestData> arrConquests = new HashMap<String, ConquestData>();
            if (dirConquests.listFiles() != null) {
                for (File f : dirConquests.listFiles()) {
                    if (!f.isDirectory()) continue;
                    ConquestData data = new ConquestData(f);
                    arrConquests.put(data.getName(), data);
                }
            }
            this.lstConquests.setConquests(new ArrayList<ConquestData>(arrConquests.values()));
            if (arrConquests.size() > 0) {
                String questname = FModel.getConquestPreferences().getPref(ConquestPreferences.CQPref.CURRENT_CONQUEST);
                ConquestData currentConquest = (ConquestData)arrConquests.get(questname);
                if (currentConquest != null) {
                    this.lstConquests.setSelectedConquest(currentConquest);
                } else {
                    this.lstConquests.setSelectedIndex(0);
                }
                qc.setModel(this.lstConquests.getSelectedConquest());
            } else {
                qc.setModel(null);
            }
            Gdx.app.postRunnable(() -> {
                this.lblOldConquests.setText(Forge.getLocalizer().getMessage("lblOldConquestDataPutIntoDirAndRestartForge", ForgeConstants.CONQUEST_SAVE_DIR));
                this.updateEnabledButtons();
                this.revalidate();
                this.lstConquests.scrollIntoView(this.lstConquests.selectedIndex);
            });
        });
    }

    private void updateEnabledButtons() {
        boolean enabled = this.lstConquests.getSelectedConquest() != null;
        this.btnStart.setEnabled(enabled);
        this.btnRenameConquest.setEnabled(enabled);
        this.btnDeleteConquest.setEnabled(enabled);
    }

    @Override
    protected void drawBackground(Graphics g2) {
        super.drawBackground(g2);
        float y = Forge.isLandscapeMode() ? 0.0f : this.getHeader().getBottom();
        g2.fillRect(OLD_CONQUESTS_BACK_COLOR, 0.0f, y, this.lstConquests.getWidth(), this.lstConquests.getTop() - y);
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        float y = this.lstConquests.getTop();
        g2.drawLine(1.0f, FList.getLineColor(), 0.0f, y, this.lstConquests.getWidth(), y);
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float buttonWidth = (width - 2.0f * PADDING) / 3.0f;
        float buttonHeight = this.btnNewConquest.getAutoSizeBounds().height * 1.2f;
        float y = startY + 2.0f * PADDING;
        this.lblOldConquests.setBounds(0.0f, y, width, this.lblOldConquests.getPreferredHeight(width));
        this.lstConquests.setBounds(0.0f, y += this.lblOldConquests.getHeight() + PADDING, width, height - y - buttonHeight - PADDING);
        float x = 0.0f;
        this.btnNewConquest.setBounds(x, y += this.lstConquests.getHeight() + PADDING, buttonWidth, buttonHeight);
        this.btnRenameConquest.setBounds(x += buttonWidth + PADDING, y, buttonWidth, buttonHeight);
        this.btnDeleteConquest.setBounds(x += buttonWidth + PADDING, y, buttonWidth, buttonHeight);
    }

    private void changeConquest() {
        ConquestData conquest = this.lstConquests.getSelectedConquest();
        if (conquest == null) {
            return;
        }
        FModel.getConquestPreferences().setPref(ConquestPreferences.CQPref.CURRENT_CONQUEST, conquest.getName());
        FModel.getConquestPreferences().save();
        FModel.getConquest().setModel(conquest);
        ConquestMenu.launchPlanarConquest(ConquestMenu.LaunchReason.LoadConquest);
    }

    private void renameConquest(ConquestData conquest) {
        if (conquest == null) {
            return;
        }
        ThreadUtil.invokeInGameThread(() -> {
            String questName;
            String oldConquestName = conquest.getName();
            while (true) {
                if ((questName = SOptionPane.showInputDialog(Forge.getLocalizer().getMessage("lblEnterNewConquestName", new Object[0]), Forge.getLocalizer().getMessage("lblRenameConquest", new Object[0]), null, oldConquestName)) == null) {
                    return;
                }
                if ((questName = QuestUtil.cleanString(questName)).equals(oldConquestName)) {
                    return;
                }
                if (questName.isEmpty()) {
                    SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblPleaseSpecifyConquestName", new Object[0]));
                    continue;
                }
                boolean exists = false;
                for (ConquestData questData : this.lstConquests) {
                    if (!questData.getName().equalsIgnoreCase(questName)) continue;
                    exists = true;
                    break;
                }
                if (!exists) break;
                SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblConquestNameExistsPleasePickAnotherName", new Object[0]));
            }
            ConquestPreferences prefs = FModel.getConquestPreferences();
            if (conquest.getName().equals(prefs.getPref(ConquestPreferences.CQPref.CURRENT_CONQUEST))) {
                prefs.setPref(ConquestPreferences.CQPref.CURRENT_CONQUEST, questName);
                prefs.save();
            }
            conquest.rename(questName);
        });
    }

    private void deleteConquest(ConquestData conquest) {
        if (conquest == null) {
            return;
        }
        ThreadUtil.invokeInGameThread(() -> {
            if (!SOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblAreYouSuerDeleteConquest", conquest.getName()), Forge.getLocalizer().getMessage("lblDeleteConquest", new Object[0]), Forge.getLocalizer().getMessage("lblDelete", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]))) {
                return;
            }
            FThreads.invokeInEdtLater(() -> {
                FileUtil.deleteDirectory(conquest.getDirectory());
                this.lstConquests.removeConquest(conquest);
                this.updateEnabledButtons();
            });
        });
    }

    @Override
    protected void startMatch() {
        this.changeConquest();
    }

    private class ConquestFileLister
    extends FList<ConquestData> {
        private int selectedIndex = 0;

        private ConquestFileLister() {
            this.setListItemRenderer(new FList.ListItemRenderer<ConquestData>(){

                @Override
                public boolean tap(Integer index, ConquestData value, float x, float y, int count) {
                    if (count == 2) {
                        LoadConquestScreen.this.changeConquest();
                    } else {
                        ConquestFileLister.this.selectedIndex = index;
                    }
                    return true;
                }

                @Override
                public float getItemHeight() {
                    return ITEM_HEIGHT;
                }

                @Override
                public void drawValue(Graphics g2, Integer index, ConquestData value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                    float offset = SettingsScreen.getInsets(w) - FList.PADDING;
                    x += offset;
                    y += offset;
                    w -= 2.0f * offset;
                    float totalHeight = h2 -= 2.0f * offset;
                    String name = value.getName();
                    h2 = font.getMultiLineBounds((CharSequence)name).height + SettingsScreen.SETTING_PADDING;
                    String progress = value.getProgress();
                    float winRatioWidth = font.getBounds((CharSequence)progress).width + SettingsScreen.SETTING_PADDING;
                    g2.drawText(name, font, foreColor, x, y, w - winRatioWidth, h2, false, 8, false);
                    g2.drawText(progress, font, foreColor, x, y, w, h2, false, 16, false);
                    y += (h2 += SettingsScreen.SETTING_PADDING);
                    h2 = totalHeight - h2 + SettingsScreen.getInsets(w);
                    float iconSize = h2 + Utils.scale(2.0f);
                    float iconOffset = SettingsScreen.SETTING_PADDING - Utils.scale(2.0f);
                    String cards = String.valueOf(value.getUnlockedCardCount());
                    String shards = String.valueOf(value.getAEtherShards());
                    font = FSkinFont.get(12);
                    float cardsWidth = font.getBounds((CharSequence)cards).width + iconSize + SettingsScreen.SETTING_PADDING;
                    float shardsWidth = font.getBounds((CharSequence)shards).width + iconSize + SettingsScreen.SETTING_PADDING;
                    g2.drawText(value.getPlaneswalker().getName() + " - " + value.getCurrentPlane().getName().replace("_", " "), font, SettingsScreen.DESC_COLOR, x, y, w - shardsWidth - cardsWidth, h2, false, 8, false);
                    g2.drawImage(FSkinImage.SPELLBOOK, x + w - shardsWidth - cardsWidth + iconOffset, y - SettingsScreen.SETTING_PADDING, iconSize, iconSize);
                    g2.drawText(cards, font, SettingsScreen.DESC_COLOR, x + w - shardsWidth - cardsWidth + iconSize + SettingsScreen.SETTING_PADDING, y, w, h2, false, 8, false);
                    g2.drawImage(FSkinImage.AETHER_SHARD, x + w - shardsWidth + iconOffset, y - SettingsScreen.SETTING_PADDING, iconSize, iconSize);
                    g2.drawText(shards, font, SettingsScreen.DESC_COLOR, x + w - shardsWidth + iconSize + SettingsScreen.SETTING_PADDING, y, w, h2, false, 8, false);
                }
            });
        }

        @Override
        protected FSkinColor getItemFillColor(int index) {
            if (index == this.selectedIndex) {
                return SEL_COLOR;
            }
            return null;
        }

        public void setConquests(List<ConquestData> qd0) {
            ArrayList<ConquestData> sorted = new ArrayList<ConquestData>(qd0);
            sorted.sort(Comparator.comparing(x -> x.getName().toLowerCase()));
            this.setListData(sorted);
        }

        public void removeConquest(ConquestData qd) {
            this.removeItem(qd);
            if (this.selectedIndex == this.getCount()) {
                --this.selectedIndex;
            }
            this.revalidate();
        }

        public boolean setSelectedIndex(int i0) {
            if (i0 >= this.getCount()) {
                return false;
            }
            this.selectedIndex = i0;
            return true;
        }

        public ConquestData getSelectedConquest() {
            if (this.selectedIndex == -1) {
                return null;
            }
            return (ConquestData)this.getItemAt(this.selectedIndex);
        }

        public boolean setSelectedConquest(ConquestData qd0) {
            for (int i = 0; i < this.getCount(); ++i) {
                if (this.getItemAt(i) != qd0) continue;
                this.selectedIndex = i;
                return true;
            }
            return false;
        }
    }
}

