/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.IVConquestStats;
import forge.gui.interfaces.IButton;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.planarconquest.ConquestMenu;
import forge.toolbox.FComboBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Utils;

public class ConquestStatsScreen
extends FScreen
implements IVConquestStats {
    private static final float PADDING = Utils.scale(5.0f);
    private final FComboBox<Object> cbPlanes = this.add(new FComboBox());
    private final FScrollPane scroller = this.add(new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float x = 0.0f;
            float y = 0.0f;
            float w = visibleWidth;
            float h2 = ((ConquestStatsScreen)ConquestStatsScreen.this).lblAEtherShards.getAutoSizeBounds().height;
            for (FDisplayObject lbl : this.getChildren()) {
                if (!lbl.isVisible()) continue;
                lbl.setBounds(x, y, w, lbl.getHeight() == 0.0f ? h2 : lbl.getHeight());
                y += lbl.getHeight() + PADDING;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }
    });
    private final FLabel lblAEtherShards = this.scroller.add(new StatLabel(FSkinImage.AETHER_SHARD));
    private final FLabel lblPlaneswalkEmblems = this.scroller.add(new StatLabel(FSkinImage.PW_BADGE_COMMON));
    private final FLabel lblTotalWins = this.scroller.add(new StatLabel(FSkinImage.QUEST_PLUS));
    private final FLabel lblTotalLosses = this.scroller.add(new StatLabel(FSkinImage.QUEST_MINUS));
    private final FLabel lblConqueredEvents = this.scroller.add(new StatLabel(FSkinImage.MULTIVERSE));
    private final FLabel lblUnlockedCards = this.scroller.add(new StatLabel(FSkinImage.SPELLBOOK));
    private final FLabel lblCommanders = this.scroller.add(new StatLabel(FSkinImage.COMMANDER));
    private final FLabel lblPlaneswalkers = this.scroller.add(new StatLabel(FSkinImage.PLANESWALKER));

    public ConquestStatsScreen() {
        super(null, ConquestMenu.getMenu());
        this.cbPlanes.addItem(Forge.getLocalizer().getMessage("lblAllPlanes", new Object[0]));
        for (ConquestPlane plane : FModel.getPlanes()) {
            if (plane.isUnreachable() && !FModel.getConquest().getModel().getCurrentPlane().equals(plane)) continue;
            this.cbPlanes.addItem(plane);
        }
        this.cbPlanes.setAlignment(1);
        this.cbPlanes.setChangedHandler(e -> {
            ConquestPlane plane = this.cbPlanes.getSelectedIndex() > 0 ? (ConquestPlane)this.cbPlanes.getSelectedItem() : null;
            FModel.getConquest().getModel().updateStatLabels(this, plane);
        });
    }

    @Override
    public void onActivate() {
        this.update();
    }

    public void update() {
        ConquestData model = FModel.getConquest().getModel();
        this.setHeaderCaption(model.getName());
        FEvent.FEventHandler handler = this.cbPlanes.getChangedHandler();
        this.cbPlanes.setChangedHandler(null);
        this.cbPlanes.setSelectedItem(model.getCurrentPlane());
        this.cbPlanes.setChangedHandler(handler);
        model.updateStatLabels(this, model.getCurrentPlane());
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        this.cbPlanes.setBounds(x, y, width -= 2.0f * x, this.cbPlanes.getHeight());
        this.scroller.setBounds(x, y += this.cbPlanes.getHeight() + PADDING, width, height - PADDING - y);
    }

    @Override
    public IButton getLblAEtherShards() {
        return this.lblAEtherShards;
    }

    @Override
    public IButton getLblPlaneswalkEmblems() {
        return this.lblPlaneswalkEmblems;
    }

    @Override
    public IButton getLblTotalWins() {
        return this.lblTotalWins;
    }

    @Override
    public IButton getLblTotalLosses() {
        return this.lblTotalLosses;
    }

    @Override
    public IButton getLblConqueredEvents() {
        return this.lblConqueredEvents;
    }

    @Override
    public IButton getLblUnlockedCards() {
        return this.lblUnlockedCards;
    }

    @Override
    public IButton getLblCommanders() {
        return this.lblCommanders;
    }

    @Override
    public IButton getLblPlaneswalkers() {
        return this.lblPlaneswalkers;
    }

    private static class StatLabel
    extends FLabel {
        private StatLabel(FImage icon0) {
            super(new FLabel.Builder().icon(icon0).font(FSkinFont.get(14)).iconScaleFactor(1.0f));
        }
    }
}

