/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.planarconquest.ConquestMenu;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FNumericTextField;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextField;
import forge.util.Utils;

public class ConquestPrefsScreen
extends FScreen {
    private static final float PADDING = Utils.scale(5.0f);
    private FScrollPane scroller = this.add(new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float x = PADDING;
            float y = PADDING;
            float w = visibleWidth - 2.0f * PADDING;
            float fieldHeight = FTextField.getDefaultHeight();
            float dy = fieldHeight + PADDING;
            for (FDisplayObject child : this.getChildren()) {
                if (!child.isVisible()) continue;
                child.setBounds(x, y, w, fieldHeight);
                y += dy;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }
    });

    public ConquestPrefsScreen() {
        super(Forge.getLocalizer().getMessage("lblConquestPreference", new Object[0]), ConquestMenu.getMenu());
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblAetherShards", new Object[0]), FSkinImage.AETHER_SHARD, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBaseDuplicateValue", new Object[0]), ConquestPreferences.CQPref.AETHER_BASE_DUPLICATE_VALUE, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBaseExileValue", new Object[0]), ConquestPreferences.CQPref.AETHER_BASE_EXILE_VALUE, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBaseRetrieveCost", new Object[0]), ConquestPreferences.CQPref.AETHER_BASE_RETRIEVE_COST, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBasePullCost", new Object[0]), ConquestPreferences.CQPref.AETHER_BASE_PULL_COST, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblUncommonMultiplier", new Object[0]), ConquestPreferences.CQPref.AETHER_UNCOMMON_MULTIPLIER, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblRareMultiplier", new Object[0]), ConquestPreferences.CQPref.AETHER_RARE_MULTIPLIER, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblMythicMultiplier", new Object[0]), ConquestPreferences.CQPref.AETHER_MYTHIC_MULTIPLIER, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingShards", new Object[0]), ConquestPreferences.CQPref.AETHER_START_SHARDS, PrefsGroup.AETHER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblChaosWheelShardValue", new Object[0]), ConquestPreferences.CQPref.AETHER_WHEEL_SHARDS, PrefsGroup.AETHER));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblBoosterPacks", new Object[0]), FSkinImage.PACK, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblCommons", new Object[0]), ConquestPreferences.CQPref.BOOSTER_COMMONS, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblUncommons", new Object[0]), ConquestPreferences.CQPref.BOOSTER_UNCOMMONS, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblRares", new Object[0]), ConquestPreferences.CQPref.BOOSTER_RARES, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBoostersPerMythic", new Object[0]), ConquestPreferences.CQPref.BOOSTERS_PER_MYTHIC, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblPlaneswalkEmblems", new Object[0]), FSkinImage.PW_BADGE_COMMON, PrefsGroup.PLANESWALK));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBaseConquerReward", new Object[0]), ConquestPreferences.CQPref.PLANESWALK_CONQUER_EMBLEMS, PrefsGroup.PLANESWALK));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblChaosWheelBonus", new Object[0]), ConquestPreferences.CQPref.PLANESWALK_WHEEL_EMBLEMS, PrefsGroup.PLANESWALK));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblFirstPlaneUnlockCost", new Object[0]), ConquestPreferences.CQPref.PLANESWALK_FIRST_UNLOCK, PrefsGroup.PLANESWALK));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblCostIncreasePerUnlock", new Object[0]), ConquestPreferences.CQPref.PLANESWALK_UNLOCK_INCREASE, PrefsGroup.PLANESWALK));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblChaosBattles", new Object[0]), FSkinImage.CHAOS, PrefsGroup.CHAOS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsforMediumAI", new Object[0]), ConquestPreferences.CQPref.CHAOS_BATTLE_WINS_MEDIUMAI, PrefsGroup.CHAOS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsforHardAI", new Object[0]), ConquestPreferences.CQPref.CHAOS_BATTLE_WINS_HARDAI, PrefsGroup.CHAOS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsforExpertAI", new Object[0]), ConquestPreferences.CQPref.CHAOS_BATTLE_WINS_EXPERTAI, PrefsGroup.CHAOS));
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.scroller.setBounds(0.0f, startY, width, height - startY);
    }

    private static class PrefsOption
    extends FContainer {
        private static final float FIELD_WIDTH = new FTextField("99999").getAutoSizeWidth();
        private final FLabel label = this.add(new FLabel.Builder().build());
        private final OptionField field = this.add(new OptionField());
        private final ConquestPreferences.CQPref pref;
        private final PrefsGroup group;

        private PrefsOption(String label0, ConquestPreferences.CQPref pref0, PrefsGroup group0) {
            this.label.setText(label0);
            this.pref = pref0;
            this.group = group0;
            this.field.setText(FModel.getConquestPreferences().getPref(pref0));
        }

        @Override
        protected void doLayout(float width, float height) {
            this.label.setBounds(0.0f, 0.0f, width - FIELD_WIDTH - PADDING, height);
            this.field.setBounds(width - FIELD_WIDTH, 0.0f, FIELD_WIDTH, height);
        }

        private class OptionField
        extends FNumericTextField {
            private OptionField() {
            }

            @Override
            protected boolean validate() {
                if (super.validate()) {
                    ConquestPreferences prefs = FModel.getConquestPreferences();
                    int val = Integer.parseInt(this.getText());
                    String validationError = prefs.validatePreference(PrefsOption.this.pref, val);
                    if (validationError != null) {
                        String prefType;
                        switch (PrefsOption.this.group) {
                            case BOOSTER: {
                                prefType = "Booster Packs";
                                break;
                            }
                            default: {
                                prefType = "";
                            }
                        }
                        FOptionPane.showErrorDialog(validationError, Forge.getLocalizer().getMessage("lblSaveFailed", new Object[0]) + prefType);
                        return false;
                    }
                    prefs.setPref(PrefsOption.this.pref, this.getText());
                    prefs.save();
                    return true;
                }
                return false;
            }
        }
    }

    private class PrefsHeader
    extends FLabel {
        private PrefsHeader(String title, FImage icon, final PrefsGroup group) {
            super(new FLabel.ButtonBuilder().text(title).font(FSkinFont.get(16)).icon(icon).iconScaleFactor(1.0f).command(new FEvent.FEventHandler(){
                private boolean showOptions = true;

                @Override
                public void handleEvent(FEvent e) {
                    this.showOptions = !this.showOptions;
                    for (FDisplayObject child : ConquestPrefsScreen.this.scroller.getChildren()) {
                        if (!(child instanceof PrefsOption) || ((PrefsOption)child).group != group) continue;
                        child.setVisible(this.showOptions);
                    }
                    ConquestPrefsScreen.this.scroller.revalidate();
                }
            }));
        }
    }

    private static enum PrefsGroup {
        AETHER,
        BOOSTER,
        PLANESWALK,
        CHAOS;

    }
}

