/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import forge.Forge;
import forge.assets.FImage;
import forge.card.CardListPreview;
import forge.deck.FDeckChooser;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.item.PaperCard;
import forge.localinstance.achievements.PlaneswalkerAchievements;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.planarconquest.ConquestMenu;
import forge.toolbox.FChoiceList;
import forge.util.Callback;

public class ConquestPlaneswalkersScreen
extends FScreen {
    private static final float PADDING = FDeckChooser.PADDING;
    private final FChoiceList<PaperCard> lstPlaneswalkers = this.add(new FChoiceList<PaperCard>(((ConquestPlane)FModel.getPlanes().iterator().next()).getCommanders()){

        @Override
        protected void onItemActivate(Integer index, PaperCard value) {
            Forge.back();
        }

        @Override
        protected void onSelectionChange() {
            if (ConquestPlaneswalkersScreen.this.tokenDisplay == null) {
                return;
            }
            ConquestPlaneswalkersScreen.this.updatePreview();
        }
    });
    private final CardListPreview tokenDisplay = this.add(new CardListPreview(this.lstPlaneswalkers));

    public ConquestPlaneswalkersScreen() {
        super("Select Planeswalker", ConquestMenu.getMenu());
    }

    @Override
    public void onActivate() {
        this.refreshPlaneswalkers();
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        if (canCloseCallback == null) {
            return;
        }
        PaperCard planeswalker = this.lstPlaneswalkers.getSelectedItem();
        if (planeswalker == null) {
            canCloseCallback.run(true);
            return;
        }
        ConquestData model = FModel.getConquest().getModel();
        if (model.getPlaneswalker() != planeswalker) {
            model.setPlaneswalker(planeswalker);
            model.saveData();
        }
        canCloseCallback.run(true);
    }

    private void refreshPlaneswalkers() {
        ConquestData model = FModel.getConquest().getModel();
        this.lstPlaneswalkers.setListData(model.getSortedPlaneswalkers());
        this.lstPlaneswalkers.setSelectedItem(model.getPlaneswalker());
    }

    private void updatePreview() {
        PaperCard planeswalker = this.lstPlaneswalkers.getSelectedItem();
        if (planeswalker != null) {
            this.tokenDisplay.setIcon((FImage)PlaneswalkerAchievements.getTrophyImage(planeswalker.getName(), planeswalker));
        } else {
            this.tokenDisplay.setIcon(null);
        }
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        this.tokenDisplay.setBounds(x, y, w, (height - startY) * 0.5f);
        this.lstPlaneswalkers.setBounds(x, y += this.tokenDisplay.getHeight() + PADDING, w, height - y - PADDING);
    }
}

