/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.graphics.Color;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.planarconquest.ConquestAEtherScreen;
import forge.screens.planarconquest.ConquestMenu;
import forge.screens.planarconquest.ConquestPlaneSelector;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FList;

public class ConquestPlaneswalkScreen
extends FScreen {
    private static final float PADDING = FList.PADDING;
    private final ConquestPlaneSelector planeSelector = this.add(new ConquestPlaneSelector(){

        @Override
        protected void onSelectionChange() {
            if (ConquestPlaneswalkScreen.this.btnPlaneswalk == null) {
                return;
            }
            ConquestPlaneswalkScreen.this.btnPlaneswalk.updateCaption();
        }
    });
    private final PlaneswalkButton btnPlaneswalk = this.add(new PlaneswalkButton());

    public ConquestPlaneswalkScreen() {
        super("", ConquestMenu.getMenu());
    }

    @Override
    public void onActivate() {
        ConquestData model = FModel.getConquest().getModel();
        this.setHeaderCaption(model.getName());
        this.planeSelector.updateReachablePlanes();
        this.planeSelector.setCurrentPlane(model.getCurrentPlane());
        this.planeSelector.activate();
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.planeSelector.setBounds(0.0f, startY, width, height - startY);
        float btnMod = Forge.extrawide.equals("extrawide") ? 1.5f : 2.5f;
        float buttonWidth = width * 0.6f;
        float buttonHeight = this.btnPlaneswalk.getFont().getCapHeight() * btnMod;
        this.btnPlaneswalk.setBounds((width - buttonWidth) / 2.0f, height - buttonHeight - PADDING, buttonWidth, buttonHeight);
    }

    private class PlaneswalkButton
    extends FLabel {
        private int unlockCost;

        private PlaneswalkButton() {
            super(new FLabel.Builder().font(FSkinFont.get(20)).parseSymbols().pressedColor(ConquestAEtherScreen.FILTER_BUTTON_PRESSED_COLOR).textColor(ConquestAEtherScreen.FILTER_BUTTON_TEXT_COLOR).alphaComposite(1.0f).align(1));
            this.setCommand((FEvent e) -> {
                ConquestPlane selectedPlane;
                ConquestData model = FModel.getConquest().getModel();
                if (model.isPlaneUnlocked(selectedPlane = ConquestPlaneswalkScreen.this.planeSelector.getSelectedPlane())) {
                    model.planeswalkTo(selectedPlane);
                    model.saveData();
                    Forge.back();
                } else if (model.spendPlaneswalkEmblems(this.unlockCost)) {
                    model.unlockPlane(selectedPlane);
                    model.saveData();
                    this.updateCaption();
                }
            });
        }

        public void updateCaption() {
            ConquestPlane selectedPlane;
            ConquestData model = FModel.getConquest().getModel();
            if (model.isPlaneUnlocked(selectedPlane = ConquestPlaneswalkScreen.this.planeSelector.getSelectedPlane())) {
                this.unlockCost = 0;
                this.setText("Planeswalk");
            } else {
                ConquestPreferences prefs = FModel.getConquestPreferences();
                this.unlockCost = prefs.getPrefInt(ConquestPreferences.CQPref.PLANESWALK_FIRST_UNLOCK) + prefs.getPrefInt(ConquestPreferences.CQPref.PLANESWALK_UNLOCK_INCREASE) * (model.getUnlockedPlaneCount() - 1);
                int emblems = model.getPlaneswalkEmblems();
                String message = "Unlock {PW}";
                message = emblems < this.unlockCost ? message + TextRenderer.startColor(Color.RED) + emblems + TextRenderer.endColor() : message + emblems;
                message = message + "/" + this.unlockCost;
                this.setText(message);
            }
        }

        @Override
        protected void drawContent(Graphics g2, float w, float h2, boolean pressed) {
            if (!pressed) {
                g2.fillRect(ConquestAEtherScreen.FILTER_BUTTON_COLOR, 0.0f, 0.0f, w, h2);
            }
            super.drawContent(g2, w, h2, pressed);
        }
    }
}

