/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.card.CardRenderer;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTimer;
import forge.toolbox.GuiDialog;
import forge.util.Utils;
import forge.util.collect.FCollectionView;
import java.util.List;

public class ConquestPlaneSelector
extends FDisplayObject {
    private static final FSkinFont PLANE_NAME_FONT = FSkinFont.get(30);
    private static final Color BACK_COLOR = FSkinColor.fromRGB(1, 2, 2);
    private static final float MONITOR_TOP_MULTIPLIER = 0.04761905f;
    private static final float MONITOR_BOTTOM_MULTIPLIER = 0.073015876f;
    private static final float MONITOR_LEFT_MULTIPLIER = 0.04288939f;
    private static final float ARROW_THICKNESS = Utils.scale(3.0f);
    private static List<ConquestPlane> planes = ImmutableList.copyOf(Iterables.filter(FModel.getPlanes(), plane -> !plane.isUnreachable()));
    private final FTimer timer = new FTimer(2.5f){

        @Override
        protected void tick() {
            FCollectionView<PaperCard> planeCards = ConquestPlaneSelector.this.getSelectedPlane().getPlaneCards();
            if (++ConquestPlaneSelector.this.artIndex >= planeCards.size()) {
                ConquestPlaneSelector.this.artIndex = 0;
            }
            ConquestPlaneSelector.this.currentArt = CardRenderer.getCardArt(planeCards.get((PaperCard)ConquestPlaneSelector.this.artIndex));
        }
    };
    private int selectedIndex;
    private int artIndex;
    private int currentPlaneIndex = -1;
    private FImage currentArt;
    private Rectangle leftArrowBounds;
    private Rectangle rightArrowBounds;
    private Rectangle currentArtBounds;

    public ConquestPlaneSelector() {
        this.reset();
    }

    public ConquestPlane getSelectedPlane() {
        return planes.get(this.selectedIndex);
    }

    public void setSelectedPlane(ConquestPlane plane0) {
        this.setSelectedIndex(planes.indexOf(plane0));
    }

    public void setCurrentPlane(ConquestPlane plane0) {
        this.currentPlaneIndex = planes.indexOf(plane0);
        this.setSelectedIndex((this.currentPlaneIndex + 1) % planes.size());
    }

    public void activate() {
        this.timer.start();
    }

    public void deactivate() {
        this.timer.stop();
    }

    public void reset() {
        this.setSelectedIndex(0);
        this.timer.stop();
    }

    private void setSelectedIndex(int selectedIndex0) {
        if (this.currentPlaneIndex == selectedIndex0) {
            return;
        }
        this.selectedIndex = selectedIndex0;
        this.artIndex = 0;
        this.currentArt = CardRenderer.getCardArt(this.getSelectedPlane().getPlaneCards().get((PaperCard)this.artIndex));
        this.timer.restart();
        this.onSelectionChange();
    }

    protected void onSelectionChange() {
    }

    private void incrementSelectedIndex(int dir) {
        int newIndex = this.selectedIndex + dir;
        if (newIndex == this.currentPlaneIndex && this.currentPlaneIndex != -1) {
            newIndex += dir;
        }
        if (newIndex < 0) {
            newIndex = planes.size() - 1;
            if (newIndex == this.currentPlaneIndex) {
                --newIndex;
            }
        } else if (newIndex >= planes.size() && (newIndex = 0) == this.currentPlaneIndex) {
            ++newIndex;
        }
        this.setSelectedIndex(newIndex);
    }

    @Override
    public boolean tap(float x, float y, int count) {
        if (this.leftArrowBounds.contains(x, y)) {
            this.incrementSelectedIndex(-1);
            return true;
        }
        if (this.rightArrowBounds.contains(x, y)) {
            this.incrementSelectedIndex(1);
            return true;
        }
        if (this.currentArtBounds != null && this.currentArtBounds.contains(x, y)) {
            ConquestPlane plane = this.getSelectedPlane();
            String desc = plane.getDescription();
            if (!desc.isEmpty()) {
                GuiDialog.message(plane.getDescription().replace("\\n", "\n"), plane.getName().replace("_", " "));
            } else {
                GuiDialog.message(Forge.getLocalizer().getMessage("lblThisPlaneHasNoDesc", new Object[0]), plane.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean fling(float velocityX, float velocityY) {
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            this.incrementSelectedIndex(velocityX > 0.0f ? -1 : 1);
            return true;
        }
        return false;
    }

    @Override
    public void draw(Graphics g2) {
        float hmod = Forge.getHeightModifier();
        float w = this.getWidth();
        float h2 = this.getHeight();
        FSkinTexture background = FSkinTexture.BG_SPACE;
        float backgroundHeight = w * background.getHeight() / background.getWidth();
        g2.fillRect(BACK_COLOR, 0.0f, 0.0f, w, h2);
        g2.drawImage(background, 0.0f, h2 - backgroundHeight, w, backgroundHeight);
        FSkinImage monitor = FSkinImage.PLANE_MONITOR;
        float monitorLeft = FOptionPane.PADDING / 2.0f;
        float monitorWidth = w - 2.0f * monitorLeft;
        float monitorHeight = monitorWidth * monitor.getHeight() / monitor.getWidth() - hmod;
        float monitorLeftOffset = monitorWidth * 0.04288939f;
        float monitorTopOffset = monitorHeight * 0.04761905f;
        float monitorBottomOffset = monitorHeight * 0.073015876f;
        float monitorTop = monitorLeft + monitorLeftOffset - monitorTopOffset;
        if (this.currentArt != null) {
            float x = monitorLeft + monitorLeftOffset - 1.0f;
            float y = monitorTop + monitorTopOffset - 1.0f;
            float artWidth = monitorWidth - 2.0f * monitorLeftOffset + 2.0f;
            float artHeight = monitorHeight - monitorTopOffset - monitorBottomOffset + 2.0f;
            float fullArtWidth = artHeight * this.currentArt.getWidth() / this.currentArt.getHeight();
            float artHeightClipMod = 0.0f;
            if (fullArtWidth < monitorWidth) {
                float scaledArtHeight = monitorWidth * (artHeight / fullArtWidth);
                fullArtWidth = monitorWidth;
                artHeightClipMod = scaledArtHeight - artHeight;
                artHeight = scaledArtHeight;
            }
            g2.startClip(x, y, artWidth, artHeight - artHeightClipMod);
            g2.drawImage(this.currentArt, x + (monitorWidth - fullArtWidth) / 2.0f, y, fullArtWidth, artHeight);
            g2.endClip();
            this.currentArtBounds = new Rectangle(x, y, artWidth, artHeight);
        }
        g2.drawImage(monitor, monitorLeft, monitorTop, monitorWidth, monitorHeight);
        float arrowOffsetLeft = monitorLeft * 2.5f;
        float arrowSize = PLANE_NAME_FONT.getCapHeight();
        float textLeft = arrowSize + 1.5f * arrowOffsetLeft;
        float monitorBottom = monitorTop + monitorHeight;
        float remainingHeight = h2 - monitorBottom;
        ConquestPlane plane = this.getSelectedPlane();
        g2.drawText(plane.getName().replace("_", " "), PLANE_NAME_FONT, Color.WHITE, textLeft, monitorBottom, w - 2.0f * textLeft, remainingHeight, false, 1, true);
        float yMid = monitorBottom + remainingHeight / 2.0f;
        float offsetX = arrowSize / 4.0f;
        float offsetY = arrowSize / 2.0f;
        float midOffsetX = arrowSize * 0.4f;
        float xMid = arrowOffsetLeft + midOffsetX;
        g2.drawLine(ARROW_THICKNESS, Color.WHITE, xMid + offsetX, yMid - offsetY, xMid - offsetX, yMid + 1.0f);
        g2.drawLine(ARROW_THICKNESS, Color.WHITE, xMid - offsetX, yMid - 1.0f, xMid + offsetX, yMid + offsetY);
        this.leftArrowBounds = new Rectangle(0.0f, monitorBottom, textLeft + arrowSize, remainingHeight);
        xMid = w - arrowOffsetLeft - midOffsetX;
        g2.drawLine(ARROW_THICKNESS, Color.WHITE, xMid - offsetX, yMid - offsetY, xMid + offsetX, yMid + 1.0f);
        g2.drawLine(ARROW_THICKNESS, Color.WHITE, xMid + offsetX, yMid - 1.0f, xMid - offsetX, yMid + offsetY);
        this.rightArrowBounds = new Rectangle(w - this.leftArrowBounds.width, monitorBottom, this.leftArrowBounds.width, remainingHeight);
    }

    public void updateReachablePlanes() {
        planes = ImmutableList.copyOf(Iterables.filter(FModel.getPlanes(), plane -> !plane.isUnreachable()));
    }
}

