/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import forge.Forge;
import forge.assets.FSkinImage;
import forge.deck.FDeckEditor;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.HomeScreen;
import forge.screens.home.LoadGameMenu;
import forge.screens.planarconquest.ConquestAEtherScreen;
import forge.screens.planarconquest.ConquestCollectionScreen;
import forge.screens.planarconquest.ConquestCommandersScreen;
import forge.screens.planarconquest.ConquestMultiverseScreen;
import forge.screens.planarconquest.ConquestPlaneswalkScreen;
import forge.screens.planarconquest.ConquestPlaneswalkersScreen;
import forge.screens.planarconquest.ConquestPrefsScreen;
import forge.screens.planarconquest.ConquestStatsScreen;

public class ConquestMenu
extends FPopupMenu {
    private static final ConquestMenu conquestMenu = new ConquestMenu();
    private static final ConquestMultiverseScreen multiverseScreen = new ConquestMultiverseScreen();
    private static final ConquestAEtherScreen aetherScreen = new ConquestAEtherScreen();
    private static final ConquestCommandersScreen commandersScreen = new ConquestCommandersScreen();
    private static final ConquestPlaneswalkersScreen planeswalkersScreen = new ConquestPlaneswalkersScreen();
    private static final ConquestCollectionScreen collectionScreen = new ConquestCollectionScreen();
    private static final ConquestPlaneswalkScreen planeswalkScreen = new ConquestPlaneswalkScreen();
    private static final ConquestStatsScreen statsScreen = new ConquestStatsScreen();
    private static final ConquestPrefsScreen prefsScreen = new ConquestPrefsScreen();
    private static final FMenuItem multiverseItem = new FMenuItem(Forge.getLocalizer().getMessage("lblTheMultiverse", new Object[0]), FSkinImage.MULTIVERSE, event -> ConquestMenu.setCurrentScreen(multiverseScreen));
    private static final FMenuItem aetherItem = new FMenuItem(Forge.getLocalizer().getMessage("lblTheAether", new Object[0]), FSkinImage.AETHER_SHARD, event -> ConquestMenu.setCurrentScreen(aetherScreen));
    private static final FMenuItem commandersItem = new FMenuItem(Forge.getLocalizer().getMessage("lblCommanders", new Object[0]), FSkinImage.COMMANDER, event -> ConquestMenu.setCurrentScreen(commandersScreen));
    private static final FMenuItem planeswalkersItem = new FMenuItem(Forge.getLocalizer().getMessage("lblPlaneswalkers", new Object[0]), FSkinImage.PLANESWALKER, event -> ConquestMenu.setCurrentScreen(planeswalkersScreen));
    private static final FMenuItem collectionItem = new FMenuItem(Forge.getLocalizer().getMessage("lblCollection", new Object[0]), FSkinImage.SPELLBOOK, event -> ConquestMenu.setCurrentScreen(collectionScreen));
    private static final FMenuItem statsItem = new FMenuItem(Forge.getLocalizer().getMessage("lblStatistics", new Object[0]), FSkinImage.MENU_STATS, event -> ConquestMenu.setCurrentScreen(statsScreen));
    private static final FMenuItem planeswalkItem = new FMenuItem(Forge.getLocalizer().getMessage("lblPlaneswalk", new Object[0]), FSkinImage.PW_BADGE_COMMON, event -> ConquestMenu.setCurrentScreen(planeswalkScreen));
    private static final FMenuItem prefsItem = new FMenuItem(Forge.getLocalizer().getMessage("Preferences", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPREFERENCE : FSkinImage.SETTINGS, event -> ConquestMenu.setCurrentScreen(prefsScreen));

    private static void setCurrentScreen(FScreen screen0) {
        Forge.openScreen(screen0, Forge.getCurrentScreen() != multiverseScreen);
    }

    public static ConquestMenu getMenu() {
        return conquestMenu;
    }

    private ConquestMenu() {
    }

    public static void launchPlanarConquest(LaunchReason reason) {
        Forge.lastButtonIndex = 7;
        LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingCurrentConquest", new Object[0]), true, () -> {
            FDeckEditor.EditorType.PlanarConquest.getController().setRootFolder(FModel.getConquest().getDecks());
            if (reason == LaunchReason.StartPlanarConquest) {
                Forge.openScreen(multiverseScreen);
            } else {
                multiverseScreen.update();
                Forge.openScreen(multiverseScreen);
                if (reason == LaunchReason.NewConquest) {
                    LoadGameMenu.LoadGameScreen.PlanarConquest.setAsBackScreen(true);
                }
            }
        });
    }

    public static void selectCommander() {
        Forge.openScreen(commandersScreen);
    }

    @Override
    protected void buildMenu() {
        FScreen currentScreen = Forge.getCurrentScreen();
        this.addItem(multiverseItem);
        multiverseItem.setSelected(currentScreen == multiverseScreen);
        this.addItem(aetherItem);
        aetherItem.setSelected(currentScreen == aetherScreen);
        this.addItem(commandersItem);
        commandersItem.setSelected(currentScreen == commandersScreen);
        this.addItem(planeswalkersItem);
        planeswalkersItem.setSelected(currentScreen == planeswalkersScreen);
        this.addItem(collectionItem);
        collectionItem.setSelected(currentScreen == collectionScreen);
        this.addItem(planeswalkItem);
        planeswalkItem.setSelected(currentScreen == planeswalkScreen);
        this.addItem(statsItem);
        statsItem.setSelected(currentScreen == statsScreen);
        this.addItem(prefsItem);
        prefsItem.setSelected(currentScreen == prefsScreen);
    }

    static {
        if (Forge.isLandscapeMode()) {
            HomeScreen.instance.addButtonForMode("-" + Forge.getLocalizer().getMessage("lblPlanarConquest", new Object[0]), event -> ConquestMenu.launchPlanarConquest(LaunchReason.StartPlanarConquest));
        }
    }

    public static enum LaunchReason {
        StartPlanarConquest,
        LoadConquest,
        NewConquest;

    }
}

