/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinTexture;
import forge.assets.TextRenderer;
import forge.card.CardRarity;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.card.ColorSet;
import forge.card.ColorSetImage;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.planarconquest.ConquestMenu;
import forge.screens.planarconquest.ConquestMultiverseScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.GuiChoose;
import forge.util.Aggregates;
import forge.util.Callback;
import forge.util.MyRandom;
import forge.util.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConquestAEtherScreen
extends FScreen {
    public static final Color FILTER_BUTTON_COLOR = ConquestMultiverseScreen.LOCATION_BAR_COLOR;
    public static final FSkinColor FILTER_BUTTON_TEXT_COLOR = FSkinColor.getStandardColor(ConquestMultiverseScreen.LOCATION_BAR_TEXT_COLOR);
    public static final FSkinColor FILTER_BUTTON_PRESSED_COLOR = FSkinColor.getStandardColor(FSkinColor.alphaColor(Color.WHITE, 0.1f));
    public static final FSkinFont LABEL_FONT = FSkinFont.get(16);
    private static final FSkinFont MESSAGE_FONT = FSkinFont.get(14);
    private static final float PADDING = Utils.scale(5.0f);
    private final AEtherDisplay display = this.add(new AEtherDisplay());
    private final Set<PaperCard> pool = new HashSet<PaperCard>();
    private final Set<PaperCard> filteredPool = new HashSet<PaperCard>();
    private final Set<PaperCard> strictPool = new HashSet<PaperCard>();
    private final FilterButton btnColorFilter = this.add(new FilterButton(Forge.getLocalizer().getMessage("lblColor", new Object[0]), ConquestUtil.COLOR_FILTERS));
    private final FilterButton btnTypeFilter = this.add(new FilterButton(Forge.getLocalizer().getMessage("lblType", new Object[0]), ConquestUtil.TYPE_FILTERS));
    private final FilterButton btnRarityFilter = this.add(new FilterButton(Forge.getLocalizer().getMessage("lblRarity", new Object[0]), ConquestUtil.RARITY_FILTERS));
    private final FilterButton btnCMCFilter = this.add(new FilterButton(Forge.getLocalizer().getMessage("lblCMC", new Object[0]), ConquestUtil.CMC_FILTERS));
    private final FLabel lblShards = this.add(new FLabel.Builder().font(LABEL_FONT).align(1).parseSymbols().build());
    private PullAnimation activePullAnimation;
    private int shardCost;
    private ConquestCommander commander;

    public ConquestAEtherScreen() {
        super("", ConquestMenu.getMenu());
    }

    @Override
    public void onActivate() {
        ConquestData model = FModel.getConquest().getModel();
        ConquestPlane plane = model.getCurrentPlane();
        this.setHeaderCaption(model.getName());
        ConquestCommander commander0 = model.getSelectedCommander();
        if (this.commander != commander0) {
            this.commander = commander0;
            this.resetFilters();
        }
        this.pool.clear();
        for (PaperCard card : plane.getCardPool().getAllCards()) {
            if (model.hasUnlockedCard(card) || card.getRules().getType().isBasicLand()) continue;
            this.pool.add(card);
        }
        this.updateFilteredPool();
        this.updateAvailableShards();
    }

    private void resetFilters() {
        this.btnColorFilter.setSelectedOption(ConquestUtil.getColorFilter(this.commander.getCard().getRules().getColorIdentity()));
        this.btnTypeFilter.setSelectedOption(ConquestUtil.AEtherFilter.CREATURE);
        this.btnRarityFilter.setSelectedOption(ConquestUtil.AEtherFilter.COMMON);
        this.btnCMCFilter.setSelectedOption(ConquestUtil.AEtherFilter.CMC_LOW_MID);
    }

    private void updateFilteredPool() {
        Predicate predicate = this.btnColorFilter.buildFilterPredicate(null);
        predicate = this.btnTypeFilter.buildFilterPredicate(predicate);
        predicate = this.btnRarityFilter.buildFilterPredicate(predicate);
        predicate = this.btnCMCFilter.buildFilterPredicate(predicate);
        CardRarity selectedRarity = this.btnRarityFilter.selectedOption.getRarity();
        this.filteredPool.clear();
        this.strictPool.clear();
        for (PaperCard card : this.pool) {
            if (predicate != null && !predicate.apply(card)) continue;
            this.filteredPool.add(card);
            if (selectedRarity != card.getRarity()) continue;
            this.strictPool.add(card);
        }
        this.updateShardCost();
    }

    private void updateAvailableShards() {
        int availableShards = FModel.getConquest().getModel().getAEtherShards();
        this.lblShards.setText(Forge.getLocalizer().getMessage("lblShardsAE", "{AE}") + availableShards);
    }

    private void updateShardCost() {
        this.shardCost = this.filteredPool.isEmpty() ? 0 : ConquestUtil.getShardValue(this.btnRarityFilter.selectedOption.getRarity(), ConquestPreferences.CQPref.AETHER_BASE_PULL_COST);
        this.display.updateMessage();
    }

    private void pullFromTheAEther() {
        PaperCard card;
        CardRarity allowedRarity;
        Iterable<PaperCard> rewardPool;
        if (this.filteredPool.isEmpty() || this.strictPool.isEmpty()) {
            return;
        }
        ConquestData model = FModel.getConquest().getModel();
        if (model.getAEtherShards() < this.shardCost) {
            return;
        }
        CardRarity minRarity = this.btnRarityFilter.selectedOption.getRarity();
        CardRarity rarity = this.btnRarityFilter.selectedOption.getRarity(MyRandom.getRandom().nextDouble());
        block5: while (Iterables.isEmpty(rewardPool = Iterables.filter(this.filteredPool, arg_0 -> ConquestAEtherScreen.lambda$pullFromTheAEther$0(allowedRarity = rarity, arg_0)))) {
            if (rarity == minRarity) {
                return;
            }
            switch (rarity) {
                case MythicRare: {
                    rarity = CardRarity.Rare;
                    continue block5;
                }
                case Rare: {
                    rarity = CardRarity.Uncommon;
                    continue block5;
                }
                case Uncommon: {
                    rarity = CardRarity.Common;
                    continue block5;
                }
            }
        }
        if ((card = Aggregates.random(rewardPool)) == null) {
            return;
        }
        this.pool.remove(card);
        this.filteredPool.remove(card);
        this.strictPool.remove(card);
        this.activePullAnimation = new PullAnimation(card);
        this.activePullAnimation.start();
        model.spendAEtherShards(this.shardCost);
        model.unlockCard(card);
        model.saveData();
        this.updateShardCost();
        this.updateAvailableShards();
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.display.setBounds(0.0f, startY, width, height - startY);
        float buttonSize = width * 0.15f;
        this.btnColorFilter.setBounds(PADDING, startY + PADDING, buttonSize, buttonSize);
        this.btnTypeFilter.setBounds(width - buttonSize - PADDING, startY + PADDING, buttonSize, buttonSize);
        this.btnRarityFilter.setBounds(PADDING, height - buttonSize - PADDING, buttonSize, buttonSize);
        this.btnCMCFilter.setBounds(width - buttonSize - PADDING, height - buttonSize - PADDING, buttonSize, buttonSize);
        float x = this.btnRarityFilter.getRight() + PADDING;
        float labelWidth = this.btnCMCFilter.getLeft() - PADDING - x;
        this.lblShards.setBounds(x, this.btnRarityFilter.getTop(), labelWidth, this.btnRarityFilter.getHeight());
    }

    private static /* synthetic */ boolean lambda$pullFromTheAEther$0(CardRarity allowedRarity, PaperCard card) {
        return allowedRarity == card.getRarity() || allowedRarity == CardRarity.Rare && card.getRarity() == CardRarity.Special;
    }

    private class FilterButton
    extends FLabel {
        private final String caption;
        private final List<ConquestUtil.AEtherFilter> options;
        private ConquestUtil.AEtherFilter selectedOption;

        private FilterButton(String caption0, ConquestUtil.AEtherFilter[] options0) {
            super(new FLabel.Builder().iconInBackground().pressedColor(FILTER_BUTTON_PRESSED_COLOR).textColor(FILTER_BUTTON_TEXT_COLOR).alphaComposite(1.0f).align(1));
            this.caption = caption0;
            this.options = ImmutableList.copyOf(options0);
            this.setSelectedOption(this.options.get(0));
            this.setCommand((FEvent e) -> GuiChoose.getChoices(Forge.getLocalizer().getMessage("lblSelectCaptionFilter", this.caption), 0, 1, this.options, this.selectedOption, null, new Callback<List<ConquestUtil.AEtherFilter>>(){

                @Override
                public void run(List<ConquestUtil.AEtherFilter> result) {
                    if (!result.isEmpty()) {
                        FilterButton.this.setSelectedOption(result.get(0));
                        ConquestAEtherScreen.this.updateFilteredPool();
                    }
                }
            }));
        }

        private void setSelectedOption(ConquestUtil.AEtherFilter selectedOption0) {
            if (this.selectedOption == selectedOption0) {
                return;
            }
            this.selectedOption = selectedOption0;
            FSkinProp skinProp = this.selectedOption.getSkinProp();
            if (skinProp != null) {
                this.setIcon(FSkin.getImages().get((Object)skinProp));
            } else {
                ColorSet color = this.selectedOption.getColor();
                if (color != null) {
                    this.setIcon(new ColorSetImage(color));
                } else {
                    System.out.println("No icon for filter " + this.selectedOption.name());
                    this.setIcon(null);
                }
            }
        }

        private Predicate<PaperCard> buildFilterPredicate(Predicate<PaperCard> predicate) {
            if (predicate == null) {
                return this.selectedOption.getPredicate();
            }
            return Predicates.and(predicate, this.selectedOption.getPredicate());
        }

        @Override
        protected void drawContent(Graphics g2, float w, float h2, boolean pressed) {
            if (!pressed) {
                g2.fillRect(FILTER_BUTTON_COLOR, 0.0f, 0.0f, w, h2);
            }
            super.drawContent(g2, w, h2, pressed);
        }
    }

    private class PullAnimation
    extends ForgeAnimation {
        private static final float DURATION = 0.6f;
        private final PaperCard card;
        private final Rectangle start;
        private final Rectangle end;
        private float progress = 0.0f;
        private boolean finished;

        private PullAnimation(PaperCard card0) {
            this.card = card0;
            float displayWidth = ConquestAEtherScreen.this.display.getWidth();
            float displayHeight = ConquestAEtherScreen.this.display.getHeight();
            float startHeight = displayHeight * 0.05f;
            float startWidth = startHeight / 1.4f;
            float endHeight = displayHeight - 2.0f * ConquestAEtherScreen.this.btnColorFilter.getHeight() - 4.0f * PADDING;
            float endWidth = endHeight / 1.4f;
            this.start = new Rectangle((displayWidth - startWidth) / 2.0f, (displayHeight - startHeight) / 2.0f, startWidth, startHeight);
            this.end = new Rectangle((displayWidth - endWidth) / 2.0f, (displayHeight - endHeight) / 2.0f, endWidth, endHeight);
        }

        private void drawCard(Graphics g2) {
            float percentage = this.progress / 0.6f;
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            Rectangle pos = Utils.getTransitionPosition(this.start, this.end, percentage);
            CardRenderer.drawCard(g2, this.card, pos.x, pos.y, pos.width, pos.height, CardRenderer.CardStackPosition.Top);
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < 0.6f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            this.finished = true;
        }
    }

    private class AEtherDisplay
    extends FDisplayObject {
        private final TextRenderer textRenderer = new TextRenderer();
        private String message;

        private AEtherDisplay() {
        }

        private void updateMessage() {
            this.message = Forge.getLocalizer().getMessage("lblTapToPullFromAE", "{AE}");
            this.message = ConquestAEtherScreen.this.shardCost == 0 ? this.message + "--" : (FModel.getConquest().getModel().getAEtherShards() < ConquestAEtherScreen.this.shardCost ? this.message + TextRenderer.startColor(Color.RED) + ConquestAEtherScreen.this.shardCost + TextRenderer.endColor() : this.message + ConquestAEtherScreen.this.shardCost);
            this.message = this.message + " (";
            this.message = ConquestAEtherScreen.this.strictPool.isEmpty() ? this.message + TextRenderer.startColor(Color.RED) + "0" + TextRenderer.endColor() : this.message + ConquestAEtherScreen.this.strictPool.size();
            this.message = this.message + " [";
            this.message = ConquestAEtherScreen.this.filteredPool.isEmpty() ? this.message + TextRenderer.startColor(Color.RED) + "0" + TextRenderer.endColor() : this.message + ConquestAEtherScreen.this.filteredPool.size();
            this.message = this.message + "] / " + ConquestAEtherScreen.this.pool.size() + ")";
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            FSkinTexture background = FSkinTexture.BG_SPACE;
            float backgroundHeight = w * background.getHeight() / background.getWidth();
            if (backgroundHeight < h2 / 2.0f) {
                g2.fillRect(Color.BLACK, 0.0f, 0.0f, w, h2);
            }
            background.draw(g2, 0.0f, h2 - backgroundHeight, w, backgroundHeight);
            g2.startClip(0.0f, 0.0f, w, h2 / 2.0f);
            background.drawFlipped(g2, 0.0f, 0.0f, w, backgroundHeight);
            g2.endClip();
            if (ConquestAEtherScreen.this.activePullAnimation != null) {
                ConquestAEtherScreen.this.activePullAnimation.drawCard(g2);
            } else {
                this.textRenderer.drawText(g2, this.message, MESSAGE_FONT, Color.WHITE, 0.0f, 0.0f, w, h2, 0.0f, h2, false, 1, true);
            }
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (y < ConquestAEtherScreen.this.btnColorFilter.getBottom() + PADDING || y > ConquestAEtherScreen.this.btnCMCFilter.getTop() - PADDING) {
                return false;
            }
            if (ConquestAEtherScreen.this.activePullAnimation != null) {
                if (ConquestAEtherScreen.this.activePullAnimation.finished) {
                    ConquestAEtherScreen.this.activePullAnimation = null;
                    return true;
                }
                return false;
            }
            ConquestAEtherScreen.this.pullFromTheAEther();
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            if (y < ConquestAEtherScreen.this.btnColorFilter.getBottom() + PADDING || y > ConquestAEtherScreen.this.btnCMCFilter.getTop() - PADDING) {
                return false;
            }
            if (ConquestAEtherScreen.this.activePullAnimation != null && ConquestAEtherScreen.this.activePullAnimation.finished) {
                CardZoom.show(ConquestAEtherScreen.this.activePullAnimation.card);
                return true;
            }
            return false;
        }
    }
}

