/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.online;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinImage;
import forge.gamemodes.net.server.FServerManager;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.online.OnlineChatScreen;
import forge.screens.online.OnlineLobbyScreen;
import forge.toolbox.FOptionPane;
import forge.util.Callback;

public class OnlineMenu
extends FPopupMenu {
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static final OnlineMenu menu = new OnlineMenu();
    private static OnlineScreen preferredScreen;

    public static OnlineScreen getPreferredScreen() {
        return preferredScreen;
    }

    public static void setPreferredScreen(OnlineScreen preferredScreen0) {
        if (preferredScreen == preferredScreen0) {
            return;
        }
        preferredScreen = preferredScreen0;
        prefs.setPref(ForgePreferences.FPref.PLAY_ONLINE_SCREEN, preferredScreen.name());
        prefs.save();
    }

    public static OnlineMenu getMenu() {
        return menu;
    }

    private OnlineMenu() {
    }

    @Override
    protected void buildMenu() {
        FScreen currentScreen = Forge.getCurrentScreen();
        for (OnlineScreen ngs : OnlineScreen.values()) {
            this.addItem(ngs.item);
            ngs.item.setSelected(currentScreen == ngs.screen);
        }
    }

    static {
        try {
            preferredScreen = OnlineScreen.valueOf(prefs.getPref(ForgePreferences.FPref.PLAY_ONLINE_SCREEN));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            preferredScreen = OnlineScreen.Lobby;
            prefs.setPref(ForgePreferences.FPref.PLAY_ONLINE_SCREEN, preferredScreen.name());
            prefs.save();
        }
    }

    public static enum OnlineScreen {
        Lobby("lblLobby", FSkinImage.FAVICON, OnlineLobbyScreen.class),
        Chat("lblChat", FSkinImage.QUEST_NOTES, OnlineChatScreen.class),
        Disconnect("lblDisconnect", FSkinImage.DELETE, null);

        private final FMenuItem item;
        private final Class<? extends FScreen> screenClass;
        private FScreen screen;

        private OnlineScreen(String caption0, FImage icon0, Class<? extends FScreen> screenClass0) {
            this.screenClass = screenClass0;
            this.item = new FMenuItem(Forge.getLocalizer().getMessage(caption0, new Object[0]), icon0, e -> {
                if (this.screenClass == null) {
                    FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblLeaveLobbyDescription", new Object[0]), Forge.getLocalizer().getMessage("lblDisconnect", new Object[0]), new Callback<Boolean>(){

                        @Override
                        public void run(Boolean result) {
                            if (result.booleanValue()) {
                                if (FServerManager.getInstance() != null && FServerManager.getInstance().isHosting()) {
                                    FServerManager.getInstance().unsetReady();
                                    FServerManager.getInstance().stopServer();
                                }
                                if (OnlineLobbyScreen.getfGameClient() != null) {
                                    OnlineLobbyScreen.closeClient();
                                }
                                Forge.back();
                                screen = null;
                                OnlineLobbyScreen.clearGameLobby();
                            }
                        }
                    });
                    return;
                }
                Forge.back();
                this.open();
                OnlineMenu.setPreferredScreen(this);
            });
        }

        private void initializeScreen() {
            if (this.screen == null) {
                try {
                    this.screen = this.screenClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.screen.setHeaderCaption(Forge.getLocalizer().getMessage("lblPlayOnline", new Object[0]) + " - " + this.item.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            this.update();
        }

        public void open() {
            this.initializeScreen();
            Forge.openScreen(this.screen);
        }

        public void setAsBackScreen(boolean replace) {
            this.initializeScreen();
            Forge.setBackScreen(this.screen, replace);
        }

        public FScreen getScreen() {
            this.initializeScreen();
            return this.screen;
        }

        public void update() {
            for (OnlineScreen ngs : OnlineScreen.values()) {
                if (ngs.ordinal() != 2) continue;
                if (OnlineLobbyScreen.getGameLobby() == null) {
                    ngs.item.setEnabled(false);
                    continue;
                }
                ngs.item.setEnabled(true);
            }
        }
    }
}

