/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.online;

import com.badlogic.gdx.Gdx;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.gamemodes.net.ChatMessage;
import forge.gamemodes.net.IOnlineChatInterface;
import forge.gamemodes.net.IRemote;
import forge.gamemodes.net.event.MessageEvent;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.online.OnlineMenu;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextField;
import forge.util.Utils;

public class OnlineChatScreen
extends FScreen
implements IOnlineChatInterface {
    private static final float PADDING = Utils.scale(5.0f);
    private IRemote gameClient;
    private final ForgePreferences prefs = FModel.getPreferences();
    private final ChatLog lstLog = this.add(new ChatLog());
    private final FTextField txtSendMessage = this.add(new FTextField());

    public OnlineChatScreen() {
        super(null, OnlineMenu.getMenu());
        this.txtSendMessage.setGhostText(Forge.getLocalizer().getMessage("lblEnterMessageToSend", new Object[0]));
        this.txtSendMessage.setChangedHandler(e -> this.sendMessage());
    }

    private void sendMessage() {
        String message = this.txtSendMessage.getText();
        if (message.isEmpty()) {
            return;
        }
        this.txtSendMessage.setText("");
        if (this.gameClient != null) {
            String source = this.prefs.getPref(ForgePreferences.FPref.PLAYER_NAME);
            this.gameClient.send(new MessageEvent(source, message));
        }
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        float h2 = height - y - this.txtSendMessage.getHeight() - 2.0f * PADDING;
        this.lstLog.setBounds(x, y, w, h2);
        this.txtSendMessage.setBounds(x, y += h2 + PADDING, w, this.txtSendMessage.getHeight());
    }

    @Override
    public void setGameClient(IRemote gameClient0) {
        this.gameClient = gameClient0;
    }

    @Override
    public void addMessage(ChatMessage message) {
        this.lstLog.addMessage(message);
        Gdx.graphics.requestRendering();
    }

    private static class ChatMessageBubble
    extends FDisplayObject {
        private static final FSkinFont FONT = FSkinFont.get(12);
        private static final FSkinColor LOCAL_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_ZEBRA);
        private static final FSkinColor REMOTE_COLOR = LOCAL_COLOR.getContrastColor(-20);
        private static final FSkinColor MESSAGE_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        private static final FSkinColor SOURCE_COLOR = MESSAGE_COLOR.alphaColor(0.75f);
        private static final FSkinColor TIMESTAMP_COLOR = MESSAGE_COLOR.alphaColor(0.5f);
        private static final FSkinColor BORDER_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_BORDERS).alphaColor(0.5f);
        private static final float BORDER_THICKNESS = Utils.scale(1.5f);
        private static final float TEXT_INSET = Utils.scale(5.0f);
        private static final float TRIANGLE_WIDTH = Utils.scale(8.0f);
        private final ChatMessage message;
        private final boolean isLocal;
        private final String header;
        private final TextRenderer textRenderer = new TextRenderer();

        private ChatMessageBubble(ChatMessage message0) {
            this.message = message0;
            this.isLocal = this.message.isLocal();
            this.header = this.isLocal || this.message.getSource() == null ? null : this.message.getSource() + ":";
        }

        public float getPreferredHeight(float width) {
            float height = FONT.getCapHeight() + 4.0f * TEXT_INSET + 2.0f * BORDER_THICKNESS;
            if (this.header != null) {
                height += FONT.getLineHeight();
            }
            return height += this.textRenderer.getWrappedBounds((String)this.message.getMessage(), (FSkinFont)ChatMessageBubble.FONT, (float)(width - 2.0f * ChatMessageBubble.TEXT_INSET)).height;
        }

        @Override
        public void draw(Graphics g2) {
            float x2;
            float x1;
            float x = this.isLocal ? 0.0f : TRIANGLE_WIDTH;
            float y = TEXT_INSET;
            float w = this.getWidth() - TRIANGLE_WIDTH;
            float h2 = this.getHeight() - TEXT_INSET;
            FSkinColor color = this.isLocal ? LOCAL_COLOR : REMOTE_COLOR;
            int horzAlignment = this.isLocal ? 16 : 8;
            float timestampHeight = FONT.getCapHeight();
            g2.fillRect(color, x, y, w, h2);
            g2.drawRect(BORDER_THICKNESS, BORDER_COLOR, x, y, w, h2);
            if (this.isLocal) {
                x1 = w - 1.0f;
                x2 = w + TRIANGLE_WIDTH;
            } else {
                x1 = TRIANGLE_WIDTH + 1.0f;
                x2 = 0.0f;
            }
            float x3 = x1;
            float y1 = y + timestampHeight + TEXT_INSET;
            float y3 = y1 + TRIANGLE_WIDTH * 1.25f;
            float y2 = (y1 + y3) / 2.0f;
            g2.fillTriangle(color, x1, y1, x2, y2, x3, y3);
            g2.drawLine(BORDER_THICKNESS, BORDER_COLOR, x1, y1, x2, y2);
            g2.drawLine(BORDER_THICKNESS, BORDER_COLOR, x2, y2, x3, y3);
            x += TEXT_INSET;
            y += TEXT_INSET;
            w -= 2.0f * TEXT_INSET;
            if (!this.isLocal && this.message.getSource() != null) {
                float sourceHeight = FONT.getLineHeight();
                g2.drawText(this.message.getSource() + ":", FONT, SOURCE_COLOR, x, y, w, sourceHeight, false, horzAlignment, true);
                y += sourceHeight;
            }
            g2.drawText(this.message.getTimestamp(), FONT, TIMESTAMP_COLOR, x, h2 - timestampHeight, w, timestampHeight, false, horzAlignment, true);
            this.textRenderer.drawText(g2, this.message.getMessage(), FONT, MESSAGE_COLOR, x, y, w, h2 -= y + timestampHeight + TEXT_INSET, y, h2, true, horzAlignment, true);
        }
    }

    private static class ChatLog
    extends FScrollPane {
        private ChatLog() {
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float x = 0.0f;
            float y = 0.0f;
            float inset = 6.0f * PADDING;
            float bubbleWidth = visibleWidth - inset;
            for (FDisplayObject obj : this.getChildren()) {
                ChatMessageBubble bubble = (ChatMessageBubble)obj;
                if (bubble.isLocal) {
                    bubble.setBounds(x + inset, y, bubbleWidth, bubble.getPreferredHeight(bubbleWidth));
                } else {
                    bubble.setBounds(x, y, bubbleWidth, bubble.getPreferredHeight(bubbleWidth));
                }
                y += bubble.getHeight() + PADDING;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }

        private void addMessage(ChatMessage message) {
            this.add(new ChatMessageBubble(message));
            this.revalidate();
            this.scrollToBottom();
        }
    }
}

