/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.winlose;

import forge.Forge;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.game.GameView;
import forge.gui.FThreads;
import forge.gui.interfaces.IWinLoseView;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.menu.FMagnifyView;
import forge.model.FModel;
import forge.screens.match.winlose.AdventureWinLose;
import forge.screens.match.winlose.ConquestWinLose;
import forge.screens.match.winlose.ControlWinLose;
import forge.screens.match.winlose.GauntletWinLose;
import forge.screens.match.winlose.LimitedWinLose;
import forge.screens.match.winlose.QuestDraftWinLose;
import forge.screens.match.winlose.QuestWinLose;
import forge.toolbox.FButton;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FTextArea;
import forge.util.Utils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ViewWinLose
extends FOverlay
implements IWinLoseView<FButton> {
    private static final float INSETS_FACTOR = 0.025f;
    private static final float GAP_Y_FACTOR = 0.02f;
    private final FButton btnContinue;
    private final FButton btnRestart;
    private final FButton btnQuit;
    private final FLabel lblTitle;
    private final FLabel lblLog;
    private final FLabel lblStats;
    private final FLabel btnCopyLog;
    private final FLabel btnShowBattlefield;
    private final FTextArea txtLog;
    private final OutcomesPanel pnlOutcomes;
    private final GameView game;

    public ViewWinLose(GameView game0) {
        super(FSkinColor.get(FSkinColor.Colors.CLR_OVERLAY).alphaColor(0.75f));
        this.game = game0;
        this.lblTitle = this.add(new FLabel.Builder().font(FSkinFont.get(30)).align(1).build());
        this.lblStats = this.add(new FLabel.Builder().font(FSkinFont.get(26)).align(1).build());
        this.pnlOutcomes = this.add(new OutcomesPanel());
        this.btnContinue = this.add(new FButton());
        this.btnRestart = this.add(new FButton());
        this.btnQuit = this.add(new FButton());
        this.btnContinue.setText(Forge.getLocalizer().getMessage("btnNextGame", new Object[0]));
        this.btnContinue.setFont(FSkinFont.get(22));
        this.btnRestart.setText(Forge.getLocalizer().getMessage("btnStartNewMatch", new Object[0]));
        this.btnRestart.setFont(this.btnContinue.getFont());
        this.btnQuit.setText(Forge.getLocalizer().getMessage("btnQuitMatch", new Object[0]));
        this.btnQuit.setFont(this.btnContinue.getFont());
        this.btnContinue.setEnabled(!game0.isMatchOver());
        this.lblLog = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblGameLog", new Object[0])).align(1).font(FSkinFont.get(18)).build());
        this.txtLog = this.add(new FTextArea(true, StringUtils.join(this.game.getGameLog().getLogEntries(null), "\r\n").replace("[COMPUTER]", "[AI]")){

            @Override
            public boolean tap(float x, float y, int count) {
                if (ViewWinLose.this.txtLog.getMaxScrollTop() > 0.0f) {
                    FMagnifyView.show(ViewWinLose.this.txtLog, ViewWinLose.this.txtLog.getText(), ViewWinLose.this.txtLog.getTextColor(), ViewWinLose.this.getBackColor(), ViewWinLose.this.txtLog.getFont(), true);
                }
                return true;
            }
        });
        this.txtLog.setFont(FSkinFont.get(12));
        this.btnCopyLog = this.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("btnCopyToClipboard", new Object[0])).selectable().command(e -> Forge.getClipboard().setContents(this.txtLog.getText())).build());
        this.btnShowBattlefield = this.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblShowBattlefield", new Object[0])).font(FSkinFont.get(12)).selectable().command(e -> this.hide()).build());
        this.lblTitle.setText(this.composeTitle(game0));
        ControlWinLose control = null;
        switch (game0.getGameType()) {
            case Quest: {
                control = new QuestWinLose(this, game0);
                break;
            }
            case QuestDraft: {
                control = new QuestDraftWinLose(this, game0);
                break;
            }
            case PlanarConquest: {
                control = new ConquestWinLose(this, game0);
                break;
            }
            case Adventure: 
            case AdventureEvent: {
                control = new AdventureWinLose(this, game0);
                break;
            }
            case Draft: {
                if (!FModel.getGauntletMini().isGauntletDraft()) break;
            }
            case Sealed: {
                control = new LimitedWinLose(this, game0);
                break;
            }
            case Gauntlet: 
            case CommanderGauntlet: 
            case DeckManager: {
                control = new GauntletWinLose(this, game0);
                break;
            }
        }
        if (control == null) {
            control = new ControlWinLose(this, game0);
        }
        this.showGameOutcomeSummary();
        this.showPlayerScores();
        ((ControlWinLose)control).showRewards();
    }

    private String composeTitle(GameView game) {
        String winner = game.getWinningPlayerName();
        int winningTeam = game.getWinningTeam();
        if (winner == null) {
            return Forge.getLocalizer().getMessage("lblItsADraw", new Object[0]);
        }
        if (winningTeam != -1) {
            return Forge.getLocalizer().getMessage("lblTeamWon", new Object[0]).replace("%s", String.valueOf(winningTeam));
        }
        return Forge.getLocalizer().getMessage("lblWinnerWon", new Object[0]).replace("%s", winner);
    }

    @Override
    public FButton getBtnContinue() {
        return this.btnContinue;
    }

    @Override
    public FButton getBtnRestart() {
        return this.btnRestart;
    }

    @Override
    public FButton getBtnQuit() {
        return this.btnQuit;
    }

    public FLabel getLabelShowBattlefield() {
        return this.btnShowBattlefield;
    }

    private void showGameOutcomeSummary() {
        for (GameLogEntry o : this.game.getGameLog().getLogEntriesExact(GameLogEntryType.GAME_OUTCOME)) {
            this.pnlOutcomes.add(new FLabel.Builder().text(o.message).font(FSkinFont.get(14)).build());
        }
    }

    private void showPlayerScores() {
        for (GameLogEntry o : this.game.getGameLog().getLogEntriesExact(GameLogEntryType.MATCH_RESULTS)) {
            this.lblStats.setText(this.removePlayerTypeFromLogMessage(o.message));
        }
    }

    private String removePlayerTypeFromLogMessage(String message) {
        return message.replaceAll("\\[[^\\]]*\\]", "");
    }

    @Override
    protected void doLayout(float width, float height) {
        float x;
        float y = x = width * 0.025f;
        if (Forge.isLandscapeMode()) {
            x += width * 0.25f;
        }
        float w = width - 2.0f * x;
        float dy = height * 0.02f;
        float h2 = height / 10.0f;
        this.lblTitle.setBounds(x, y, w, h2);
        y += h2 + dy;
        h2 = OutcomesPanel.LBL_HEIGHT * (float)this.pnlOutcomes.getChildCount();
        this.pnlOutcomes.setBounds(x, y, w, h2);
        y += h2 + dy;
        h2 = height / 10.0f;
        this.lblStats.setBounds(x, y, w, h2);
        y += h2 + dy;
        h2 = height / 12.0f;
        if (Forge.isMobileAdventureMode) {
            if (this.game.getNumGamesInMatch() > 1) {
                this.btnContinue.setBounds(x, y, w, h2);
                y += h2 + dy;
            } else {
                this.btnContinue.setVisible(false);
            }
            this.btnQuit.setBounds(x, y, w, h2);
            y += h2 + dy;
            this.btnRestart.setVisible(false);
        } else {
            if (this.btnContinue.isEnabled()) {
                this.btnContinue.setBounds(x, y, w, h2);
                y += h2 + dy;
            } else {
                this.btnContinue.setBounds(-w, -w, 0.0f, 0.0f);
            }
            if (this.btnRestart.isEnabled()) {
                this.btnRestart.setBounds(x, y, w, h2);
                y += h2 + dy;
            } else {
                this.btnRestart.setBounds(-w, -w, 0.0f, 0.0f);
            }
            if (this.btnQuit.isEnabled()) {
                this.btnQuit.setBounds(x, y, w, h2);
                y += h2 + dy;
            } else {
                this.btnQuit.setBounds(-w, -w, 0.0f, 0.0f);
            }
        }
        h2 = this.lblLog.getAutoSizeBounds().height + dy;
        this.lblLog.setBounds(x, y, w, h2);
        y += h2;
        h2 = height / 16.0f;
        float y2 = height - dy - h2;
        this.btnCopyLog.setBounds(width / 4.0f, y2, width / 2.0f, h2);
        this.txtLog.setBounds(x, y, w, y2 - y - dy);
        this.btnShowBattlefield.setBounds(width / 4.0f, 0.0f, width / 2.0f, h2);
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (keyCode == 111 || keyCode == 4) {
            this.btnQuit.trigger();
            return true;
        }
        if (keyCode == 62 || keyCode == 66) {
            if (this.btnContinue.isEnabled()) {
                this.btnContinue.trigger();
            } else {
                this.btnQuit.trigger();
            }
            return true;
        }
        return super.keyDown(keyCode);
    }

    @Override
    public void showRewards(Runnable runnable) {
        FThreads.invokeInBackgroundThread(runnable);
    }

    @Override
    public void showCards(String title, List<PaperCard> cards) {
        SGuiChoose.reveal(title, cards);
    }

    @Override
    public void showMessage(String message, String title, FSkinProp icon) {
        SOptionPane.showMessageDialog(message, title, icon);
    }

    private static class OutcomesPanel
    extends FContainer {
        private static final float LBL_HEIGHT = Utils.scale(20.0f);

        private OutcomesPanel() {
        }

        @Override
        protected void doLayout(float width, float height) {
            float y = 0.0f;
            for (FDisplayObject lbl : this.getChildren()) {
                lbl.setBounds(0.0f, y, width, LBL_HEIGHT);
                y += LBL_HEIGHT;
            }
        }
    }
}

