/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.game.spellability.StackItemView;
import forge.game.zone.ZoneType;
import forge.gui.card.CardDetailUtil;
import forge.interfaces.IGameController;
import forge.menu.FCheckBoxMenuItem;
import forge.menu.FDropDown;
import forge.menu.FMenuItem;
import forge.menu.FMenuTab;
import forge.menu.FPopupMenu;
import forge.player.PlayerZoneUpdates;
import forge.screens.match.MatchController;
import forge.screens.match.MatchScreen;
import forge.screens.match.TargetingOverlay;
import forge.screens.match.views.VAvatar;
import forge.screens.match.views.VCardDisplayArea;
import forge.screens.match.views.VPrompt;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.TextUtil;
import forge.util.Utils;
import forge.util.collect.FCollectionView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VStack
extends FDropDown {
    public static final float CARD_WIDTH = Utils.AVG_FINGER_WIDTH;
    public static final float CARD_HEIGHT = Math.round(CARD_WIDTH * 1.4f);
    public static final float BORDER_THICKNESS = Utils.scale(2.0f);
    public static final float PADDING = Utils.scale(3.0f);
    public static final float MARGINS = Utils.scale(4.0f);
    private static final FSkinFont FONT = FSkinFont.get(11);
    private static final float ALPHA_COMPOSITE = 0.5f;
    private static final TextRenderer textRenderer = new TextRenderer(true);
    private StackInstanceDisplay activeItem;
    private StackItemView activeStackInstance;
    private Map<PlayerView, Object> playersWithValidTargets;
    private PlayerZoneUpdates restorablePlayerZones = null;
    private int stackSize;

    @Override
    protected boolean autoHide() {
        return false;
    }

    private void revealTargetZones() {
        if (this.activeStackInstance == null) {
            return;
        }
        PlayerView player = MatchController.instance.getCurrentPlayer();
        HashSet<ZoneType> zones = new HashSet<ZoneType>();
        this.playersWithValidTargets = new HashMap<PlayerView, Object>();
        FCollectionView<CardView> targetCards = this.activeStackInstance.getTargetCards();
        if (targetCards != null) {
            for (CardView c : targetCards) {
                if (c.getZone() == null) continue;
                zones.add(c.getZone());
                this.playersWithValidTargets.put(c.getController(), c);
            }
        }
        if (zones.isEmpty() || this.playersWithValidTargets.isEmpty()) {
            return;
        }
        this.restorablePlayerZones = MatchController.instance.openZones(player, zones, this.playersWithValidTargets, true);
    }

    private void restoreOldZones() {
        if (this.restorablePlayerZones == null) {
            return;
        }
        PlayerView player = MatchController.instance.getCurrentPlayer();
        MatchController.instance.restoreOldZones(player, this.restorablePlayerZones);
        this.restorablePlayerZones = null;
    }

    public void checkEmptyStack() {
        FCollectionView<StackItemView> stack = MatchController.instance.getGameView().getStack();
        if (stack != null && this.isVisible() && stack.isEmpty()) {
            this.getMenuTab().setText(Forge.getLocalizer().getMessage("lblStack", new Object[0]) + " (" + 0 + ")");
            MatchController.getView().getStack().hide();
        }
    }

    @Override
    public void update() {
        this.activeItem = null;
        this.activeStackInstance = null;
        this.restoreOldZones();
        FCollectionView<StackItemView> stack = MatchController.instance.getGameView().getStack();
        if (this.stackSize != stack.size()) {
            int oldStackSize = this.stackSize;
            this.stackSize = stack.size();
            this.getMenuTab().setText(Forge.getLocalizer().getMessage("lblStack", new Object[0]) + " (" + this.stackSize + ")");
            if (this.stackSize > 0) {
                if (!this.isVisible()) {
                    if (this.stackSize > oldStackSize) {
                        this.show();
                    }
                    return;
                }
            } else {
                this.hide();
                return;
            }
        }
        super.update();
    }

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        this.clear();
        float x = MARGINS;
        float y = MARGINS;
        float totalWidth = Forge.isLandscapeMode() ? (float)Forge.getScreenWidth() * 0.35f : maxWidth - MatchController.getView().getTopPlayerPanel().getTabs().iterator().next().getRight();
        float width = totalWidth - 2.0f * MARGINS;
        FCollectionView<StackItemView> stack = MatchController.instance.getGameView().getStack();
        if (stack.isEmpty()) {
            FLabel label = this.add(new FLabel.Builder().text("[" + Forge.getLocalizer().getMessage("lblEmpty", new Object[0]) + "]").font(FONT).align(1).build());
            float height = (float)Math.round(label.getAutoSizeBounds().height) + 2.0f * PADDING;
            label.setBounds(x, y, width, height);
            return new FScrollPane.ScrollBounds(totalWidth, y + height + MARGINS);
        }
        StackItemView stackInstance = null;
        StackInstanceDisplay display = null;
        float overlap = Math.round(CARD_HEIGHT / 2.0f + PADDING + BORDER_THICKNESS);
        for (int i = stack.size() - 1; i >= 0; --i) {
            stackInstance = stack.get((StackItemView)i);
            display = new StackInstanceDisplay(stackInstance, width);
            if (this.activeStackInstance == stackInstance) {
                this.activeItem = display;
            } else {
                this.add(display);
            }
            display.setBounds(x, y, width, i > 0 ? overlap : display.preferredHeight);
            y += display.getHeight();
        }
        if (this.activeStackInstance == null) {
            this.activeStackInstance = stackInstance;
            this.activeItem = display;
        } else {
            this.activeItem.setHeight(display.preferredHeight);
            if (this.activeItem.getBottom() > y) {
                y = this.activeItem.getBottom();
            }
            this.add(this.activeItem);
        }
        this.scrollIntoView(this.activeItem);
        this.revealTargetZones();
        return new FScrollPane.ScrollBounds(totalWidth, y + MARGINS);
    }

    @Override
    protected void updateSizeAndPosition() {
        if (!this.getRotate90()) {
            super.updateSizeAndPosition();
            return;
        }
        FMenuTab menuTab = this.getMenuTab();
        float screenHeight = Forge.getScreenHeight();
        float width = (screenHeight - 2.0f * VPrompt.HEIGHT - 2.0f * VAvatar.HEIGHT) * 4.0f / 6.0f;
        float maxVisibleHeight = menuTab.screenPos.x;
        this.paneSize = this.updateAndGetPaneSize(width + MatchController.getView().getTopPlayerPanel().getTabs().iterator().next().getRight(), maxVisibleHeight);
        this.paneSize = new FScrollPane.ScrollBounds(Math.round(this.paneSize.getWidth()), Math.round(this.paneSize.getHeight()));
        this.setBounds(Math.round(menuTab.screenPos.x - width), Math.round((screenHeight + width) / 2.0f), this.paneSize.getWidth(), Math.min(this.paneSize.getHeight(), maxVisibleHeight));
    }

    @Override
    protected void setScrollPositionsAfterLayout(float scrollLeft0, float scrollTop0) {
        super.setScrollPositionsAfterLayout(0.0f, 0.0f);
    }

    @Override
    protected void drawOnContainer(Graphics g2) {
        if (this.activeItem != null) {
            Vector2 arrowOrigin = new Vector2(this.activeItem.getLeft() + CARD_WIDTH * 0.15f + PADDING + BORDER_THICKNESS, this.activeItem.getTop() + CARD_HEIGHT * 0.5f + PADDING + BORDER_THICKNESS);
            PlayerView activator = this.activeStackInstance.getActivatingPlayer();
            arrowOrigin = arrowOrigin.add(this.screenPos.x, this.screenPos.y);
            for (StackItemView instance = this.activeStackInstance; instance != null; instance = instance.getSubInstance()) {
                TargetingOverlay.ArcConnection conn;
                for (CardView c : instance.getTargetCards()) {
                    conn = activator.isOpponentOf(c.getController()) ? TargetingOverlay.ArcConnection.FoesStackTargeting : TargetingOverlay.ArcConnection.FriendsStackTargeting;
                    TargetingOverlay.drawArrow(g2, arrowOrigin, VCardDisplayArea.CardAreaPanel.get(c).getTargetingArrowOrigin(), conn);
                }
                for (PlayerView p : instance.getTargetPlayers()) {
                    conn = activator.isOpponentOf(p) ? TargetingOverlay.ArcConnection.FoesStackTargeting : TargetingOverlay.ArcConnection.FriendsStackTargeting;
                    MatchController.getView();
                    TargetingOverlay.drawArrow(g2, arrowOrigin, MatchScreen.getPlayerPanel(p).getAvatar().getTargetingArrowOrigin(), conn);
                }
            }
        }
    }

    public class StackInstanceDisplay
    extends FDisplayObject {
        public final StackItemView stackInstance;
        private final Color foreColor;
        private final Color backColor;
        private String text;
        private float preferredHeight;

        private StackInstanceDisplay(StackItemView stackInstance0, float width) {
            boolean isFaceDown;
            this.stackInstance = stackInstance0;
            CardView card = this.stackInstance.getSourceCard();
            this.text = this.stackInstance.getText();
            if (this.stackInstance.isOptionalTrigger() && stackInstance0.getActivatingPlayer().equals(MatchController.instance.getCurrentPlayer())) {
                this.text = "(OPTIONAL) " + this.text;
            }
            CardDetailUtil.DetailColors color = (isFaceDown = card.isFaceDown()) ? CardDetailUtil.DetailColors.FACE_DOWN : CardDetailUtil.getBorderColor(card.getCurrentState(), true);
            this.backColor = FSkinColor.fromRGB(color.r, color.g, color.b);
            this.foreColor = FSkinColor.getHighContrastColor(this.backColor);
            width -= CARD_WIDTH;
            float height = Math.max(CARD_HEIGHT, textRenderer.getWrappedBounds((String)this.text, (FSkinFont)FONT, (float)(width -= 3.0f * VStack.PADDING + 2.0f * VStack.BORDER_THICKNESS)).height);
            this.preferredHeight = Math.round(height += 2.0f * (PADDING + BORDER_THICKNESS));
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (VStack.this.activeStackInstance != this.stackInstance) {
                VStack.this.activeStackInstance = this.stackInstance;
                VStack.this.restoreOldZones();
                VStack.this.updateSizeAndPosition();
                return true;
            }
            final GameView gameView = MatchController.instance.getGameView();
            final MatchController gui = MatchController.instance;
            final IGameController controller = MatchController.instance.getGameController();
            final PlayerView player = MatchController.instance.getCurrentPlayer();
            if (player != null && this.stackInstance.isAbility()) {
                FPopupMenu menu = new FPopupMenu(){

                    @Override
                    protected void buildMenu() {
                        String key = StackInstanceDisplay.this.stackInstance.getKey();
                        boolean autoYield = gui.shouldAutoYield(key);
                        this.addItem(new FCheckBoxMenuItem(Forge.getLocalizer().getMessage("cbpAutoYieldMode", new Object[0]), autoYield, e -> {
                            gui.setShouldAutoYield(key, !autoYield);
                            if (!autoYield && StackInstanceDisplay.this.stackInstance.equals(gameView.peekStack())) {
                                controller.passPriority();
                            }
                        }));
                        if (StackInstanceDisplay.this.stackInstance.isOptionalTrigger() && StackInstanceDisplay.this.stackInstance.getActivatingPlayer().equals(player)) {
                            int triggerID = StackInstanceDisplay.this.stackInstance.getSourceTrigger();
                            this.addItem(new FCheckBoxMenuItem(Forge.getLocalizer().getMessage("lblAlwaysYes", new Object[0]), gui.shouldAlwaysAcceptTrigger(triggerID), e -> {
                                if (gui.shouldAlwaysAcceptTrigger(triggerID)) {
                                    gui.setShouldAlwaysAskTrigger(triggerID);
                                } else {
                                    gui.setShouldAlwaysAcceptTrigger(triggerID);
                                    if (StackInstanceDisplay.this.stackInstance.equals(gameView.peekStack())) {
                                        controller.selectButtonOk();
                                    }
                                }
                            }));
                            this.addItem(new FCheckBoxMenuItem(Forge.getLocalizer().getMessage("lblAlwaysNo", new Object[0]), gui.shouldAlwaysDeclineTrigger(triggerID), e -> {
                                if (gui.shouldAlwaysDeclineTrigger(triggerID)) {
                                    gui.setShouldAlwaysAskTrigger(triggerID);
                                } else {
                                    gui.setShouldAlwaysDeclineTrigger(triggerID);
                                    if (StackInstanceDisplay.this.stackInstance.equals(gameView.peekStack())) {
                                        controller.selectButtonCancel();
                                    }
                                }
                            }));
                        }
                        this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblZoomOrDetails", new Object[0]), e -> CardZoom.show(StackInstanceDisplay.this.stackInstance.getSourceCard())));
                    }
                };
                menu.show(this, x, y);
                return true;
            }
            CardZoom.show(this.stackInstance.getSourceCard());
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            CardZoom.show(this.stackInstance.getSourceCard());
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            String optionalCostString;
            boolean needAlpha;
            float x = 0.0f;
            float y = 0.0f;
            float w = this.getWidth();
            float h2 = this.preferredHeight;
            CardView sourceCard = this.stackInstance.getSourceCard();
            boolean bl = needAlpha = VStack.this.activeStackInstance != this.stackInstance;
            if (needAlpha) {
                g2.setAlphaComposite(0.5f);
            }
            g2.startClip(0.0f, 0.0f, w, this.getHeight());
            g2.fillRect(this.isHovered() ? Color.GRAY : Color.BLACK, x, y, w, h2);
            g2.fillRect(this.backColor, x += BORDER_THICKNESS, y += BORDER_THICKNESS, w -= 2.0f * BORDER_THICKNESS, h2 -= 2.0f * BORDER_THICKNESS);
            CardRenderer.drawCardWithOverlays(g2, sourceCard, x += PADDING, y += PADDING, CARD_WIDTH, CARD_HEIGHT, CardRenderer.CardStackPosition.Top, true, false, false);
            w -= (x += CARD_WIDTH + PADDING) + PADDING - BORDER_THICKNESS;
            h2 -= y + PADDING - BORDER_THICKNESS;
            String name = sourceCard.getName();
            int index = this.text.indexOf(name);
            String newtext = "";
            String cId = "(" + sourceCard.getId() + ")";
            String string = optionalCostString = !this.stackInstance.getOptionalCostString().isEmpty() ? " (" + this.stackInstance.getOptionalCostString() + ")" : "";
            if (index == -1) {
                newtext = TextUtil.fastReplace(this.text.trim(), "  ", " ");
                newtext = TextUtil.fastReplace(TextUtil.fastReplace(newtext, "--", "-"), "- -", "-");
                newtext = TextUtil.fastReplace(TextUtil.fastReplace(newtext, " and .", "."), " .", ".");
                newtext = TextUtil.fastReplace(TextUtil.fastReplace(newtext, "- - ", "- "), ". .", ".");
                newtext = TextUtil.fastReplace(newtext, "CARDNAME", name);
                textRenderer.drawText(g2, name + " " + (name.length() > 1 ? cId : "") + optionalCostString + "\n" + (newtext.length() > 1 ? newtext : ""), FONT, this.foreColor, x, y, w, h2, y, h2, true, 8, true);
            } else {
                String modifier = this.text.substring(0, index).length() > 0 ? "CARDNAME" : "";
                String trimFirst = TextUtil.fastReplace("\n" + this.text.substring(0, index) + modifier + this.text.substring(index + name.length()), "- -", "-");
                String trimSecond = TextUtil.fastReplace(trimFirst, name + " " + cId, name);
                newtext = TextUtil.fastReplace(trimSecond, " " + cId, name);
                if (newtext.equals("\n" + name)) {
                    textRenderer.drawText(g2, name + " " + cId + optionalCostString, FONT, this.foreColor, x, y, w, h2, y, h2, true, 8, true);
                } else {
                    newtext = TextUtil.fastReplace(newtext, "  ", " ");
                    newtext = TextUtil.fastReplace(TextUtil.fastReplace(newtext, name + " -", "-"), "\n ", "\n");
                    newtext = "\n" + TextUtil.fastReplace(newtext.trim(), "--", "-");
                    newtext = TextUtil.fastReplace(TextUtil.fastReplace(newtext, " and .", "."), " .", ".");
                    newtext = TextUtil.fastReplace(TextUtil.fastReplace(newtext, "- - ", "- "), ". .", ".");
                    newtext = TextUtil.fastReplace(newtext, "CARDNAME", name);
                    newtext = TextUtil.fastReplace(newtext, name + name, name);
                    textRenderer.drawText(g2, name + " " + cId + optionalCostString + newtext, FONT, this.foreColor, x, y, w, h2, y, h2, true, 8, true);
                }
            }
            g2.endClip();
            if (needAlpha) {
                g2.resetAlphaComposite();
            }
        }
    }
}

