/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.game.card.CardView;
import forge.item.PaperCard;
import forge.menu.FDropDown;
import forge.screens.match.MatchController;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.CardTranslation;
import forge.util.ImageUtil;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class VReveal
extends FDropDown {
    public static final float MARGINS = Utils.scale(4.0f);
    private static final FSkinFont FONT = FSkinFont.get(11);
    public static final float PADDING = Utils.scale(3.0f);
    private List<PaperCard> revealed = new ArrayList<PaperCard>();
    private final TextRenderer renderer = new TextRenderer(false);

    private static FSkinColor getAltRowColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ZEBRA);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ZEBRA);
    }

    private static FSkinColor getRowColor() {
        return VReveal.getAltRowColor().darker();
    }

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    @Override
    protected boolean autoHide() {
        return true;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.fillRect(VReveal.getRowColor(), 0.0f, 0.0f, w, h2);
    }

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        float x = MARGINS;
        float y = MARGINS;
        float totalWidth = Forge.getScreenWidth();
        float width = totalWidth - 2.0f * MARGINS;
        float entryWidth = totalWidth;
        float minWidth = 4.0f * Utils.AVG_FINGER_WIDTH;
        if (entryWidth < minWidth) {
            entryWidth = minWidth;
        }
        if (MatchController.instance.getGameView().getRevealedCollection() == null || MatchController.instance.getGameView().getRevealedCollection().isEmpty()) {
            FLabel label = this.add(new FLabel.Builder().text("[" + Forge.getLocalizer().getMessage("lblEmpty", new Object[0]) + "]").font(FSkinFont.get(11)).align(1).build());
            float height = (float)Math.round(label.getAutoSizeBounds().height) + 2.0f * PADDING;
            label.setBounds(x, y, width, height);
            return new FScrollPane.ScrollBounds(totalWidth, y + height + MARGINS);
        }
        if (MatchController.instance.getGameView().getRevealedCollection().size() > this.revealed.size()) {
            this.clear();
            this.revealed.clear();
            boolean isAltRow = false;
            x = this.getMenuTab().screenPos.x;
            y = 1.0f;
            for (CardView c : MatchController.instance.getGameView().getRevealedCollection()) {
                PaperCard pc = ImageUtil.getPaperCardFromImageKey(c.getCurrentState().getTrackableImageKey());
                if (pc != null) {
                    this.revealed.add(pc);
                    RevealEntryDisplay revealEntryDisplay = this.add(new RevealEntryDisplay(pc, isAltRow));
                    isAltRow = !isAltRow;
                    float entryHeight = revealEntryDisplay.getMinHeight(entryWidth) + MARGINS;
                    revealEntryDisplay.setBounds(0.0f, y, entryWidth, entryHeight);
                    y += entryHeight;
                    continue;
                }
                System.out.println("Unable to get PaperCard from imageKey: " + c);
            }
        } else {
            y = 1.0f;
            try {
                for (FDisplayObject displayObject : Iterables.unmodifiableIterable(this.getChildren())) {
                    if (!(displayObject instanceof RevealEntryDisplay)) continue;
                    RevealEntryDisplay revealEntryDisplay = (RevealEntryDisplay)displayObject;
                    float entryHeight = revealEntryDisplay.getMinHeight(entryWidth) + MARGINS;
                    revealEntryDisplay.setBounds(0.0f, y, entryWidth, entryHeight);
                    y += entryHeight;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new FScrollPane.ScrollBounds(totalWidth, y + MARGINS);
    }

    private class RevealEntryDisplay
    extends FDisplayObject {
        PaperCard paperCard;
        boolean altRow;
        String text;
        FImage cardArt;

        private RevealEntryDisplay(PaperCard pc, boolean isAltRow) {
            this.paperCard = pc;
            this.altRow = isAltRow;
            this.text = CardTranslation.getTranslatedName(pc.getName()) + "\n" + this.formatType();
        }

        public float getMinHeight(float width) {
            float height = ((VReveal)VReveal.this).renderer.getWrappedBounds((String)"\n", (FSkinFont)FONT, (float)(width -= 2.0f * VReveal.PADDING)).height;
            return Math.round(height += 2.0f * PADDING);
        }

        @Override
        public boolean tap(float x, float y, int count) {
            try {
                int index = VReveal.this.revealed.indexOf(this.paperCard);
                CardZoom.show(VReveal.this.revealed, index, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            float cardArtWidth = h2 * 1.302f;
            if (this.altRow) {
                g2.fillRect(VReveal.getAltRowColor(), 0.0f, 0.0f, w, h2);
            }
            if (this.isHovered()) {
                g2.fillRect(VReveal.getForeColor().brighter().alphaColor(0.3f), 0.0f, 0.0f, w, h2);
            }
            if (this.cardArt == null) {
                this.cardArt = CardRenderer.getCardArt(this.paperCard);
            }
            g2.drawImage(this.cardArt, 0.0f, 0.0f, cardArtWidth, h2);
            VReveal.this.renderer.drawText(g2, this.text, FONT, VReveal.getForeColor(), cardArtWidth + PADDING, PADDING, w - (2.0f * PADDING + cardArtWidth), h2, 0.0f, h2, false, 8, false);
        }

        private String formatType() {
            String type = this.paperCard.getRules().getType().toString();
            if (this.paperCard.getRules().getType().isCreature()) {
                type = type + " (" + this.paperCard.getRules().getPower() + " / " + this.paperCard.getRules().getToughness() + ")";
            } else if (this.paperCard.getRules().getType().isPlaneswalker()) {
                type = type + " (" + this.paperCard.getRules().getInitialLoyalty() + ")";
            } else if (this.paperCard.getRules().getType().isBattle()) {
                type = type + " (" + this.paperCard.getRules().getDefense() + ")";
            } else if (this.paperCard.getRules().getType().hasSubtype("Vehicle")) {
                type = type + String.format(" [%s / %s]", this.paperCard.getRules().getPower(), this.paperCard.getRules().getToughness());
            }
            return type;
        }
    }
}

