/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.card.CardZoom;
import forge.game.card.CardView;
import forge.menu.FMagnifyView;
import forge.toolbox.FButton;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.util.TextBounds;
import forge.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class VPrompt
extends FContainer {
    public static final float HEIGHT = Utils.AVG_FINGER_HEIGHT;
    public static final float BTN_WIDTH = HEIGHT * 1.5f;
    public static final float PADDING = Utils.scale(2.0f);
    public static final FSkinFont FONT = FSkinFont.get(14);
    private final FButton btnOk;
    private final FButton btnCancel;
    private final MessageLabel lblMessage = this.add(new MessageLabel());
    private String message;
    private CardView card = null;

    public static FSkinColor getBackColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_THEME2);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_THEME2);
    }

    public static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public void setCardView(CardView card) {
        this.card = card;
    }

    public VPrompt(String okText, String cancelText, FEvent.FEventHandler okCommand, FEvent.FEventHandler cancelCommand) {
        this.lblMessage.setLeft(BTN_WIDTH);
        this.lblMessage.setHeight(HEIGHT);
        this.btnOk = this.add(new FButton(okText, okCommand));
        this.btnCancel = this.add(new FButton(cancelText, cancelCommand));
        this.btnOk.setSize(BTN_WIDTH, HEIGHT);
        this.btnCancel.setSize(BTN_WIDTH, HEIGHT);
        this.btnOk.setCorner(FButton.Corner.BottomLeft);
        this.btnCancel.setCorner(FButton.Corner.BottomRight);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
    }

    public FButton getBtnOk() {
        return this.btnOk;
    }

    public FButton getBtnCancel() {
        return this.btnCancel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message0) {
        this.message = message0;
        this.card = null;
    }

    public void setMessage(String message0, CardView card0) {
        this.message = message0;
        this.card = card0;
    }

    public void remind() {
    }

    @Override
    protected void doLayout(float width, float height) {
        this.lblMessage.setWidth(width - 2.0f * BTN_WIDTH);
        this.btnCancel.setLeft(this.lblMessage.getRight());
    }

    @Override
    protected void drawBackground(Graphics g2) {
        g2.fillRect(VPrompt.getBackColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    private class MessageLabel
    extends FDisplayObject {
        private final TextRenderer renderer = new TextRenderer();

        private MessageLabel() {
        }

        @Override
        public boolean tap(float x, float y, int count) {
            float maxWidth = this.getWidth() - 2.0f * PADDING;
            float maxHeight = this.getHeight() - 2.0f * PADDING;
            TextBounds textBounds = this.renderer.getWrappedBounds(VPrompt.this.message, FONT, maxWidth);
            if (textBounds.height > maxHeight) {
                FMagnifyView.show(this, VPrompt.this.message, VPrompt.getForeColor(), VPrompt.getBackColor(), FONT, false);
            }
            return true;
        }

        @Override
        public boolean fling(float x, float y) {
            if (VPrompt.this.card != null) {
                CardZoom.show(VPrompt.this.card);
            }
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            if (VPrompt.this.card != null) {
                CardZoom.show(VPrompt.this.card);
            }
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            if (!StringUtils.isEmpty(VPrompt.this.message)) {
                float x = PADDING;
                float y = PADDING;
                float w = this.getWidth() - 2.0f * PADDING;
                float h2 = this.getHeight() - 2.0f * PADDING;
                this.renderer.drawText(g2, VPrompt.this.message, FONT, VPrompt.getForeColor(), x, y, w, h2, y, h2, true, 1, true);
            }
        }
    }
}

