/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.deck.Deck;
import forge.deck.FDeckViewer;
import forge.game.player.PlayerView;
import forge.menu.FDropDown;
import forge.screens.match.MatchController;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FScrollPane;
import forge.util.Utils;

public class VPlayers
extends FDropDown {
    public VPlayers() {
        for (PlayerView p : MatchController.instance.getGameView().getPlayers()) {
            this.add(new PlayerInfoPanel(p));
        }
    }

    @Override
    protected boolean autoHide() {
        return true;
    }

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        float totalHeight = (float)this.getChildCount() * PlayerInfoPanel.HEIGHT;
        float y = totalHeight - PlayerInfoPanel.HEIGHT;
        for (FDisplayObject panel : this.getChildren()) {
            panel.setBounds(0.0f, y, maxWidth, PlayerInfoPanel.HEIGHT);
            y -= PlayerInfoPanel.HEIGHT;
        }
        return new FScrollPane.ScrollBounds(maxWidth, totalHeight);
    }

    private static class PlayerInfoPanel
    extends FContainer {
        private static final FSkinFont FONT = FSkinFont.get(12);
        private static final float PADDING = Utils.scale(5.0f);
        private static final float HEIGHT = Utils.AVG_FINGER_HEIGHT * 1.8f;
        private final PlayerView player;
        private final Deck playerDeck;
        private final FLabel btnDeck;
        private boolean btnAdded = false;

        private PlayerInfoPanel(PlayerView player0) {
            this.player = player0;
            this.playerDeck = MatchController.getPlayerDeck(player0);
            this.btnDeck = new FLabel.ButtonBuilder().opaque(true).iconScaleFactor(0.99f).selectable().alphaComposite(1.0f).iconInBackground(true).build();
            this.btnDeck.setEnabled(!Forge.isMobileAdventureMode);
            this.btnDeck.setVisible(!Forge.isMobileAdventureMode);
            this.btnDeck.setCommand(e -> {
                if (this.playerDeck != null) {
                    if (!MatchController.instance.hasLocalPlayers() && !MatchController.instance.isGamePaused()) {
                        MatchController.instance.pauseMatch();
                    }
                    FDeckViewer.show(this.playerDeck);
                }
            });
        }

        @Override
        protected void doLayout(float width, float height) {
            if (!this.btnAdded) {
                this.btnDeck.setBounds(PADDING, PADDING, this.getHeight() - 2.0f * PADDING, this.getHeight() - 2.0f * PADDING);
                this.btnDeck.setIcon(MatchController.getPlayerAvatar(this.player));
                this.btnDeck.setOverlayIcon(Forge.hdbuttons ? FSkinImage.HDSEARCH : FSkinImage.SEARCH);
                this.add(this.btnDeck);
                this.btnAdded = true;
            }
        }

        @Override
        public void drawBackground(Graphics g2) {
            float x = PADDING;
            float y = PADDING;
            float h2 = this.getHeight() - 2.0f * y;
            int extra = 0;
            String details = this.player.getDetails();
            if (Forge.isMobileAdventureMode) {
                g2.drawImage(MatchController.getPlayerAvatar(this.player), x, y, h2, h2);
            }
            if (!MatchController.instance.getGameView().isCommander()) {
                if (!Forge.isMobileAdventureMode) {
                    details = details + this.playerDeck.getName();
                }
            } else {
                extra += 2;
            }
            float w = this.getWidth() - PADDING - (x += h2 + PADDING);
            String[] s2 = details.split("\n");
            String line1 = "";
            String line2 = "";
            int limit = s2.length / 2 + extra;
            for (int i = 0; i < s2.length; ++i) {
                if (i < limit) {
                    line1 = line1 + s2[i] + "\n";
                    continue;
                }
                line2 = line2 + s2[i] + "\n";
            }
            g2.drawText(line1, FONT, FList.getForeColor(), x, y, w / 2.0f, h2, true, 8, true);
            g2.drawText(line2, FONT, FList.getForeColor(), x + w / 2.0f, y, w / 2.0f, h2, true, 8, true);
        }

        @Override
        public void drawOverlay(Graphics g2) {
            float y = this.getHeight();
            g2.drawLine(1.0f, FList.getLineColor(), 0.0f, y, this.getWidth(), y);
        }
    }
}

