/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinImageInterface;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.menu.FMenuBar;
import forge.model.FModel;
import forge.screens.match.MatchController;
import forge.screens.match.MatchScreen;
import forge.screens.match.views.VAvatar;
import forge.screens.match.views.VDisplayArea;
import forge.screens.match.views.VField;
import forge.screens.match.views.VManaPool;
import forge.screens.match.views.VPhaseIndicator;
import forge.screens.match.views.VZoneDisplay;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VPlayerPanel
extends FContainer {
    private static final FSkinFont LIFE_FONT = FSkinFont.get(18);
    private static final FSkinFont LIFE_FONT_ALT = FSkinFont.get(22);
    private static final FSkinFont INFO_FONT = FSkinFont.get(12);
    private static final FSkinFont INFO2_FONT = FSkinFont.get(14);
    private static final float INFO_TAB_PADDING_X = Utils.scale(2.0f);
    private static final float INFO_TAB_PADDING_Y = Utils.scale(2.0f);
    private final PlayerView player;
    private final VPhaseIndicator phaseIndicator;
    private final VField field;
    private final VAvatar avatar;
    private final VZoneDisplay commandZone;
    private final LifeLabel lblLife;
    private final InfoTab tabManaPool;
    private final Map<ZoneType, InfoTab> zoneTabs = new HashMap<ZoneType, InfoTab>();
    private final List<InfoTab> tabs = new ArrayList<InfoTab>();
    private InfoTab selectedTab;
    private VField.FieldRow selectedRow;
    private float avatarHeight = VAvatar.HEIGHT;
    private float displayAreaHeightFactor = 1.0f;
    private boolean forMultiPlayer = false;
    public int adjustHeight = 1;
    private int selected = 0;

    private static FSkinColor getInfoForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    private static FSkinColor getDisplayAreaBackColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_INACTIVE).alphaColor(0.5f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_INACTIVE).alphaColor(0.5f);
    }

    private static FSkinColor getDeliriumHighlight() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_PHASE_ACTIVE_ENABLED).alphaColor(0.5f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_PHASE_ACTIVE_ENABLED).alphaColor(0.5f);
    }

    public VPlayerPanel(PlayerView player0, boolean showHand, int playerCount) {
        this.player = player0;
        this.phaseIndicator = this.add(new VPhaseIndicator());
        if (playerCount > 2) {
            this.forMultiPlayer = true;
            this.avatarHeight *= 0.5f;
        }
        this.field = this.add(new VField(this.player));
        this.selectedRow = this.field.getRow1();
        this.avatar = this.add(new VAvatar(this.player, this.avatarHeight));
        this.lblLife = this.add(new LifeLabel());
        this.addZoneDisplay(ZoneType.Hand, Forge.hdbuttons ? FSkinImage.HDHAND : FSkinImage.HAND);
        this.addZoneDisplay(ZoneType.Graveyard, Forge.hdbuttons ? FSkinImage.HDGRAVEYARD : FSkinImage.GRAVEYARD);
        this.addZoneDisplay(ZoneType.Library, Forge.hdbuttons ? FSkinImage.HDLIBRARY : FSkinImage.LIBRARY);
        this.addZoneDisplay(ZoneType.Flashback, Forge.hdbuttons ? FSkinImage.HDFLASHBACK : FSkinImage.FLASHBACK);
        VManaPool manaPool = this.add(new VManaPool(this.player));
        this.tabManaPool = this.add(new InfoTab(Forge.hdbuttons ? FSkinImage.HDMANAPOOL : Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_X), manaPool));
        this.tabs.add(this.tabManaPool);
        this.addZoneDisplay(ZoneType.Exile, Forge.hdbuttons ? FSkinImage.HDEXILE : FSkinImage.EXILE);
        this.addZoneDisplay(ZoneType.Sideboard, Forge.hdbuttons ? FSkinImage.HDSIDEBOARD : FSkinImage.SIDEBOARD);
        this.commandZone = this.add(new CommandZoneDisplay(this.player));
        if (showHand) {
            this.setSelectedZone(ZoneType.Hand);
        }
    }

    public PlayerView getPlayer() {
        return this.player;
    }

    public void addZoneDisplay(ZoneType zoneType, FSkinImage tabIcon) {
        VZoneDisplay zoneDisplay = this.add(new VZoneDisplay(this.player, zoneType));
        InfoTab zoneTab = this.add(new InfoTab(tabIcon, zoneDisplay));
        this.zoneTabs.put(zoneType, zoneTab);
        this.tabs.add(zoneTab);
    }

    public Iterable<InfoTab> getTabs() {
        return this.tabs;
    }

    public InfoTab getSelectedTab() {
        return this.selectedTab;
    }

    public InfoTab getZoneTab(ZoneType zoneType) {
        return this.zoneTabs.get((Object)zoneType);
    }

    public ZoneType getZoneByInfoTab(InfoTab tab) {
        for (ZoneType zone : this.zoneTabs.keySet()) {
            if (!this.zoneTabs.get((Object)zone).equals(tab)) continue;
            return zone;
        }
        return null;
    }

    private boolean isAltZoneDisplay(InfoTab tab) {
        if (tab.getIcon() == FSkinImage.HDHAND || tab.getIcon() == FSkinImage.HAND) {
            return true;
        }
        if (tab.getIcon() == FSkinImage.HDGRAVEYARD || tab.getIcon() == FSkinImage.GRAVEYARD) {
            return true;
        }
        if (tab.getIcon() == FSkinImage.HDLIBRARY || tab.getIcon() == FSkinImage.LIBRARY) {
            return true;
        }
        return tab.getIcon() == FSkinImage.HDEXILE || tab.getIcon() == FSkinImage.EXILE;
    }

    public void setSelectedZone(ZoneType zoneType) {
        this.setSelectedTab(this.zoneTabs.get((Object)zoneType));
    }

    public void hideSelectedTab() {
        if (this.selectedTab != null) {
            this.selectedTab.displayArea.setVisible(false);
            this.selectedTab = null;
        }
    }

    public void setSelectedTab(InfoTab selectedTab0) {
        if (this.selectedTab == selectedTab0) {
            return;
        }
        this.hideSelectedTab();
        this.selectedTab = selectedTab0;
        if (this.selectedTab != null) {
            this.selectedTab.displayArea.setVisible(true);
        }
        if (MatchController.getView() != null) {
            MatchController.getView().revalidate();
        }
    }

    public void setNextSelectedTab(boolean change) {
        if (change) {
            if (this.selectedTab != null) {
                this.selectedTab.displayArea.setVisible(false);
                this.selectedTab = null;
            }
            if (MatchController.getView() != null) {
                MatchController.getView().revalidate();
            }
        }
        if (!change) {
            ++this.selected;
        } else {
            this.hideSelectedTab();
        }
        if (this.selected >= this.tabs.size()) {
            this.selected = 0;
        }
        if (this.selected < 0) {
            this.selected = 0;
        }
        this.setSelectedTab(this.tabs.get(this.selected));
    }

    public void closeSelectedTab() {
        if (this.selectedTab != null) {
            this.selectedTab.displayArea.setVisible(false);
            this.selectedTab = null;
        }
        if (MatchController.getView() != null) {
            MatchController.getView().revalidate();
        }
        --this.selected;
        if (this.selected < -1) {
            this.selected = -1;
        }
    }

    public InfoTab getManaPoolTab() {
        return this.tabManaPool;
    }

    public boolean isFlipped() {
        return this.field.isFlipped();
    }

    public void setFlipped(boolean flipped0) {
        this.field.setFlipped(flipped0);
    }

    @Override
    public void setRotate180(boolean b0) {
        this.avatar.setRotate180(b0);
        this.lblLife.setRotate180(b0);
        this.phaseIndicator.setRotate180(b0);
        for (InfoTab tab : this.tabs) {
            tab.displayArea.setRotate180(b0);
        }
        this.field.getRow1().setRotate180(b0);
        this.field.getRow2().setRotate180(b0);
    }

    public VField getField() {
        return this.field;
    }

    public VField.FieldRow getSelectedRow() {
        return this.selectedRow;
    }

    public void switchRow() {
        this.selectedRow = this.selectedRow == this.field.getRow1() ? this.field.getRow2() : this.field.getRow1();
    }

    public VPhaseIndicator getPhaseIndicator() {
        return this.phaseIndicator;
    }

    public VAvatar getAvatar() {
        return this.avatar;
    }

    public VZoneDisplay getCommandZone() {
        return this.commandZone;
    }

    public void updateLife() {
        this.lblLife.update();
    }

    public void updateShards() {
        this.lblLife.updateShards();
    }

    public void updateManaPool() {
        this.tabManaPool.update();
    }

    public void updateZone(ZoneType zoneType) {
        if (zoneType == ZoneType.Battlefield) {
            this.field.update(true);
        } else if (zoneType == ZoneType.Command) {
            this.commandZone.update();
        } else {
            InfoTab zoneTab = this.zoneTabs.get((Object)zoneType);
            if (zoneTab != null) {
                zoneTab.update();
            }
            switch (zoneType) {
                case Graveyard: 
                case Library: 
                case Exile: 
                case Stack: {
                    this.zoneTabs.get((Object)ZoneType.Flashback).update();
                    break;
                }
            }
        }
    }

    @Override
    protected void doLayout(float width, float height) {
        int commandZoneCount;
        if (Forge.isLandscapeMode()) {
            this.doLandscapeLayout(width, height);
            return;
        }
        float x = this.avatarHeight;
        float w = width - this.avatarHeight;
        float indicatorScale = 1.0f;
        if (this.avatarHeight < VAvatar.HEIGHT) {
            indicatorScale = 0.6f;
        }
        float h2 = this.phaseIndicator.getPreferredHeight(w) * indicatorScale;
        this.phaseIndicator.setBounds(x, height - h2, w, h2);
        float y = height - this.avatarHeight;
        float displayAreaHeight = this.displayAreaHeightFactor * y / 3.0f;
        y -= displayAreaHeight;
        for (InfoTab tab : this.tabs) {
            tab.displayArea.setBounds(0.0f, y, width, displayAreaHeight);
        }
        y = height - this.avatarHeight;
        this.avatar.setPosition(0.0f, y);
        float lifeLabelWidth = VPlayerPanel.LIFE_FONT.getBounds((CharSequence)"99").width * 1.2f * indicatorScale;
        float infoLabelHeight = this.avatarHeight - this.phaseIndicator.getHeight();
        this.lblLife.setBounds(x, y, lifeLabelWidth, infoLabelHeight);
        float infoTabWidth = (this.getWidth() - (x += lifeLabelWidth)) / (float)this.tabs.size();
        for (InfoTab tab : this.tabs) {
            tab.setBounds(x, y, infoTabWidth, infoLabelHeight);
            x += infoTabWidth;
        }
        if (this.selectedTab != null) {
            y -= displayAreaHeight;
        }
        if ((commandZoneCount = this.commandZone.getCount()) > 0) {
            float commandZoneHeight = y / 2.0f;
            float commandZoneWidth = (float)Math.min(commandZoneCount, 2) * this.commandZone.getCardWidth(commandZoneHeight);
            this.commandZone.setBounds(width - commandZoneWidth, y - commandZoneHeight, commandZoneWidth, commandZoneHeight);
            this.field.setCommandZoneWidth(commandZoneWidth + 1.0f);
        } else {
            this.field.setCommandZoneWidth(0.0f);
        }
        this.field.setBounds(0.0f, 0.0f, width, y);
        if (this.isFlipped()) {
            for (FDisplayObject child : this.getChildren()) {
                child.setTop(height - child.getBottom());
            }
        }
        this.field.setFieldModifier(0.0f);
    }

    private void doLandscapeLayout(float width, float height) {
        int commandZoneCount;
        float x = 0.0f;
        float y = 0.0f;
        float yAlt = 0.0f;
        float avatarWidth = Forge.altZoneTabs ? this.avatar.getWidth() : 0.0f;
        this.avatar.setPosition(x, y);
        this.lblLife.setBounds(x, Forge.altPlayerLayout && !Forge.altZoneTabs ? 0.0f : (y += this.avatar.getHeight()), this.avatar.getWidth(), Forge.altPlayerLayout && !Forge.altZoneTabs ? INFO_FONT.getLineHeight() : (Forge.altZoneTabs ? LIFE_FONT_ALT.getLineHeight() : LIFE_FONT.getLineHeight()));
        if (Forge.altPlayerLayout && !Forge.altZoneTabs) {
            if (this.adjustHeight > 2) {
                y += INFO_FONT.getLineHeight() / 2.0f;
            }
        } else {
            y += this.lblLife.getHeight();
        }
        float infoTabWidth = this.avatar.getWidth();
        int tabSize = !Forge.altZoneTabs ? this.tabs.size() : this.tabs.size() - 4;
        float infoTabHeight = (height - y) / (float)tabSize;
        float infoTabHeightAlt = (height - yAlt) / 4.0f;
        for (InfoTab tab : this.tabs) {
            if (!Forge.altZoneTabs) {
                tab.setBounds(x, y, infoTabWidth, infoTabHeight);
                y += infoTabHeight;
                continue;
            }
            if (!this.isAltZoneDisplay(tab)) {
                tab.setBounds(x, y, infoTabWidth, infoTabHeight);
                y += infoTabHeight;
                continue;
            }
            tab.setBounds(x + width - avatarWidth, yAlt, avatarWidth, infoTabHeightAlt);
            yAlt += infoTabHeightAlt;
        }
        x = this.avatar.getRight();
        this.phaseIndicator.resetFont();
        this.phaseIndicator.setBounds(x, 0.0f, this.avatar.getWidth() * 0.6f, height);
        float fieldWidth = width - (x += this.phaseIndicator.getWidth()) - avatarWidth;
        float displayAreaWidth = height / 1.4f;
        if (this.selectedTab != null) {
            fieldWidth -= displayAreaWidth;
        }
        if ((commandZoneCount = this.commandZone.getCount()) > 0) {
            float commandZoneHeight = height / 2.0f;
            float commandZoneWidth = (float)Math.min(commandZoneCount, 2) * this.commandZone.getCardWidth(commandZoneHeight);
            this.commandZone.setBounds(x + fieldWidth - commandZoneWidth, height - commandZoneHeight, commandZoneWidth, commandZoneHeight);
            if (this.isFlipped()) {
                this.commandZone.setTop(height - this.commandZone.getBottom());
            }
            this.field.setCommandZoneWidth(commandZoneWidth + 1.0f);
        } else {
            this.field.setCommandZoneWidth(0.0f);
        }
        this.field.setBounds(x, 0.0f, fieldWidth, height);
        x = width - displayAreaWidth - avatarWidth;
        for (InfoTab tab : this.tabs) {
            tab.displayArea.setBounds(x, 0.0f, displayAreaWidth, height);
        }
        if (!Forge.altZoneTabs) {
            this.field.setFieldModifier(0.0f);
        } else {
            this.field.setFieldModifier(avatarWidth / 16.0f);
        }
    }

    @Override
    public void drawBackground(Graphics g2) {
        float y;
        if (this.selectedTab != null) {
            VDisplayArea selectedDisplayArea = this.selectedTab.displayArea;
            float x = selectedDisplayArea.getLeft();
            float w = selectedDisplayArea.getWidth();
            g2.fillRect(VPlayerPanel.getDisplayAreaBackColor(), x, selectedDisplayArea.getTop(), w, selectedDisplayArea.getHeight());
            if (Forge.isLandscapeMode()) {
                g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, selectedDisplayArea.getTop(), x, selectedDisplayArea.getBottom());
            } else {
                y = this.isFlipped() ? selectedDisplayArea.getTop() + 1.0f : selectedDisplayArea.getBottom();
                g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, y, this.selectedTab.getLeft(), y);
                g2.drawLine(1.0f, MatchScreen.getBorderColor(), this.selectedTab.getRight(), y, w, y);
            }
        }
        if (this.commandZone.isVisible()) {
            float x = this.commandZone.getLeft();
            y = this.commandZone.getTop();
            g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, y, x, y + this.commandZone.getHeight());
            if (this.isFlipped()) {
                y += this.commandZone.getHeight();
            }
            g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, y, x + this.commandZone.getWidth(), y);
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (MatchController.getView().selectedPlayerPanel() == this && !((FMenuBar)MatchController.getView().getHeader()).isShowingMenu(true)) {
            if (keyCode == 97) {
                MatchScreen.nullPotentialListener();
                this.closeSelectedTab();
                return true;
            }
            if (keyCode == 103) {
                this.setNextSelectedTab(false);
                return true;
            }
        }
        return super.keyDown(keyCode);
    }

    private class CommandZoneDisplay
    extends VZoneDisplay {
        private CommandZoneDisplay(PlayerView player0) {
            super(player0, ZoneType.Command);
        }

        @Override
        protected void refreshCardPanels(Iterable<CardView> model) {
            int oldCount = this.getCount();
            super.refreshCardPanels(model);
            int newCount = this.getCount();
            if (newCount != oldCount) {
                this.setVisible(newCount > 0);
                VPlayerPanel.this.revalidate();
            }
        }

        @Override
        protected boolean layoutVerticallyForLandscapeMode() {
            return false;
        }
    }

    public class InfoTab
    extends FDisplayObject {
        private String value = "0";
        private final FSkinImageInterface icon;
        private final VDisplayArea displayArea;

        private InfoTab(FSkinImageInterface icon0, VDisplayArea displayArea0) {
            this.icon = icon0;
            this.displayArea = displayArea0;
        }

        public FSkinImageInterface getIcon() {
            return this.icon;
        }

        public VDisplayArea getDisplayArea() {
            return this.displayArea;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (VPlayerPanel.this.selectedTab == this) {
                VPlayerPanel.this.setSelectedTab(null);
            } else {
                VPlayerPanel.this.setSelectedTab(this);
            }
            return true;
        }

        public void update() {
            this.displayArea.update();
            this.value = String.valueOf(this.displayArea.getCount());
        }

        @Override
        public void draw(Graphics g2) {
            float maxImageWidth;
            float h2;
            float w;
            float y;
            boolean drawOverlay;
            boolean bl = drawOverlay = MatchController.getView().selectedPlayerPanel().getPlayer() == VPlayerPanel.this.player && Forge.hasGamepad();
            if (Forge.altZoneTabs && VPlayerPanel.this.isAltZoneDisplay(this) && VPlayerPanel.this.selectedTab == this) {
                if (drawOverlay) {
                    g2.fillRect(FSkinColor.getStandardColor(50, 200, 150).alphaColor(0.3f), 0.0f, VPlayerPanel.this.isFlipped() ? INFO_TAB_PADDING_Y : 0.0f, this.getWidth(), this.getHeight() - INFO_TAB_PADDING_Y);
                }
                g2.fillRect(VPlayerPanel.getDisplayAreaBackColor(), 0.0f, VPlayerPanel.this.isFlipped() ? INFO_TAB_PADDING_Y : 0.0f, this.getWidth(), this.getHeight() - INFO_TAB_PADDING_Y);
            }
            if (VPlayerPanel.this.selectedTab == this) {
                float yAcross;
                y = 0.0f;
                w = this.getWidth();
                h2 = this.getHeight();
                if (VPlayerPanel.this.isFlipped()) {
                    yAcross = y += INFO_TAB_PADDING_Y;
                    y -= 1.0f;
                    h2 += 1.0f;
                } else {
                    yAcross = h2 -= INFO_TAB_PADDING_Y;
                    y -= 1.0f;
                    h2 += 2.0f;
                }
                if (drawOverlay) {
                    g2.fillRect(FSkinColor.getStandardColor(50, 200, 150).alphaColor(0.3f), 0.0f, VPlayerPanel.this.isFlipped() ? INFO_TAB_PADDING_Y : 0.0f, w, this.getHeight() - INFO_TAB_PADDING_Y);
                }
                if ((this.icon == FSkinImage.HDGRAVEYARD || this.icon == FSkinImage.GRAVEYARD) && VPlayerPanel.this.player.hasDelirium()) {
                    g2.fillRect(VPlayerPanel.getDeliriumHighlight(), 0.0f, VPlayerPanel.this.isFlipped() ? INFO_TAB_PADDING_Y : 0.0f, w, this.getHeight() - INFO_TAB_PADDING_Y);
                } else {
                    g2.fillRect(VPlayerPanel.getDisplayAreaBackColor(), 0.0f, VPlayerPanel.this.isFlipped() ? INFO_TAB_PADDING_Y : 0.0f, w, this.getHeight() - INFO_TAB_PADDING_Y);
                }
                if (!Forge.isLandscapeMode()) {
                    if (VPlayerPanel.this.isFlipped()) {
                        g2.startClip(-1.0f, y, w + 2.0f, h2);
                    } else {
                        g2.startClip(-1.0f, y, w + 2.0f, yAcross - y);
                    }
                    if (VPlayerPanel.this.forMultiPlayer) {
                        g2.drawLine(1.0f, MatchScreen.getBorderColor(), 0.0f, yAcross, w, yAcross);
                        g2.drawLine(1.0f, MatchScreen.getBorderColor(), 0.0f, y, 0.0f, h2);
                        g2.drawLine(1.0f, MatchScreen.getBorderColor(), w, y, w, h2);
                    }
                    g2.endClip();
                }
            }
            if (this.getWidth() > this.getHeight()) {
                float maxImageHeight;
                maxImageWidth = this.getWidth() - INFO_FONT.getBounds((CharSequence)"0").width - 3.0f * INFO_TAB_PADDING_X;
                w = this.icon.getNearestHQWidth(maxImageWidth);
                if (w > maxImageWidth) {
                    w /= 2.0f;
                }
                if ((h2 = this.icon.getHeight() * w / this.icon.getWidth()) > (maxImageHeight = this.getHeight() - 2.0f * INFO_TAB_PADDING_Y)) {
                    h2 = this.icon.getNearestHQHeight(maxImageHeight);
                    if (h2 > maxImageWidth) {
                        h2 /= 2.0f;
                    }
                    w = this.icon.getWidth() * h2 / this.icon.getHeight();
                }
                float x = INFO_TAB_PADDING_X + (maxImageWidth - w) / 2.0f;
                y = (this.getHeight() - h2) / 2.0f;
                if (VPlayerPanel.this.lblLife.getRotate180()) {
                    g2.startRotateTransform(x + w / 2.0f, y + h2 / 2.0f, 180.0f);
                }
                float mod = this.isHovered() ? w / 8.0f : 0.0f;
                g2.drawImage(this.icon, x - mod / 2.0f, y - mod / 2.0f, w + mod, h2 + mod);
                if (VPlayerPanel.this.lblLife.getRotate180()) {
                    g2.endTransform();
                }
                x += w + INFO_TAB_PADDING_X;
                int alignX = 8;
                if (VPlayerPanel.this.lblLife.getRotate180()) {
                    g2.startRotateTransform(x + (this.getWidth() - x + 1.0f) / 2.0f, this.getHeight() / 2.0f, 180.0f);
                    alignX = 16;
                }
                g2.drawText(this.value, INFO_FONT, VPlayerPanel.getInfoForeColor(), x, 0.0f, this.getWidth() - x + 1.0f, this.getHeight(), false, alignX, true);
                if (VPlayerPanel.this.lblLife.getRotate180()) {
                    g2.endTransform();
                }
            } else {
                if (VPlayerPanel.this.lblLife.getRotate180()) {
                    g2.startRotateTransform(this.getWidth() / 2.0f, this.getHeight() / 2.0f, 180.0f);
                }
                if ((w = this.icon.getNearestHQWidth(maxImageWidth = this.getWidth() - 2.0f * INFO_TAB_PADDING_X)) > maxImageWidth) {
                    w /= 2.0f;
                }
                h2 = this.icon.getHeight() * w / this.icon.getWidth();
                float x = (this.getWidth() - w) / 2.0f;
                y = INFO_TAB_PADDING_Y;
                float mod = this.isHovered() ? w / 8.0f : 0.0f;
                g2.drawImage(this.icon, x - mod / 2.0f, y - mod / 2.0f, w + mod, h2 + mod);
                g2.drawText(this.value, INFO_FONT, VPlayerPanel.getInfoForeColor(), 0.0f, y += h2 + INFO_TAB_PADDING_Y, this.getWidth(), this.getHeight() - y + 1.0f, false, 1, false);
                if (VPlayerPanel.this.lblLife.getRotate180()) {
                    g2.endTransform();
                }
            }
        }
    }

    private class LifeLabel
    extends FDisplayObject {
        private int life;
        private int poisonCounters;
        private int energyCounters;
        private int experienceCounters;
        private int ticketCounters;
        private int radCounters;
        private int manaShards;
        private String lifeStr;

        private LifeLabel() {
            this.life = VPlayerPanel.this.player.getLife();
            this.poisonCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.POISON);
            this.energyCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.ENERGY);
            this.experienceCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.EXPERIENCE);
            this.ticketCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.TICKET);
            this.radCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.RAD);
            this.manaShards = VPlayerPanel.this.player.getNumManaShards();
            this.lifeStr = String.valueOf(this.life);
        }

        private void update() {
            int vibrateDuration = 0;
            int delta = VPlayerPanel.this.player.getLife() - this.life;
            VPlayerPanel.this.player.setAvatarLifeDifference(VPlayerPanel.this.player.getAvatarLifeDifference() + delta);
            if (delta != 0) {
                if (delta < 0) {
                    vibrateDuration += delta * -100;
                }
                this.life = VPlayerPanel.this.player.getLife();
                this.lifeStr = String.valueOf(this.life);
            }
            if ((delta = VPlayerPanel.this.player.getCounters(CounterEnumType.POISON) - this.poisonCounters) != 0) {
                if (delta > 0) {
                    vibrateDuration += delta * 200;
                }
                this.poisonCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.POISON);
            }
            this.energyCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.ENERGY);
            this.experienceCounters = VPlayerPanel.this.player.getCounters(CounterEnumType.EXPERIENCE);
            this.manaShards = VPlayerPanel.this.player.getNumManaShards();
            if (vibrateDuration > 0 && MatchController.instance.isLocalPlayer(VPlayerPanel.this.player) && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_VIBRATE_ON_LIFE_LOSS)) {
                Gdx.input.vibrate(Math.min(vibrateDuration, 2000));
            }
        }

        private void updateShards() {
            this.manaShards = VPlayerPanel.this.player.getNumManaShards();
        }

        @Override
        public boolean tap(float x, float y, int count) {
            MatchController.instance.getGameController().selectPlayer(VPlayerPanel.this.player, null);
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            float divider;
            VPlayerPanel.this.adjustHeight = 1;
            float f = divider = Gdx.app.getGraphics().getHeight() > 900 ? 1.2f : 2.0f;
            if (Forge.altPlayerLayout && !Forge.altZoneTabs && Forge.isLandscapeMode()) {
                if (this.poisonCounters == 0 && this.energyCounters == 0 && this.experienceCounters == 0 && this.ticketCounters == 0 && this.radCounters == 0 && this.manaShards == 0) {
                    g2.fillRect(Color.DARK_GRAY, 0.0f, 0.0f, INFO2_FONT.getBounds((CharSequence)this.lifeStr).width + 1.0f, INFO2_FONT.getBounds((CharSequence)this.lifeStr).height + 1.0f);
                    g2.drawText(this.lifeStr, INFO2_FONT, VPlayerPanel.getInfoForeColor().getColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), false, 8, false);
                } else {
                    float halfHeight = this.getHeight() / divider;
                    float textStart = halfHeight + Utils.scale(1.0f);
                    float textWidth = this.getWidth() - textStart;
                    int mod = 1;
                    g2.fillRect(Color.DARK_GRAY, 0.0f, 0.0f, INFO_FONT.getBounds((CharSequence)this.lifeStr).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)this.lifeStr).height + 1.0f);
                    g2.drawImage(FSkinImage.QUEST_LIFE, 0.0f, 0.0f, halfHeight, halfHeight);
                    g2.drawText(this.lifeStr, INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, 0.0f, textWidth, halfHeight, false, 8, false);
                    if (this.poisonCounters > 0) {
                        g2.fillRect(Color.DARK_GRAY, 0.0f, halfHeight + 2.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.poisonCounters)).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.poisonCounters)).height + 1.0f);
                        g2.drawImage(FSkinImage.POISON, 0.0f, halfHeight + 2.0f, halfHeight, halfHeight);
                        g2.drawText(String.valueOf(this.poisonCounters), INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, halfHeight + 2.0f, textWidth, halfHeight, false, 8, false);
                        ++mod;
                    }
                    if (this.energyCounters > 0) {
                        g2.fillRect(Color.DARK_GRAY, 0.0f, halfHeight * (float)mod + 2.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.energyCounters)).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.energyCounters)).height + 1.0f);
                        g2.drawImage(FSkinImage.ENERGY, 0.0f, halfHeight * (float)mod + 2.0f, halfHeight, halfHeight);
                        g2.drawText(String.valueOf(this.energyCounters), INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, halfHeight * (float)mod + 2.0f, textWidth, halfHeight, false, 8, false);
                        ++mod;
                    }
                    if (this.experienceCounters > 0) {
                        g2.fillRect(Color.DARK_GRAY, 0.0f, halfHeight * (float)mod + 2.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.experienceCounters)).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.experienceCounters)).height + 1.0f);
                        g2.drawImage(FSkinImage.COMMANDER, 0.0f, halfHeight * (float)mod + 2.0f, halfHeight, halfHeight);
                        g2.drawText(String.valueOf(this.experienceCounters), INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, halfHeight * (float)mod + 2.0f, textWidth, halfHeight, false, 8, false);
                        ++mod;
                    }
                    if (this.radCounters > 0) {
                        g2.fillRect(Color.DARK_GRAY, 0.0f, halfHeight * (float)mod + 2.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.radCounters)).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.radCounters)).height + 1.0f);
                        g2.drawImage(FSkinImage.RAD, 0.0f, halfHeight * (float)mod + 2.0f, halfHeight, halfHeight);
                        g2.drawText(String.valueOf(this.radCounters), INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, halfHeight * (float)mod + 2.0f, textWidth, halfHeight, false, 8, false);
                        ++mod;
                    }
                    if (this.ticketCounters > 0) {
                        g2.fillRect(Color.DARK_GRAY, 0.0f, halfHeight * (float)mod + 2.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.ticketCounters)).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.ticketCounters)).height + 1.0f);
                        g2.drawImage(FSkinImage.TICKET, 0.0f, halfHeight * (float)mod + 2.0f, halfHeight, halfHeight);
                        g2.drawText(String.valueOf(this.ticketCounters), INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, halfHeight * (float)mod + 2.0f, textWidth, halfHeight, false, 8, false);
                        ++mod;
                    }
                    if (this.manaShards > 0) {
                        g2.fillRect(Color.DARK_GRAY, 0.0f, halfHeight * (float)mod + 2.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.manaShards)).width + halfHeight + 1.0f, INFO_FONT.getBounds((CharSequence)String.valueOf((int)this.manaShards)).height + 1.0f);
                        g2.drawImage(FSkinImage.AETHER_SHARD, 0.0f, halfHeight * (float)mod + 2.0f, halfHeight, halfHeight);
                        g2.drawText(String.valueOf(this.manaShards), INFO_FONT, VPlayerPanel.getInfoForeColor().getColor(), textStart, halfHeight * (float)mod + 2.0f, textWidth, halfHeight, false, 8, false);
                        ++mod;
                    }
                    VPlayerPanel.this.adjustHeight = mod > 2 && VPlayerPanel.this.avatar.getHeight() < halfHeight * (float)mod ? mod : 1;
                }
            } else if (this.poisonCounters == 0 && this.energyCounters == 0 && this.manaShards == 0) {
                g2.drawText(this.lifeStr, Forge.altZoneTabs ? LIFE_FONT_ALT : LIFE_FONT, VPlayerPanel.getInfoForeColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), false, 1, true);
            } else {
                float halfHeight = this.getHeight() / 2.0f;
                float textStart = halfHeight + Utils.scale(1.0f);
                float textWidth = this.getWidth() - textStart;
                g2.drawImage(FSkinImage.QUEST_LIFE, 0.0f, 0.0f, halfHeight, halfHeight);
                g2.drawText(this.lifeStr, INFO_FONT, VPlayerPanel.getInfoForeColor(), textStart, 0.0f, textWidth, halfHeight, false, 1, true);
                if (this.poisonCounters > 0) {
                    g2.drawImage(FSkinImage.POISON, 0.0f, halfHeight, halfHeight, halfHeight);
                    g2.drawText(String.valueOf(this.poisonCounters), INFO_FONT, VPlayerPanel.getInfoForeColor(), textStart, halfHeight, textWidth, halfHeight, false, 1, true);
                } else if (this.energyCounters > 0) {
                    g2.drawImage(FSkinImage.ENERGY, 0.0f, halfHeight, halfHeight, halfHeight);
                    g2.drawText(String.valueOf(this.energyCounters), INFO_FONT, VPlayerPanel.getInfoForeColor(), textStart, halfHeight, textWidth, halfHeight, false, 1, true);
                } else {
                    g2.drawImage(FSkinImage.MANASHARD, 0.0f, halfHeight, halfHeight, halfHeight);
                    g2.drawText(String.valueOf(this.manaShards), INFO_FONT, VPlayerPanel.getInfoForeColor(), textStart, halfHeight, textWidth, halfHeight, false, 1, true);
                }
            }
        }
    }
}

